/*
 * Decompiled with CFR 0.152.
 */
package org.jsampler.view;

import javax.swing.table.AbstractTableModel;
import org.jsampler.SamplerChannelModel;
import org.jsampler.event.EffectSendsEvent;
import org.jsampler.event.EffectSendsListener;
import org.linuxsampler.lscp.FxSend;

public class FxSendTableModel
extends AbstractTableModel {
    private SamplerChannelModel channelModel;
    private final Handler eventHandler = new Handler();

    public FxSendTableModel(SamplerChannelModel samplerChannelModel) {
        if (samplerChannelModel == null) {
            throw new IllegalArgumentException("channelModel should be non-null!");
        }
        this.channelModel = samplerChannelModel;
        samplerChannelModel.addEffectSendsListener(this.getHandler());
    }

    @Override
    public int getColumnCount() {
        return 1;
    }

    @Override
    public int getRowCount() {
        return this.channelModel.getFxSendCount();
    }

    @Override
    public String getColumnName(int n) {
        return " ";
    }

    @Override
    public Object getValueAt(int n, int n2) {
        return this.channelModel.getFxSend(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        if (object.toString().isEmpty()) {
            return;
        }
        FxSend fxSend = this.channelModel.getFxSend(n);
        this.channelModel.setBackendFxSendName(fxSend.getFxSendId(), object.toString());
        fxSend.setName(object.toString());
        this.fireTableCellUpdated(n, n2);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return n2 == 0;
    }

    public FxSend getFxSend(int n) {
        return this.channelModel.getFxSend(n);
    }

    public int getFxSendPosition(FxSend fxSend) {
        if (fxSend == null) {
            return -1;
        }
        for (int i = 0; i < this.channelModel.getFxSendCount(); ++i) {
            if (this.channelModel.getFxSend(i).getFxSendId() != fxSend.getFxSendId()) continue;
            return i;
        }
        return -1;
    }

    private Handler getHandler() {
        return this.eventHandler;
    }

    private class Handler
    implements EffectSendsListener {
        private Handler() {
        }

        @Override
        public void effectSendAdded(EffectSendsEvent effectSendsEvent) {
            FxSendTableModel.this.fireTableDataChanged();
        }

        @Override
        public void effectSendRemoved(EffectSendsEvent effectSendsEvent) {
            FxSendTableModel.this.fireTableDataChanged();
        }

        @Override
        public void effectSendChanged(EffectSendsEvent effectSendsEvent) {
            for (int i = 0; i < FxSendTableModel.this.getRowCount(); ++i) {
                if (!effectSendsEvent.getFxSend().equals(FxSendTableModel.this.getValueAt(i, 0))) continue;
                FxSendTableModel.this.fireTableRowsUpdated(i, i);
                return;
            }
        }
    }
}

