/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.validate.validators;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.keycloak.models.KeycloakSession;
import org.keycloak.provider.ConfiguredProvider;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.validate.AbstractStringValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidationResult;
import org.keycloak.validate.ValidatorConfig;

public class PatternValidator
extends AbstractStringValidator
implements ConfiguredProvider {
    public static final String ID = "pattern";
    public static final PatternValidator INSTANCE = new PatternValidator();
    public static final String CFG_PATTERN = "pattern";
    public static final String MESSAGE_NO_MATCH = "error-pattern-no-match";
    public static final String CFG_ERROR_MESSAGE = "error-message";
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();

    public String getId() {
        return "pattern";
    }

    protected void doValidate(String value, String inputHint, ValidationContext context, ValidatorConfig config) {
        Pattern pattern = config.getPattern("pattern");
        if (!pattern.matcher(value).matches()) {
            context.addError(new ValidationError("pattern", inputHint, config.getStringOrDefault(CFG_ERROR_MESSAGE, MESSAGE_NO_MATCH), new Object[]{config.getString("pattern")}));
        }
    }

    public ValidationResult validateConfig(KeycloakSession session, ValidatorConfig config) {
        LinkedHashSet<ValidationError> errors = new LinkedHashSet<ValidationError>();
        if (config == null || config == ValidatorConfig.EMPTY || !config.containsKey("pattern")) {
            errors.add(new ValidationError("pattern", "pattern", "error-validator-config-missing-value"));
        } else {
            Object maybePattern = config.get("pattern");
            try {
                Pattern pattern = config.getPattern("pattern");
                if (pattern == null) {
                    errors.add(new ValidationError("pattern", "pattern", "error-validator-config-invalid-value", new Object[]{maybePattern}));
                }
            }
            catch (PatternSyntaxException pse) {
                errors.add(new ValidationError("pattern", "pattern", "error-validator-config-invalid-value", new Object[]{maybePattern, pse.getMessage()}));
            }
        }
        return new ValidationResult(errors);
    }

    public String getHelpText() {
        return "RegExp Pattern validator";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    static {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName("pattern");
        property.setLabel("RegExp pattern");
        property.setHelpText("RegExp pattern the value must match. Java Pattern syntax is used.");
        property.setType("String");
        configProperties.add(property);
        property = new ProviderConfigProperty();
        property.setName(CFG_ERROR_MESSAGE);
        property.setLabel("Error message key");
        property.setHelpText("Key of the error message in i18n bundle. Default message key is error-pattern-no-match");
        property.setType("String");
        configProperties.add(property);
    }
}

