/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.namenode;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.DFSUtilClient;
import org.apache.hadoop.hdfs.HAUtil;
import org.apache.hadoop.hdfs.server.aliasmap.InMemoryAliasMap;
import org.apache.hadoop.hdfs.server.common.Storage;
import org.apache.hadoop.hdfs.server.common.StorageInfo;
import org.apache.hadoop.hdfs.server.namenode.CheckpointFaultInjector;
import org.apache.hadoop.hdfs.server.namenode.FSImage;
import org.apache.hadoop.hdfs.server.namenode.NNStorage;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.namenode.NameNodeHttpServer;
import org.apache.hadoop.hdfs.server.namenode.SecondaryNameNode;
import org.apache.hadoop.hdfs.server.namenode.TransferFsImage;
import org.apache.hadoop.hdfs.server.namenode.metrics.NameNodeMetrics;
import org.apache.hadoop.hdfs.server.protocol.RemoteEditLog;
import org.apache.hadoop.hdfs.util.DataTransferThrottler;
import org.apache.hadoop.hdfs.util.MD5FileUtils;
import org.apache.hadoop.http.HttpServer2;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.thirdparty.com.google.common.base.Preconditions;
import org.apache.hadoop.util.ServletUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.util.Time;
import org.eclipse.jetty.server.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ImageServlet
extends HttpServlet {
    public static final String PATH_SPEC = "/imagetransfer";
    private static final long serialVersionUID = -7669068179452648952L;
    private static final Logger LOG = LoggerFactory.getLogger(ImageServlet.class);
    public static final String CONTENT_DISPOSITION = "Content-Disposition";
    public static final String HADOOP_IMAGE_EDITS_HEADER = "X-Image-Edits-Name";
    private static final String TXID_PARAM = "txid";
    private static final String START_TXID_PARAM = "startTxId";
    private static final String END_TXID_PARAM = "endTxId";
    private static final String STORAGEINFO_PARAM = "storageInfo";
    private static final String LATEST_FSIMAGE_VALUE = "latest";
    private static final String IMAGE_FILE_TYPE = "imageFile";
    private static final String IS_BOOTSTRAP_STANDBY = "bootstrapstandby";
    private SortedSet<ImageUploadRequest> currentlyDownloadingCheckpoints = Collections.synchronizedSortedSet(new TreeSet());
    public static final String RECENT_IMAGE_CHECK_ENABLED = "recent.image.check.enabled";
    public static final boolean RECENT_IMAGE_CHECK_ENABLED_DEFAULT = true;
    private static double recentImageCheckTimePrecision = 0.75;

    @VisibleForTesting
    static void setRecentImageCheckTimePrecision(double ratio) {
        recentImageCheckTimePrecision = ratio;
    }

    private FSImage getAndValidateFSImage(ServletContext context, HttpServletResponse response) throws IOException {
        FSImage nnImage = NameNodeHttpServer.getFsImageFromContext(context);
        if (nnImage == null) {
            String errorMsg = "NameNode initialization not yet complete. FSImage has not been set in the NameNode.";
            this.sendError(response, 403, errorMsg);
            throw new IOException(errorMsg);
        }
        return nnImage;
    }

    public void doGet(HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        try {
            final ServletContext context = this.getServletContext();
            final FSImage nnImage = this.getAndValidateFSImage(context, response);
            final GetImageParams parsedParams = new GetImageParams(request, response);
            final Configuration conf = (Configuration)context.getAttribute("current.conf");
            final NameNodeMetrics metrics = NameNode.getNameNodeMetrics();
            this.validateRequest(context, conf, request, response, nnImage, parsedParams.getStorageInfoString());
            UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    if (parsedParams.isGetImage()) {
                        long txid = parsedParams.getTxId();
                        File imageFile = null;
                        String errorMessage = "Could not find image";
                        if (parsedParams.shouldFetchLatest()) {
                            imageFile = nnImage.getStorage().getHighestFsImageName();
                        } else {
                            errorMessage = errorMessage + " with txid " + txid;
                            imageFile = nnImage.getStorage().getFsImage(txid, EnumSet.of(NNStorage.NameNodeFile.IMAGE, NNStorage.NameNodeFile.IMAGE_ROLLBACK));
                        }
                        if (imageFile == null) {
                            throw new IOException(errorMessage);
                        }
                        CheckpointFaultInjector.getInstance().beforeGetImageSetsHeaders();
                        long start = Time.monotonicNow();
                        this.serveFile(imageFile);
                        if (metrics != null) {
                            long elapsed = Time.monotonicNow() - start;
                            metrics.addGetImage(elapsed);
                        }
                    } else if (parsedParams.isGetEdit()) {
                        long startTxId = parsedParams.getStartTxId();
                        long endTxId = parsedParams.getEndTxId();
                        File editFile = nnImage.getStorage().findFinalizedEditsFile(startTxId, endTxId);
                        long start = Time.monotonicNow();
                        this.serveFile(editFile);
                        if (metrics != null) {
                            long elapsed = Time.monotonicNow() - start;
                            metrics.addGetEdit(elapsed);
                        }
                    } else if (parsedParams.isGetAliasMap()) {
                        InMemoryAliasMap aliasMap = NameNodeHttpServer.getAliasMapFromContext(context);
                        long start = Time.monotonicNow();
                        InMemoryAliasMap.transferForBootstrap(response, conf, aliasMap);
                        if (metrics != null) {
                            long elapsed = Time.monotonicNow() - start;
                            metrics.addGetAliasMap(elapsed);
                        }
                    }
                    return null;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void serveFile(File file) throws IOException {
                    FileInputStream fis = new FileInputStream(file);
                    try {
                        ImageServlet.setVerificationHeadersForGet(response, file);
                        ImageServlet.setFileNameHeaders(response, file);
                        if (!file.exists()) {
                            throw new FileNotFoundException(file.toString());
                        }
                        DataTransferThrottler throttler = parsedParams.isBootstrapStandby ? ImageServlet.getThrottlerForBootstrapStandby(conf) : ImageServlet.getThrottler(conf);
                        TransferFsImage.copyFileToStream((OutputStream)response.getOutputStream(), file, fis, throttler);
                    }
                    finally {
                        IOUtils.closeStream((Closeable)fis);
                    }
                }
            });
        }
        catch (Throwable t) {
            String errMsg = "GetImage failed. " + StringUtils.stringifyException((Throwable)t);
            this.sendError(response, 410, errMsg);
            throw new IOException(errMsg);
        }
        finally {
            response.getOutputStream().close();
        }
    }

    private void validateRequest(ServletContext context, Configuration conf, HttpServletRequest request, HttpServletResponse response, FSImage nnImage, String theirStorageInfoString) throws IOException {
        if (UserGroupInformation.isSecurityEnabled() && !ImageServlet.isValidRequestor(context, request.getUserPrincipal().getName(), conf)) {
            String errorMsg = "Only Namenode, Secondary Namenode, and administrators may access this servlet";
            this.sendError(response, 403, errorMsg);
            LOG.warn("Received non-NN/SNN/administrator request for image or edits from " + request.getUserPrincipal().getName() + " at " + request.getRemoteHost());
            throw new IOException(errorMsg);
        }
        String myStorageInfoString = nnImage.getStorage().toColonSeparatedString();
        if (theirStorageInfoString != null && !myStorageInfoString.equals(theirStorageInfoString)) {
            String errorMsg = "This namenode has storage info " + myStorageInfoString + " but the secondary expected " + theirStorageInfoString;
            this.sendError(response, 403, errorMsg);
            LOG.warn("Received an invalid request file transfer request from a secondary with storage info " + theirStorageInfoString);
            throw new IOException(errorMsg);
        }
    }

    public static void setFileNameHeaders(HttpServletResponse response, File file) {
        response.setHeader(CONTENT_DISPOSITION, "attachment; filename=" + file.getName());
        response.setHeader(HADOOP_IMAGE_EDITS_HEADER, file.getName());
    }

    public static DataTransferThrottler getThrottler(Configuration conf) {
        long transferBandwidth = conf.getLongBytes("dfs.image.transfer.bandwidthPerSec", 0x3200000L);
        DataTransferThrottler throttler = null;
        if (transferBandwidth > 0L) {
            throttler = new DataTransferThrottler(transferBandwidth);
        }
        return throttler;
    }

    public static DataTransferThrottler getThrottlerForBootstrapStandby(Configuration conf) {
        long transferBandwidth = conf.getLongBytes("dfs.image.transfer-bootstrap-standby.bandwidthPerSec", 0L);
        DataTransferThrottler throttler = null;
        if (transferBandwidth > 0L) {
            throttler = new DataTransferThrottler(transferBandwidth);
        }
        return throttler;
    }

    @VisibleForTesting
    static boolean isValidRequestor(ServletContext context, String remoteUser, Configuration conf) throws IOException {
        if (remoteUser == null) {
            LOG.warn("Received null remoteUser while authorizing access to getImage servlet");
            return false;
        }
        HashSet<String> validRequestors = new HashSet<String>();
        validRequestors.add(SecurityUtil.getServerPrincipal((String)conf.get("dfs.namenode.kerberos.principal"), (String)DFSUtilClient.getNNAddress((Configuration)conf).getHostName()));
        try {
            validRequestors.add(SecurityUtil.getServerPrincipal((String)conf.get("dfs.secondary.namenode.kerberos.principal"), (String)SecondaryNameNode.getHttpAddress(conf).getHostName()));
        }
        catch (Exception e) {
            LOG.debug("SecondaryNameNode principal could not be added", (Throwable)e);
            String msg = String.format("SecondaryNameNode principal not considered, %s = %s, %s = %s", "dfs.secondary.namenode.kerberos.principal", conf.get("dfs.secondary.namenode.kerberos.principal"), "dfs.namenode.secondary.http-address", conf.getTrimmed("dfs.namenode.secondary.http-address", "0.0.0.0:9868"));
            LOG.warn(msg);
        }
        if (HAUtil.isHAEnabled(conf, DFSUtil.getNamenodeNameServiceId(conf))) {
            List<Configuration> otherNnConfs = HAUtil.getConfForOtherNodes(conf);
            for (Configuration otherNnConf : otherNnConfs) {
                validRequestors.add(SecurityUtil.getServerPrincipal((String)otherNnConf.get("dfs.namenode.kerberos.principal"), (String)DFSUtilClient.getNNAddress((Configuration)otherNnConf).getHostName()));
            }
        }
        for (String v : validRequestors) {
            if (v == null || !v.equals(remoteUser)) continue;
            LOG.info("ImageServlet allowing checkpointer: " + remoteUser);
            return true;
        }
        if (HttpServer2.userHasAdministratorAccess((ServletContext)context, (String)remoteUser)) {
            LOG.info("ImageServlet allowing administrator: " + remoteUser);
            return true;
        }
        LOG.info("ImageServlet rejecting: " + remoteUser);
        return false;
    }

    public static void setVerificationHeadersForGet(HttpServletResponse response, File file) throws IOException {
        response.setHeader("Content-Length", String.valueOf(file.length()));
        MD5Hash hash = MD5FileUtils.readStoredMd5ForFile(file);
        if (hash != null) {
            response.setHeader("X-MD5-Digest", hash.toString());
        }
    }

    static String getParamStringForMostRecentImage() {
        return "getimage=1&txid=latest";
    }

    static String getParamStringForImage(NNStorage.NameNodeFile nnf, long txid, StorageInfo remoteStorageInfo, boolean isBootstrapStandby) {
        String imageType = nnf == null ? "" : "&imageFile=" + nnf.name();
        return "getimage=1&txid=" + txid + imageType + "&" + STORAGEINFO_PARAM + "=" + remoteStorageInfo.toColonSeparatedString() + "&" + IS_BOOTSTRAP_STANDBY + "=" + isBootstrapStandby;
    }

    static String getParamStringForLog(RemoteEditLog log, StorageInfo remoteStorageInfo) {
        return "getedit=1&startTxId=" + log.getStartTxId() + "&" + END_TXID_PARAM + "=" + log.getEndTxId() + "&" + STORAGEINFO_PARAM + "=" + remoteStorageInfo.toColonSeparatedString();
    }

    static String getParamStringForAliasMap(boolean isBootstrapStandby) {
        return "getaliasmap=1&bootstrapstandby=" + isBootstrapStandby;
    }

    static void setVerificationHeadersForPut(HttpURLConnection connection, File file) throws IOException {
        connection.setRequestProperty("Content-Length", String.valueOf(file.length()));
        MD5Hash hash = MD5FileUtils.readStoredMd5ForFile(file);
        if (hash != null) {
            connection.setRequestProperty("X-MD5-Digest", hash.toString());
        }
    }

    static Map<String, String> getParamsForPutImage(Storage storage, long txid, long imageFileSize, NNStorage.NameNodeFile nnf) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(TXID_PARAM, Long.toString(txid));
        params.put(STORAGEINFO_PARAM, storage.toColonSeparatedString());
        params.put("File-Length", Long.toString(imageFileSize));
        params.put(IMAGE_FILE_TYPE, nnf.name());
        return params;
    }

    protected void doPut(final HttpServletRequest request, final HttpServletResponse response) throws ServletException, IOException {
        try {
            boolean checkRecentImageEnable;
            ServletContext context = this.getServletContext();
            final FSImage nnImage = this.getAndValidateFSImage(context, response);
            final Configuration conf = (Configuration)this.getServletContext().getAttribute("current.conf");
            final PutImageParams parsedParams = new PutImageParams(request, response, conf);
            final NameNodeMetrics metrics = NameNode.getNameNodeMetrics();
            Object checkRecentImageEnableObj = context.getAttribute(RECENT_IMAGE_CHECK_ENABLED);
            if (checkRecentImageEnableObj != null) {
                if (checkRecentImageEnableObj instanceof Boolean) {
                    checkRecentImageEnable = (Boolean)checkRecentImageEnableObj;
                } else {
                    LOG.error("Expecting boolean obj for setting checking recent image, but got " + checkRecentImageEnableObj.getClass() + ". This is unexpected! Setting to default.");
                    checkRecentImageEnable = true;
                }
            } else {
                checkRecentImageEnable = true;
            }
            this.validateRequest(context, conf, request, response, nnImage, parsedParams.getStorageInfoString());
            UserGroupInformation.getCurrentUser().doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public Void run() throws Exception {
                    HAServiceProtocol.HAServiceState state = NameNodeHttpServer.getNameNodeStateFromContext(ImageServlet.this.getServletContext());
                    if (state != HAServiceProtocol.HAServiceState.ACTIVE && state != HAServiceProtocol.HAServiceState.OBSERVER) {
                        ImageServlet.this.sendError(response, 417, "Nameode " + request.getLocalAddr() + " is currently not in a state which can accept uploads of new fsimages. State: " + state);
                        return null;
                    }
                    long txid = parsedParams.getTxId();
                    String remoteAddr = request.getRemoteAddr();
                    ImageUploadRequest imageRequest = new ImageUploadRequest(txid, remoteAddr);
                    NNStorage.NameNodeFile nnf = parsedParams.getNameNodeFile();
                    SortedSet<ImageUploadRequest> larger = ImageServlet.this.currentlyDownloadingCheckpoints.tailSet(imageRequest);
                    if (larger.size() > 0) {
                        ImageServlet.this.sendError(response, 409, "Another checkpointer is already in the process of uploading a checkpoint made up to transaction ID " + larger.last());
                        return null;
                    }
                    if (!ImageServlet.this.currentlyDownloadingCheckpoints.add(imageRequest)) {
                        ImageServlet.this.sendError(response, 409, "Either current namenode is checkpointing or another checkpointer is already in the process of uploading a checkpoint made at transaction ID " + txid);
                        return null;
                    }
                    long now = System.currentTimeMillis();
                    long lastCheckpointTime = nnImage.getStorage().getMostRecentCheckpointTime();
                    long lastCheckpointTxid = nnImage.getStorage().getMostRecentCheckpointTxId();
                    long checkpointPeriod = conf.getTimeDuration("dfs.namenode.checkpoint.period", 3600L, TimeUnit.SECONDS);
                    checkpointPeriod = Math.round((double)checkpointPeriod * recentImageCheckTimePrecision);
                    long checkpointTxnCount = conf.getLong("dfs.namenode.checkpoint.txns", 1000000L);
                    long timeDelta = TimeUnit.MILLISECONDS.toSeconds(now - lastCheckpointTime);
                    if (checkRecentImageEnable && NNStorage.NameNodeFile.IMAGE.equals((Object)parsedParams.getNameNodeFile()) && timeDelta < checkpointPeriod && txid - lastCheckpointTxid < checkpointTxnCount) {
                        String message = "Rejecting a fsimage due to small time delta and txnid delta. Time since previous checkpoint is " + timeDelta + " expecting at least " + checkpointPeriod + " txnid delta since previous checkpoint is " + (txid - lastCheckpointTxid) + " expecting at least " + checkpointTxnCount;
                        LOG.info(message);
                        ImageServlet.this.sendError(response, 409, message);
                        return null;
                    }
                    try {
                        if (nnImage.getStorage().findImageFile(nnf, txid) != null) {
                            String message = "Either current namenode has checkpointed or another checkpointer already uploaded an checkpoint for txid " + txid;
                            LOG.info(message);
                            ImageServlet.this.sendError(response, 409, message);
                            Void void_ = null;
                            return void_;
                        }
                        ServletInputStream stream = request.getInputStream();
                        try {
                            long start = Time.monotonicNow();
                            MD5Hash downloadImageDigest = TransferFsImage.handleUploadImageRequest(request, txid, nnImage.getStorage(), (InputStream)stream, parsedParams.getFileSize(), ImageServlet.getThrottler(conf));
                            nnImage.saveDigestAndRenameCheckpointImage(nnf, txid, downloadImageDigest);
                            if (metrics != null) {
                                long elapsed = Time.monotonicNow() - start;
                                metrics.addPutImage(elapsed);
                            }
                            nnImage.purgeOldStorage(nnf);
                        }
                        finally {
                            ImageServlet.this.currentlyDownloadingCheckpoints.remove(imageRequest);
                            stream.close();
                        }
                    }
                    finally {
                        nnImage.removeFromCheckpointing(txid);
                    }
                    return null;
                }
            });
        }
        catch (Throwable t) {
            String errMsg = "PutImage failed. " + StringUtils.stringifyException((Throwable)t);
            this.sendError(response, 410, errMsg);
            throw new IOException(errMsg);
        }
    }

    private void sendError(HttpServletResponse response, int code, String message) throws IOException {
        if (response instanceof Response) {
            ((Response)response).setStatusWithReason(code, message);
        }
        response.sendError(code, message);
    }

    private static class ImageUploadRequest
    implements Comparable<ImageUploadRequest> {
        private final long txId;
        private final String address;

        public ImageUploadRequest(long txid, String remoteAddr) {
            this.txId = txid;
            this.address = remoteAddr;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ImageUploadRequest that = (ImageUploadRequest)o;
            if (this.txId != that.txId) {
                return false;
            }
            return this.address.equals(that.address);
        }

        public int hashCode() {
            int result = (int)(this.txId ^ this.txId >>> 32);
            result = 31 * result + this.address.hashCode();
            return result;
        }

        @Override
        public int compareTo(ImageUploadRequest other) {
            return Long.compare(this.txId, other.txId);
        }

        public String toString() {
            return "ImageRequest{txId=" + this.txId + ", address='" + this.address + '\'' + '}';
        }
    }

    static class PutImageParams {
        private long txId = -1L;
        private String storageInfoString = null;
        private long fileSize = 0L;
        private NNStorage.NameNodeFile nnf;

        public PutImageParams(HttpServletRequest request, HttpServletResponse response, Configuration conf) throws IOException {
            this.txId = ServletUtil.parseLongParam((ServletRequest)request, (String)ImageServlet.TXID_PARAM);
            this.storageInfoString = ServletUtil.getParameter((ServletRequest)request, (String)ImageServlet.STORAGEINFO_PARAM);
            this.fileSize = ServletUtil.parseLongParam((ServletRequest)request, (String)"File-Length");
            String imageType = ServletUtil.getParameter((ServletRequest)request, (String)ImageServlet.IMAGE_FILE_TYPE);
            NNStorage.NameNodeFile nameNodeFile = this.nnf = imageType == null ? NNStorage.NameNodeFile.IMAGE : NNStorage.NameNodeFile.valueOf(imageType);
            if (this.fileSize == 0L || this.txId == -1L || this.storageInfoString == null || this.storageInfoString.isEmpty()) {
                throw new IOException("Illegal parameters to TransferFsImage");
            }
        }

        public long getTxId() {
            return this.txId;
        }

        public String getStorageInfoString() {
            return this.storageInfoString;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public NNStorage.NameNodeFile getNameNodeFile() {
            return this.nnf;
        }
    }

    static class GetImageParams {
        private boolean isGetImage;
        private boolean isGetEdit;
        private NNStorage.NameNodeFile nnf;
        private long startTxId;
        private long endTxId;
        private long txId;
        private String storageInfoString;
        private boolean fetchLatest;
        private boolean isBootstrapStandby;
        private boolean isGetAliasMap;

        public GetImageParams(HttpServletRequest request, HttpServletResponse response) throws IOException {
            Map pmap = request.getParameterMap();
            this.isBootstrapStandby = false;
            this.fetchLatest = false;
            this.isGetEdit = false;
            this.isGetImage = false;
            for (Map.Entry entry : pmap.entrySet()) {
                String key = (String)entry.getKey();
                String[] val = (String[])entry.getValue();
                if (key.equals("getimage")) {
                    this.isGetImage = true;
                    try {
                        this.txId = ServletUtil.parseLongParam((ServletRequest)request, (String)ImageServlet.TXID_PARAM);
                        String imageType = ServletUtil.getParameter((ServletRequest)request, (String)ImageServlet.IMAGE_FILE_TYPE);
                        this.nnf = imageType == null ? NNStorage.NameNodeFile.IMAGE : NNStorage.NameNodeFile.valueOf(imageType);
                        String bootstrapStandby = ServletUtil.getParameter((ServletRequest)request, (String)ImageServlet.IS_BOOTSTRAP_STANDBY);
                        this.isBootstrapStandby = bootstrapStandby != null && Boolean.parseBoolean(bootstrapStandby);
                        continue;
                    }
                    catch (NumberFormatException nfe) {
                        if (request.getParameter(ImageServlet.TXID_PARAM).equals(ImageServlet.LATEST_FSIMAGE_VALUE)) {
                            this.fetchLatest = true;
                            continue;
                        }
                        throw nfe;
                    }
                }
                if (key.equals("getedit")) {
                    this.isGetEdit = true;
                    this.startTxId = ServletUtil.parseLongParam((ServletRequest)request, (String)ImageServlet.START_TXID_PARAM);
                    this.endTxId = ServletUtil.parseLongParam((ServletRequest)request, (String)ImageServlet.END_TXID_PARAM);
                    continue;
                }
                if (key.equals(ImageServlet.STORAGEINFO_PARAM)) {
                    this.storageInfoString = val[0];
                    continue;
                }
                if (!key.equals("getaliasmap")) continue;
                this.isGetAliasMap = true;
                String bootstrapStandby = ServletUtil.getParameter((ServletRequest)request, (String)ImageServlet.IS_BOOTSTRAP_STANDBY);
                this.isBootstrapStandby = bootstrapStandby != null && Boolean.parseBoolean(bootstrapStandby);
            }
            int numGets = (this.isGetImage ? 1 : 0) + (this.isGetEdit ? 1 : 0) + (this.isGetAliasMap ? 1 : 0);
            if (numGets > 1 || numGets == 0) {
                throw new IOException("Illegal parameters to TransferFsImage");
            }
        }

        public String getStorageInfoString() {
            return this.storageInfoString;
        }

        public long getTxId() {
            Preconditions.checkState((boolean)this.isGetImage);
            return this.txId;
        }

        public NNStorage.NameNodeFile getNameNodeFile() {
            Preconditions.checkState((boolean)this.isGetImage);
            return this.nnf;
        }

        public long getStartTxId() {
            Preconditions.checkState((boolean)this.isGetEdit);
            return this.startTxId;
        }

        public long getEndTxId() {
            Preconditions.checkState((boolean)this.isGetEdit);
            return this.endTxId;
        }

        boolean isGetEdit() {
            return this.isGetEdit;
        }

        boolean isGetImage() {
            return this.isGetImage;
        }

        boolean shouldFetchLatest() {
            return this.fetchLatest;
        }

        boolean isGetAliasMap() {
            return this.isGetAliasMap;
        }
    }
}

