/*
 * Decompiled with CFR 0.152.
 */
package hughai.packcoordinators;

import com.springrts.ai.oo.clb.Unit;
import com.springrts.ai.oo.clb.UnitDef;
import hughai.GameAdapter;
import hughai.PlayerObjects;
import hughai.basictypes.Float3;
import hughai.basictypes.TerrainPos;
import hughai.mapping.LosMap;
import hughai.mapping.MovementMaps;
import hughai.packcoordinators.PackCoordinator;
import hughai.unitdata.UnitController;
import hughai.utils.Cache;
import hughai.utils.Config;
import java.util.HashMap;
import java.util.HashSet;

public class SpreadSearchPackCoordinatorWithSearchGrid
extends PackCoordinator {
    TerrainPos targetpos;
    HashSet<Unit> moveFailed = new HashSet();
    HashMap<Unit, TerrainPos> lastPosByUnit = new HashMap();
    HashMap<Unit, Integer> stuckCountByUnit = new HashMap();
    Cache<Unit> unitsinselfdestruct = new Cache(180);
    PlayerObjects playerObjects;
    UnitController unitController;
    Config config;
    int recentmeansnumframes = 5000;
    int mapwidth;
    int mapheight;
    boolean restartedfrompause = true;
    Float3 lasttargetpos = null;
    HashMap<Unit, Integer> lastexploretime = new HashMap();

    public SpreadSearchPackCoordinatorWithSearchGrid(PlayerObjects playerObjects) {
        super(playerObjects);
        this.playerObjects = playerObjects;
        this.unitController = playerObjects.getUnitController();
        this.config = playerObjects.getConfig();
        this.mapwidth = this.aicallback.getMap().getWidth();
        this.mapheight = this.aicallback.getMap().getHeight();
        this.csai.registerGameListener(new GameListenerHandler());
    }

    @Override
    public void SetTarget(TerrainPos terrainPos) {
        this.targetpos = terrainPos;
    }

    @Override
    public void Activate() {
        if (!this.activated) {
            this.logfile.WriteLine("SpreadSearchPackCoordinatorWithSearchGrid initiating spreadsearch");
            this.activated = true;
            this.restartedfrompause = true;
            this.Recoordinate();
        }
    }

    @Override
    public void Disactivate() {
        if (this.activated) {
            this.activated = false;
            this.logfile.WriteLine("SpreadSearchPackCoordinatorWithSearchGrid shutting down");
            this.csai.UnregisterVoiceCommand("dumpsearchgrid");
        }
    }

    @Override
    void Recoordinate() {
        if (!this.activated) {
            return;
        }
        int n = this.playerObjects.getFrameController().getFrame();
        for (Unit unit : this.unitsControlled) {
            boolean bl = false;
            if (this.restartedfrompause) {
                this.logfile.WriteLine("SpreadSearchPackCoordinatorWithSearchGrid.Explorewith() reason: restartedfrompause " + unit.getUnitId());
                this.ExploreWith(unit, false);
            } else if (this.unitController.getPos(unit).equals(this.lastPosByUnit.get(unit))) {
                this.logfile.WriteLine("SpreadSearchPackCoordinatorWithSearchGrid.Explorewith() reason: hasn't moved " + unit.getUnitId());
                bl = true;
                if (!this.stuckCountByUnit.containsKey(unit) || this.stuckCountByUnit.get(unit) <= 10) {
                    this.ExploreWith(unit, true);
                }
            }
            if (bl) {
                if (this.stuckCountByUnit.containsKey(unit)) {
                    this.stuckCountByUnit.put(unit, this.stuckCountByUnit.get(unit) + 1);
                    if (this.stuckCountByUnit.get(unit) > 10) {
                        this.logfile.WriteLine("stuck count for " + unit.getUnitId() + " " + this.unitController.getUnitDef(unit).getHumanName() + " too high: self-destructing.");
                        if (!this.unitsinselfdestruct.isInCache(n, unit)) {
                            this.giveOrderWrapper.SelfDestruct(unit);
                            this.unitsinselfdestruct.cache(n, unit);
                        }
                    }
                } else {
                    this.stuckCountByUnit.put(unit, 1);
                }
            } else {
                this.stuckCountByUnit.remove(unit);
            }
            this.lastPosByUnit.put(unit, this.unitController.getPos(unit));
        }
        this.restartedfrompause = false;
        this.moveFailed.clear();
    }

    void HandleMoveFailed() {
        for (Unit unit : this.moveFailed) {
            this.logfile.WriteLine("Triggering new explore for move failed unit " + unit.getUnitId() + " " + this.unitController.getUnitDef(unit).getHumanName());
            this.ExploreWith(unit, true);
        }
        this.moveFailed.clear();
    }

    public void ExploreWith(Unit unit, boolean bl) {
        if (this.lastexploretime.containsKey(unit) && this.playerObjects.getFrameController().getFrame() - this.lastexploretime.get(unit) < 30) {
            return;
        }
        boolean bl2 = false;
        TerrainPos terrainPos = this.unitController.getPos(unit);
        MovementMaps movementMaps = this.maps.getMovementMaps();
        UnitDef unitDef = this.unitController.getUnitDef(unit);
        int n = movementMaps.GetArea(unitDef, terrainPos);
        LosMap losMap = this.maps.getLosMap();
        if (this.csai.DebugOn) {
            this.logfile.WriteLine("SpreadSearchWithSearchGrid explorewith unit " + unit.getUnitId() + " " + unitDef.getHumanName() + " area: " + n);
        }
        TerrainPos terrainPos2 = null;
        if (!bl) {
            terrainPos2 = this.losHelper.GetNearestUnseen(terrainPos, unitDef, 12000);
        }
        if (terrainPos2 == null) {
            terrainPos2 = this.GetRandomDestination(n);
        }
        if (terrainPos2 == null) {
            return;
        }
        this.lastexploretime.put(unit, this.playerObjects.getFrameController().getFrame());
        this.giveOrderWrapper.MoveTo(unit, terrainPos2);
        if (this.config.isDebug().booleanValue()) {
            this.drawingUtils.AddLine(terrainPos, terrainPos2);
            this.drawingUtils.DrawUnit(this.config.getSpreadsearchnextmovemarkerunitname(), terrainPos2);
        }
    }

    TerrainPos GetRandomDestination(int n) {
        for (int i = 20; i > 0; --i) {
            TerrainPos terrainPos = new TerrainPos();
            float f = this.random.nextFloat() * (float)this.aicallback.getMap().getWidth();
            this.maps.getMovementMaps().getClass();
            terrainPos.x = f * 8.0f;
            float f2 = this.random.nextFloat() * (float)this.aicallback.getMap().getHeight();
            this.maps.getMovementMaps().getClass();
            terrainPos.z = f2 * 8.0f;
            terrainPos.y = this.aicallback.getMap().getElevationAt(terrainPos.x, terrainPos.y);
            int n2 = this.maps.getMovementMaps().GetVehicleArea(terrainPos);
            if (n2 != n) continue;
            return terrainPos;
        }
        return null;
    }

    class GameListenerHandler
    extends GameAdapter {
        int totalticks = 0;

        GameListenerHandler() {
        }

        @Override
        public void Tick(int n) {
            ++this.totalticks;
            SpreadSearchPackCoordinatorWithSearchGrid.this.Recoordinate();
        }

        @Override
        public void UnitIdle(Unit unit) {
            if (SpreadSearchPackCoordinatorWithSearchGrid.this.activated && SpreadSearchPackCoordinatorWithSearchGrid.this.unitsControlled.contains(unit)) {
                SpreadSearchPackCoordinatorWithSearchGrid.this.ExploreWith(unit, false);
            }
        }

        @Override
        public void UnitMoveFailed(Unit unit) {
            if (SpreadSearchPackCoordinatorWithSearchGrid.this.activated && SpreadSearchPackCoordinatorWithSearchGrid.this.unitsControlled.contains(unit) && !SpreadSearchPackCoordinatorWithSearchGrid.this.moveFailed.contains(unit)) {
                SpreadSearchPackCoordinatorWithSearchGrid.this.moveFailed.add(unit);
                SpreadSearchPackCoordinatorWithSearchGrid.this.csai.sendTextMessage("Move failed for " + unit.getUnitId() + " " + SpreadSearchPackCoordinatorWithSearchGrid.this.unitController.getUnitDef(unit).getHumanName());
            }
        }
    }
}

