package Google::Ads::AdWords::v201809::UniversalAppCampaignInfo;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'https://adwords.google.com/api/adwords/cm/v201809' };

our $XML_ATTRIBUTE_CLASS;
undef $XML_ATTRIBUTE_CLASS;

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use Class::Std::Fast::Storable constructor => 'none';
use base qw(Google::Ads::SOAP::Typelib::ComplexType);

{ # BLOCK to scope variables

my %biddingStrategyGoalType_of :ATTR(:get<biddingStrategyGoalType>);
my %appId_of :ATTR(:get<appId>);
my %appVendor_of :ATTR(:get<appVendor>);

__PACKAGE__->_factory(
    [ qw(        biddingStrategyGoalType
        appId
        appVendor

    ) ],
    {
        'biddingStrategyGoalType' => \%biddingStrategyGoalType_of,
        'appId' => \%appId_of,
        'appVendor' => \%appVendor_of,
    },
    {
        'biddingStrategyGoalType' => 'Google::Ads::AdWords::v201809::UniversalAppBiddingStrategyGoalType',
        'appId' => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        'appVendor' => 'Google::Ads::AdWords::v201809::MobileApplicationVendor',
    },
    {

        'biddingStrategyGoalType' => 'biddingStrategyGoalType',
        'appId' => 'appId',
        'appVendor' => 'appVendor',
    }
);

} # end BLOCK







1;


=pod

=head1 NAME

Google::Ads::AdWords::v201809::UniversalAppCampaignInfo

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
UniversalAppCampaignInfo from the namespace https://adwords.google.com/api/adwords/cm/v201809.

Stores campaign-level info related to Universal App Campaigns. 




=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over

=item * biddingStrategyGoalType


=item * appId


=item * appVendor




=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():






=head1 AUTHOR

Generated by SOAP::WSDL

=cut

