; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals all --version 5
; RUN: opt -S -mtriple=amdgcn-amd-amdhsa -mcpu=gfx803 -passes=amdgpu-attributor %s | FileCheck %s

@buf_shared = internal addrspace(3) global [2080 x i8] poison, align 16

; Constant expression element may not have a pointer type and the
; addrspacecast may not be the toplevel operation.


; This should infer "amdgpu-no-flat-scratch-init". It should not infer "amdgpu-no-queue-ptr"
;.
; CHECK: @buf_shared = internal addrspace(3) global [2080 x i8] poison, align 16
; CHECK: @buf_private = internal addrspace(5) global [2080 x i8] poison, align 16
;.
define amdgpu_kernel void @issue120256(ptr addrspace(1) %out) {
; CHECK-LABEL: define amdgpu_kernel void @issue120256(
; CHECK-SAME: ptr addrspace(1) [[OUT:%.*]]) #[[ATTR0:[0-9]+]] {
; CHECK-NEXT:    [[CONV_I:%.*]] = and i32 trunc (i64 sub (i64 16, i64 ptrtoint (ptr addrspacecast (ptr addrspace(3) @buf_shared to ptr) to i64)) to i32), 15
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds nuw i8, ptr addrspace(3) @buf_shared, i32 [[CONV_I]]
; CHECK-NEXT:    [[LD:%.*]] = load i8, ptr addrspace(3) [[ADD_PTR]], align 1
; CHECK-NEXT:    store i8 [[LD]], ptr addrspace(1) [[OUT]], align 1
; CHECK-NEXT:    ret void
;
  %conv.i = and i32 trunc (i64 sub (i64 16, i64 ptrtoint (ptr addrspacecast (ptr addrspace(3) @buf_shared to ptr) to i64)) to i32), 15
  %add.ptr = getelementptr inbounds nuw i8, ptr addrspace(3) @buf_shared, i32 %conv.i
  %ld = load i8, ptr addrspace(3) %add.ptr, align 1
  store i8 %ld, ptr addrspace(1) %out, align 1
  ret void
}

@buf_private = internal addrspace(5) global [2080 x i8] poison, align 16

; Constant expression element may not have a pointer type and the
; addrspacecast may not be the toplevel operation.

; This should not infer "amdgpu-no-flat-scratch-init" nor "amdgpu-no-queue-ptr"
define amdgpu_kernel void @issue120256_private(ptr addrspace(1) %out) {
; CHECK-LABEL: define amdgpu_kernel void @issue120256_private(
; CHECK-SAME: ptr addrspace(1) [[OUT:%.*]]) #[[ATTR1:[0-9]+]] {
; CHECK-NEXT:    [[CONV_I:%.*]] = and i32 trunc (i64 sub (i64 16, i64 ptrtoint (ptr addrspacecast (ptr addrspace(5) @buf_private to ptr) to i64)) to i32), 15
; CHECK-NEXT:    [[ADD_PTR:%.*]] = getelementptr inbounds nuw i8, ptr addrspace(5) @buf_private, i32 [[CONV_I]]
; CHECK-NEXT:    [[LD:%.*]] = load i8, ptr addrspace(5) [[ADD_PTR]], align 1
; CHECK-NEXT:    store i8 [[LD]], ptr addrspace(1) [[OUT]], align 1
; CHECK-NEXT:    ret void
;
  %conv.i = and i32 trunc (i64 sub (i64 16, i64 ptrtoint (ptr addrspacecast (ptr addrspace(5) @buf_private to ptr) to i64)) to i32), 15
  %add.ptr = getelementptr inbounds nuw i8, ptr addrspace(5) @buf_private, i32 %conv.i
  %ld = load i8, ptr addrspace(5) %add.ptr, align 1
  store i8 %ld, ptr addrspace(1) %out, align 1
  ret void
}

!llvm.module.flags = !{!0}

; FIXME: Inference of amdgpu-no-queue-ptr should not depend on code object version.
!0 = !{i32 1, !"amdhsa_code_object_version", i32 400}
;.
; CHECK: attributes #[[ATTR0]] = { "amdgpu-agpr-alloc"="0" "amdgpu-no-completion-action" "amdgpu-no-default-queue" "amdgpu-no-dispatch-id" "amdgpu-no-dispatch-ptr" "amdgpu-no-flat-scratch-init" "amdgpu-no-heap-ptr" "amdgpu-no-hostcall-ptr" "amdgpu-no-implicitarg-ptr" "amdgpu-no-lds-kernel-id" "amdgpu-no-multigrid-sync-arg" "amdgpu-no-workgroup-id-x" "amdgpu-no-workgroup-id-y" "amdgpu-no-workgroup-id-z" "amdgpu-no-workitem-id-x" "amdgpu-no-workitem-id-y" "amdgpu-no-workitem-id-z" "amdgpu-waves-per-eu"="4,10" "target-cpu"="gfx803" "uniform-work-group-size"="false" }
; CHECK: attributes #[[ATTR1]] = { "amdgpu-agpr-alloc"="0" "amdgpu-no-completion-action" "amdgpu-no-default-queue" "amdgpu-no-dispatch-id" "amdgpu-no-dispatch-ptr" "amdgpu-no-heap-ptr" "amdgpu-no-hostcall-ptr" "amdgpu-no-implicitarg-ptr" "amdgpu-no-lds-kernel-id" "amdgpu-no-multigrid-sync-arg" "amdgpu-no-workgroup-id-x" "amdgpu-no-workgroup-id-y" "amdgpu-no-workgroup-id-z" "amdgpu-no-workitem-id-x" "amdgpu-no-workitem-id-y" "amdgpu-no-workitem-id-z" "amdgpu-waves-per-eu"="4,10" "target-cpu"="gfx803" "uniform-work-group-size"="false" }
;.
; CHECK: [[META0:![0-9]+]] = !{i32 1, !"amdhsa_code_object_version", i32 400}
;.
