# Copyrights 2001-2025 by [Mark Overmeer <markov@cpan.org>].
#  For other contributors see ChangeLog.
# See the manual pages for details on the licensing terms.
# Pod stripped from pm file by OODoc 2.02.
# This code is part of distribution Mail-Message.  Meta-POD processed with
# OODoc into POD and HTML manual-pages.  See README.md
# Copyright Mark Overmeer.  Licensed under the same terms as Perl itself.

package Mail::Box::Parser;
use vars '$VERSION';
$VERSION = '3.018_001';

use base 'Mail::Reporter';

use strict;
use warnings;

use Carp;


sub new(@)
{   my $class = shift;

      $class eq __PACKAGE__
    ? $class->defaultParserType->new(@_)   # bootstrap right parser
    : $class->SUPER::new(@_);
}

sub init(@)
{   my ($self, $args) = @_;
    $self->SUPER::init($args);

	$self->{MBP_trusted}  = $args->{trusted};
    $self->{MBP_fix}      = $args->{fix_header_errors};
	$self->{MBP_seps}     = [];
    $self;
}

#------------------------------------------

sub fixHeaderErrors(;$)
{   my $self = shift;
    @_ ? ($self->{MBP_fix} = shift) : $self->{MBPL_fix};
}


sub trusted() { $_[0]->{MBP_trusted} }


my $parser_type;

sub defaultParserType(;$)
{   my $class = shift;

    # Select the parser manually?
    if(@_)
    {   $parser_type = shift;
        return $parser_type if $parser_type->isa( __PACKAGE__ );
        confess "Parser $parser_type does not extend " . __PACKAGE__ . "\n";
    }

    # Already determined which parser we want?
    $parser_type
        and return $parser_type;

    # Try to use C-based parser.
    eval 'require Mail::Box::Parser::C';
    $@ or return $parser_type = 'Mail::Box::Parser::C';

    # Fall-back on Perl-based parser.
    require Mail::Box::Parser::Perl;
    $parser_type = 'Mail::Box::Parser::Perl';
}

#------------------------------------------

sub readHeader()    {shift->notImplemented}


sub bodyAsString() {shift->notImplemented}


sub bodyAsList() {shift->notImplemented}


sub bodyAsFile() {shift->notImplemented}


sub bodyDelayed() {shift->notImplemented}


sub lineSeparator() {shift->{MBP_linesep}}


sub stop() { }
sub filePosition() { undef }

#------------

sub readSeparator() { shift->notImplemented }


sub pushSeparator($)
{   my ($self, $sep) = @_;
    unshift @{$self->{MBP_seps}}, $sep;
    $self->{MBP_strip_gt}++ if $sep eq 'From ';
    $self;
}


sub popSeparator()
{   my $self = shift;
    my $sep  = shift @{$self->{MBP_seps}};
    $self->{MBP_strip_gt}-- if $sep eq 'From ';
    $sep;   
}


sub separators()      { $_[0]->{MBP_seps} }
sub activeSeparator() { $_[0]->separators->[0] }
sub resetSeparators() { $_[0]->{MBP_seps} = []; $_[0]->{MBP_strip_gt} = 0 }
sub stripGt           { $_[0]->{MBP_strip_gt} }

#------------------------------------------

#------------------------------------------

1;
