# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#
# This Source Code Form is "Incompatible With Secondary Licenses", as
# defined by the Mozilla Public License, v. 2.0.

package Bugzilla::BugUrl::Trac;

use 5.14.0;
use strict;
use warnings;

use base qw(Bugzilla::BugUrl);

###############################
####        Methods        ####
###############################

sub should_handle {
  my ($class, $uri) = @_;

  # Trac URLs can look like various things:
  #   http://dev.mutt.org/trac/ticket/1234
  #   http://trac.roundcube.net/ticket/1484130
  return ($uri->path =~ m|/ticket/\d+$|) ? 1 : 0;
}

sub _check_value {
  my $class = shift;

  my $uri = $class->SUPER::_check_value(@_);

  # Make sure there are no query parameters.
  $uri->query(undef);

  # And remove any # part if there is one.
  $uri->fragment(undef);

  return $uri;
}

1;
