/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.SchemaBuilderImpl;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RefPattern
extends Pattern {
    private Pattern p;
    private Locator refLoc;
    private final String name;
    private int checkRecursionDepth = -1;
    private boolean combineImplicit = false;
    private byte combineType = 0;
    private byte replacementStatus = 0;
    private boolean expanded = false;
    static final byte REPLACEMENT_KEEP = 0;
    static final byte REPLACEMENT_REQUIRE = 1;
    static final byte REPLACEMENT_IGNORE = 2;
    static final byte COMBINE_NONE = 0;
    static final byte COMBINE_CHOICE = 1;
    static final byte COMBINE_INTERLEAVE = 2;

    RefPattern(String string) {
        this.name = string;
    }

    Pattern getPattern() {
        return this.p;
    }

    void setPattern(Pattern pattern) {
        this.p = pattern;
    }

    Locator getRefLocator() {
        return this.refLoc;
    }

    void setRefLocator(Locator locator) {
        this.refLoc = locator;
    }

    @Override
    void checkRecursion(int n) throws SAXException {
        if (this.checkRecursionDepth == -1) {
            this.checkRecursionDepth = n;
            this.p.checkRecursion(n);
            this.checkRecursionDepth = -2;
        } else if (n == this.checkRecursionDepth) {
            throw new SAXParseException(SchemaBuilderImpl.localizer.message("recursive_reference", this.name), this.refLoc);
        }
    }

    @Override
    Pattern expand(SchemaPatternBuilder schemaPatternBuilder) {
        if (!this.expanded) {
            this.p = this.p.expand(schemaPatternBuilder);
            this.expanded = true;
        }
        return this.p;
    }

    @Override
    boolean samePattern(Pattern pattern) {
        return false;
    }

    @Override
    <T> T apply(PatternFunction<T> patternFunction) {
        return patternFunction.caseRef(this);
    }

    byte getReplacementStatus() {
        return this.replacementStatus;
    }

    void setReplacementStatus(byte by) {
        this.replacementStatus = by;
    }

    boolean isCombineImplicit() {
        return this.combineImplicit;
    }

    void setCombineImplicit() {
        this.combineImplicit = true;
    }

    byte getCombineType() {
        return this.combineType;
    }

    void setCombineType(byte by) {
        this.combineType = by;
    }

    String getName() {
        return this.name;
    }
}

