/* SnippetManager.c generated by valac 0.34.6, the Vala compiler
 * generated from SnippetManager.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <sqlite3.h>


#define TYPE_SNIPPET_MANAGER (snippet_manager_get_type ())
#define SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNIPPET_MANAGER, SnippetManager))
#define SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNIPPET_MANAGER, SnippetManagerClass))
#define IS_SNIPPET_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNIPPET_MANAGER))
#define IS_SNIPPET_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNIPPET_MANAGER))
#define SNIPPET_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNIPPET_MANAGER, SnippetManagerClass))

typedef struct _SnippetManager SnippetManager;
typedef struct _SnippetManagerClass SnippetManagerClass;
typedef struct _SnippetManagerPrivate SnippetManagerPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define SQL_TYPE_SELECT_STATEMENT (sql_select_statement_get_type ())
#define SQL_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatement))
#define SQL_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))
#define SQL_IS_SELECT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_SELECT_STATEMENT))
#define SQL_IS_SELECT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_SELECT_STATEMENT))
#define SQL_SELECT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_SELECT_STATEMENT, SqlSelectStatementClass))

typedef struct _SqlSelectStatement SqlSelectStatement;
typedef struct _SqlSelectStatementClass SqlSelectStatementClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define SQL_TYPE_INSERT_STATEMENT (sql_insert_statement_get_type ())
#define SQL_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatement))
#define SQL_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))
#define SQL_IS_INSERT_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_INSERT_STATEMENT))
#define SQL_IS_INSERT_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_INSERT_STATEMENT))
#define SQL_INSERT_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_INSERT_STATEMENT, SqlInsertStatementClass))

typedef struct _SqlInsertStatement SqlInsertStatement;
typedef struct _SqlInsertStatementClass SqlInsertStatementClass;

#define SQL_TYPE_UPDATE_STATEMENT (sql_update_statement_get_type ())
#define SQL_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatement))
#define SQL_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))
#define SQL_IS_UPDATE_STATEMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_IS_UPDATE_STATEMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_UPDATE_STATEMENT))
#define SQL_UPDATE_STATEMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_UPDATE_STATEMENT, SqlUpdateStatementClass))

typedef struct _SqlUpdateStatement SqlUpdateStatement;
typedef struct _SqlUpdateStatementClass SqlUpdateStatementClass;

struct _SnippetManager {
	GObject parent_instance;
	SnippetManagerPrivate * priv;
};

struct _SnippetManagerClass {
	GObjectClass parent_class;
};

struct _SnippetManagerPrivate {
	GHashTable* snippets;
	gboolean inited;
};

typedef gboolean (*SqlSelectCallback) (gchar** vals, int vals_length1, void* user_data);

static gpointer snippet_manager_parent_class = NULL;
extern SqlDatabase* corebird_db;

GType snippet_manager_get_type (void) G_GNUC_CONST;
#define SNIPPET_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_SNIPPET_MANAGER, SnippetManagerPrivate))
enum  {
	SNIPPET_MANAGER_DUMMY_PROPERTY
};
static void _g_free0_ (gpointer var);
SnippetManager* snippet_manager_new (void);
SnippetManager* snippet_manager_construct (GType object_type);
static void snippet_manager_load_snippets (SnippetManager* self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType sql_select_statement_get_type (void) G_GNUC_CONST;
SqlSelectStatement* sql_database_select (SqlDatabase* self, const gchar* table_name);
SqlSelectStatement* sql_select_statement_cols (SqlSelectStatement* self, const gchar* first, ...);
SqlSelectStatement* sql_select_statement_order (SqlSelectStatement* self, const gchar* order_by);
gint sql_select_statement_run (SqlSelectStatement* self, SqlSelectCallback callback, void* callback_target);
static gboolean __lambda7_ (SnippetManager* self, gchar** vals, int vals_length1);
static gboolean ___lambda7__sql_select_callback (gchar** vals, int vals_length1, gpointer self);
void snippet_manager_remove_snippet (SnippetManager* self, const gchar* snippet_key);
void sql_database_exec (SqlDatabase* self, const gchar* sql, sqlite3_callback callback, void* callback_target);
void snippet_manager_insert_snippet (SnippetManager* self, const gchar* key, const gchar* value);
GType sql_insert_statement_get_type (void) G_GNUC_CONST;
SqlInsertStatement* sql_database_insert (SqlDatabase* self, const gchar* table_name);
SqlInsertStatement* sql_insert_statement_val (SqlInsertStatement* self, const gchar* col_name, const gchar* col_value);
gint64 sql_insert_statement_run (SqlInsertStatement* self);
gchar* snippet_manager_get_snippet (SnippetManager* self, const gchar* key);
void snippet_manager_query_snippets (SnippetManager* self, GHFunc func, void* func_target);
guint snippet_manager_n_snippets (SnippetManager* self);
void snippet_manager_set_snippet (SnippetManager* self, const gchar* old_key, const gchar* key, const gchar* new_value);
GType sql_update_statement_get_type (void) G_GNUC_CONST;
SqlUpdateStatement* sql_database_update (SqlDatabase* self, const gchar* table_name);
SqlUpdateStatement* sql_update_statement_val (SqlUpdateStatement* self, const gchar* col_name, const gchar* col_value);
SqlUpdateStatement* sql_update_statement_where_eq (SqlUpdateStatement* self, const gchar* col, const gchar* value);
gint64 sql_update_statement_run (SqlUpdateStatement* self);
static void snippet_manager_finalize (GObject* obj);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


SnippetManager* snippet_manager_construct (GType object_type) {
	SnippetManager * self = NULL;
	self = (SnippetManager*) g_object_new (object_type, NULL);
	return self;
}


SnippetManager* snippet_manager_new (void) {
	return snippet_manager_construct (TYPE_SNIPPET_MANAGER);
}


static gboolean __lambda7_ (SnippetManager* self, gchar** vals, int vals_length1) {
	gboolean result = FALSE;
	GHashTable* _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar** _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	const gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	_tmp0_ = self->priv->snippets;
	_tmp1_ = vals;
	_tmp1__length1 = vals_length1;
	_tmp2_ = _tmp1_[1];
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = vals;
	_tmp4__length1 = vals_length1;
	_tmp5_ = _tmp4_[2];
	_tmp6_ = g_strdup (_tmp5_);
	g_hash_table_insert (_tmp0_, _tmp3_, _tmp6_);
	result = TRUE;
	return result;
}


static gboolean ___lambda7__sql_select_callback (gchar** vals, int vals_length1, gpointer self) {
	gboolean result;
	result = __lambda7_ ((SnippetManager*) self, vals, vals_length1);
	return result;
}


static void snippet_manager_load_snippets (SnippetManager* self) {
	SqlDatabase* _tmp0_ = NULL;
	SqlSelectStatement* _tmp1_ = NULL;
	SqlSelectStatement* _tmp2_ = NULL;
	SqlSelectStatement* _tmp3_ = NULL;
	SqlSelectStatement* _tmp4_ = NULL;
	SqlSelectStatement* _tmp5_ = NULL;
	SqlSelectStatement* _tmp6_ = NULL;
	g_return_if_fail (IS_SNIPPET_MANAGER (self));
	_tmp0_ = corebird_db;
	_tmp1_ = sql_database_select (_tmp0_, "snippets");
	_tmp2_ = _tmp1_;
	_tmp3_ = sql_select_statement_cols (_tmp2_, "id", "key", "value", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = sql_select_statement_order (_tmp4_, "id");
	_tmp6_ = _tmp5_;
	sql_select_statement_run (_tmp6_, ___lambda7__sql_select_callback, self);
	_g_object_unref0 (_tmp6_);
	_g_object_unref0 (_tmp4_);
	_g_object_unref0 (_tmp2_);
	self->priv->inited = TRUE;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	{
		GRegex* regex = NULL;
		const gchar* _tmp0_ = NULL;
		gchar* _tmp1_ = NULL;
		gchar* _tmp2_ = NULL;
		GRegex* _tmp3_ = NULL;
		GRegex* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GRegex* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		_tmp0_ = old;
		_tmp1_ = g_regex_escape_string (_tmp0_, -1);
		_tmp2_ = _tmp1_;
		_tmp3_ = g_regex_new (_tmp2_, 0, 0, &_inner_error_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp2_);
		regex = _tmp4_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch41_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = regex;
		_tmp7_ = replacement;
		_tmp8_ = g_regex_replace_literal (_tmp6_, self, (gssize) -1, 0, _tmp7_, 0, &_inner_error_);
		_tmp5_ = _tmp8_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch41_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp9_ = _tmp5_;
		_tmp5_ = NULL;
		result = _tmp9_;
		_g_free0 (_tmp5_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally41;
	__catch41_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally41:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void snippet_manager_remove_snippet (SnippetManager* self, const gchar* snippet_key) {
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* key = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	SqlDatabase* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	g_return_if_fail (IS_SNIPPET_MANAGER (self));
	g_return_if_fail (snippet_key != NULL);
	_tmp0_ = self->priv->inited;
	if (!_tmp0_) {
		snippet_manager_load_snippets (self);
	}
	_tmp1_ = self->priv->snippets;
	_tmp2_ = snippet_key;
	g_hash_table_remove (_tmp1_, _tmp2_);
	_tmp3_ = snippet_key;
	_tmp4_ = string_replace (_tmp3_, "'", "''");
	key = _tmp4_;
	_tmp5_ = corebird_db;
	_tmp6_ = string_to_string (key);
	_tmp7_ = g_strconcat ("DELETE FROM `snippets` WHERE `key`='", _tmp6_, "'", NULL);
	_tmp8_ = _tmp7_;
	sql_database_exec (_tmp5_, _tmp8_, NULL, NULL);
	_g_free0 (_tmp8_);
	_g_free0 (key);
}


void snippet_manager_insert_snippet (SnippetManager* self, const gchar* key, const gchar* value) {
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	SqlDatabase* _tmp5_ = NULL;
	SqlInsertStatement* _tmp6_ = NULL;
	SqlInsertStatement* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	SqlInsertStatement* _tmp9_ = NULL;
	SqlInsertStatement* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	SqlInsertStatement* _tmp12_ = NULL;
	SqlInsertStatement* _tmp13_ = NULL;
	GHashTable* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	g_return_if_fail (IS_SNIPPET_MANAGER (self));
	g_return_if_fail (key != NULL);
	g_return_if_fail (value != NULL);
	_tmp0_ = self->priv->inited;
	if (!_tmp0_) {
		snippet_manager_load_snippets (self);
	}
	_tmp1_ = self->priv->snippets;
	_tmp2_ = key;
	_tmp3_ = g_hash_table_contains (_tmp1_, _tmp2_);
	if (_tmp3_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = key;
		g_error ("SnippetManager.vala:50: Snippet already exists: %s", _tmp4_);
	}
	_tmp5_ = corebird_db;
	_tmp6_ = sql_database_insert (_tmp5_, "snippets");
	_tmp7_ = _tmp6_;
	_tmp8_ = key;
	_tmp9_ = sql_insert_statement_val (_tmp7_, "key", _tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = value;
	_tmp12_ = sql_insert_statement_val (_tmp10_, "value", _tmp11_);
	_tmp13_ = _tmp12_;
	sql_insert_statement_run (_tmp13_);
	_g_object_unref0 (_tmp13_);
	_g_object_unref0 (_tmp10_);
	_g_object_unref0 (_tmp7_);
	_tmp14_ = self->priv->snippets;
	_tmp15_ = key;
	_tmp16_ = g_strdup (_tmp15_);
	_tmp17_ = value;
	_tmp18_ = g_strdup (_tmp17_);
	g_hash_table_insert (_tmp14_, _tmp16_, _tmp18_);
}


gchar* snippet_manager_get_snippet (SnippetManager* self, const gchar* key) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gconstpointer _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (IS_SNIPPET_MANAGER (self), NULL);
	g_return_val_if_fail (key != NULL, NULL);
	_tmp0_ = self->priv->inited;
	if (!_tmp0_) {
		snippet_manager_load_snippets (self);
	}
	_tmp1_ = self->priv->snippets;
	_tmp2_ = key;
	_tmp3_ = g_hash_table_lookup (_tmp1_, _tmp2_);
	_tmp4_ = g_strdup ((const gchar*) _tmp3_);
	result = _tmp4_;
	return result;
}


void snippet_manager_query_snippets (SnippetManager* self, GHFunc func, void* func_target) {
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_ = NULL;
	GHFunc _tmp2_ = NULL;
	void* _tmp2__target = NULL;
	g_return_if_fail (IS_SNIPPET_MANAGER (self));
	_tmp0_ = self->priv->inited;
	if (!_tmp0_) {
		snippet_manager_load_snippets (self);
	}
	_tmp1_ = self->priv->snippets;
	_tmp2_ = func;
	_tmp2__target = func_target;
	g_hash_table_foreach (_tmp1_, _tmp2_, _tmp2__target);
}


guint snippet_manager_n_snippets (SnippetManager* self) {
	guint result = 0U;
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	g_return_val_if_fail (IS_SNIPPET_MANAGER (self), 0U);
	_tmp0_ = self->priv->inited;
	if (!_tmp0_) {
		snippet_manager_load_snippets (self);
	}
	_tmp1_ = self->priv->snippets;
	_tmp2_ = g_hash_table_size (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}


void snippet_manager_set_snippet (SnippetManager* self, const gchar* old_key, const gchar* key, const gchar* new_value) {
	gboolean _tmp0_ = FALSE;
	GHashTable* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GHashTable* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_ = NULL;
	SqlDatabase* _tmp10_ = NULL;
	SqlUpdateStatement* _tmp11_ = NULL;
	SqlUpdateStatement* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	SqlUpdateStatement* _tmp14_ = NULL;
	SqlUpdateStatement* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	SqlUpdateStatement* _tmp17_ = NULL;
	SqlUpdateStatement* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	SqlUpdateStatement* _tmp20_ = NULL;
	SqlUpdateStatement* _tmp21_ = NULL;
	g_return_if_fail (IS_SNIPPET_MANAGER (self));
	g_return_if_fail (old_key != NULL);
	g_return_if_fail (key != NULL);
	g_return_if_fail (new_value != NULL);
	_tmp0_ = self->priv->inited;
	if (!_tmp0_) {
		snippet_manager_load_snippets (self);
	}
	_tmp1_ = self->priv->snippets;
	_tmp2_ = old_key;
	_tmp3_ = g_hash_table_contains (_tmp1_, _tmp2_);
	if (!_tmp3_) {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = key;
		g_debug ("SnippetManager.vala:82: Key %s not in hashmap!", _tmp4_);
		return;
	}
	_tmp5_ = self->priv->snippets;
	_tmp6_ = key;
	_tmp7_ = g_strdup (_tmp6_);
	_tmp8_ = new_value;
	_tmp9_ = g_strdup (_tmp8_);
	g_hash_table_replace (_tmp5_, _tmp7_, _tmp9_);
	_tmp10_ = corebird_db;
	_tmp11_ = sql_database_update (_tmp10_, "snippets");
	_tmp12_ = _tmp11_;
	_tmp13_ = key;
	_tmp14_ = sql_update_statement_val (_tmp12_, "key", _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = new_value;
	_tmp17_ = sql_update_statement_val (_tmp15_, "value", _tmp16_);
	_tmp18_ = _tmp17_;
	_tmp19_ = old_key;
	_tmp20_ = sql_update_statement_where_eq (_tmp18_, "key", _tmp19_);
	_tmp21_ = _tmp20_;
	sql_update_statement_run (_tmp21_);
	_g_object_unref0 (_tmp21_);
	_g_object_unref0 (_tmp18_);
	_g_object_unref0 (_tmp15_);
	_g_object_unref0 (_tmp12_);
}


static void snippet_manager_class_init (SnippetManagerClass * klass) {
	snippet_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SnippetManagerPrivate));
	G_OBJECT_CLASS (klass)->finalize = snippet_manager_finalize;
}


static void snippet_manager_instance_init (SnippetManager * self) {
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	self->priv = SNIPPET_MANAGER_GET_PRIVATE (self);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_free0_);
	self->priv->snippets = _tmp2_;
	self->priv->inited = FALSE;
}


static void snippet_manager_finalize (GObject* obj) {
	SnippetManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_SNIPPET_MANAGER, SnippetManager);
	_g_hash_table_unref0 (self->priv->snippets);
	G_OBJECT_CLASS (snippet_manager_parent_class)->finalize (obj);
}


GType snippet_manager_get_type (void) {
	static volatile gsize snippet_manager_type_id__volatile = 0;
	if (g_once_init_enter (&snippet_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SnippetManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) snippet_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SnippetManager), 0, (GInstanceInitFunc) snippet_manager_instance_init, NULL };
		GType snippet_manager_type_id;
		snippet_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "SnippetManager", &g_define_type_info, 0);
		g_once_init_leave (&snippet_manager_type_id__volatile, snippet_manager_type_id);
	}
	return snippet_manager_type_id__volatile;
}



