/* UserListsWidget.c generated by valac 0.36.4, the Vala compiler
 * generated from UserListsWidget.vala, do not modify */

/*  This file is part of corebird, a Gtk+ linux Twitter client.
 *  Copyright (C) 2013 Timm Bäder
 *
 *  corebird is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  corebird is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with corebird.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "CbBundle.h"
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include "rest/oauth-proxy.h"
#include "CbUserStream.h"
#include "CbUserCounter.h"
#include "CbFilter.h"
#include "rest/rest-proxy-call.h"
#include "rest/rest-proxy.h"
#include "CbUtils.h"
#include <json-glib/json-glib.h>
#include <gdk/gdk.h>


#define TYPE_USER_LISTS_WIDGET (user_lists_widget_get_type ())
#define USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidget))
#define USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))
#define IS_USER_LISTS_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_USER_LISTS_WIDGET))
#define IS_USER_LISTS_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_USER_LISTS_WIDGET))
#define USER_LISTS_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_USER_LISTS_WIDGET, UserListsWidgetClass))

typedef struct _UserListsWidget UserListsWidget;
typedef struct _UserListsWidgetClass UserListsWidgetClass;
typedef struct _UserListsWidgetPrivate UserListsWidgetPrivate;

#define TYPE_NEW_LIST_ENTRY (new_list_entry_get_type ())
#define NEW_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NEW_LIST_ENTRY, NewListEntry))
#define NEW_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NEW_LIST_ENTRY, NewListEntryClass))
#define IS_NEW_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NEW_LIST_ENTRY))
#define IS_NEW_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NEW_LIST_ENTRY))
#define NEW_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NEW_LIST_ENTRY, NewListEntryClass))

typedef struct _NewListEntry NewListEntry;
typedef struct _NewListEntryClass NewListEntryClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_ACCOUNT (account_get_type ())
#define ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT, Account))
#define ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT, AccountClass))
#define IS_ACCOUNT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT))
#define IS_ACCOUNT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT))
#define ACCOUNT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT, AccountClass))

typedef struct _Account Account;
typedef struct _AccountClass AccountClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_LIST_LIST_ENTRY (list_list_entry_get_type ())
#define LIST_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_LIST_ENTRY, ListListEntry))
#define LIST_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_LIST_ENTRY, ListListEntryClass))
#define IS_LIST_LIST_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_LIST_ENTRY))
#define IS_LIST_LIST_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_LIST_ENTRY))
#define LIST_LIST_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_LIST_ENTRY, ListListEntryClass))

typedef struct _ListListEntry ListListEntry;
typedef struct _ListListEntryClass ListListEntryClass;
typedef struct _ListListEntryPrivate ListListEntryPrivate;
typedef struct _MainWindowPrivate MainWindowPrivate;

#define TYPE_MAIN_WIDGET (main_widget_get_type ())
#define MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WIDGET, MainWidget))
#define MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WIDGET, MainWidgetClass))
#define IS_MAIN_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WIDGET))
#define IS_MAIN_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WIDGET))
#define MAIN_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WIDGET, MainWidgetClass))

typedef struct _MainWidget MainWidget;
typedef struct _MainWidgetClass MainWidgetClass;

#define TYPE_PAGE (page_get_type ())

#define TYPE_COLLECT (collect_get_type ())
#define COLLECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECT, Collect))
#define COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECT, CollectClass))
#define IS_COLLECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECT))
#define IS_COLLECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECT))
#define COLLECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECT, CollectClass))

typedef struct _Collect Collect;
typedef struct _CollectClass CollectClass;
typedef struct _Block46Data Block46Data;
typedef struct _AccountPrivate AccountPrivate;

#define SQL_TYPE_DATABASE (sql_database_get_type ())
#define SQL_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SQL_TYPE_DATABASE, SqlDatabase))
#define SQL_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SQL_TYPE_DATABASE, SqlDatabaseClass))
#define SQL_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SQL_TYPE_DATABASE))
#define SQL_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SQL_TYPE_DATABASE))
#define SQL_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SQL_TYPE_DATABASE, SqlDatabaseClass))

typedef struct _SqlDatabase SqlDatabase;
typedef struct _SqlDatabaseClass SqlDatabaseClass;

#define TYPE_NOTIFICATION_MANAGER (notification_manager_get_type ())
#define NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManager))
#define NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))
#define IS_NOTIFICATION_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTIFICATION_MANAGER))
#define IS_NOTIFICATION_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTIFICATION_MANAGER))
#define NOTIFICATION_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTIFICATION_MANAGER, NotificationManagerClass))

typedef struct _NotificationManager NotificationManager;
typedef struct _NotificationManagerClass NotificationManagerClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define __vala_JsonNode_free0(var) ((var == NULL) ? NULL : (var = (_vala_JsonNode_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UserListsWidgetLoadListsData UserListsWidgetLoadListsData;
typedef struct _Block47Data Block47Data;
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))
#define _json_array_unref0(var) ((var == NULL) ? NULL : (var = (json_array_unref (var), NULL)))
typedef struct _Block48Data Block48Data;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block49Data Block49Data;

#define TYPE_TWITTER_LIST (twitter_list_get_type ())
typedef struct _TwitterList TwitterList;
typedef struct _Block50Data Block50Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UserListsWidget {
	GtkBox parent_instance;
	UserListsWidgetPrivate * priv;
};

struct _UserListsWidgetClass {
	GtkBoxClass parent_class;
};

struct _UserListsWidgetPrivate {
	GtkLabel* user_list_label;
	GtkListBox* user_list_box;
	GtkFrame* user_list_frame;
	GtkLabel* subscribed_list_label;
	GtkListBox* subscribed_list_box;
	GtkFrame* subscribed_list_frame;
	NewListEntry* new_list_entry;
	GtkRevealer* user_lists_revealer;
	GtkSeparator* upper_separator;
	GtkListBox* new_list_box;
	MainWindow* _main_window;
	Account* _account;
	gboolean show_create_entry;
};

struct _ListListEntry {
	GtkListBoxRow parent_instance;
	ListListEntryPrivate * priv;
	gint64 id;
	gboolean user_list;
	gchar* creator_screen_name;
	gint n_subscribers;
	gint n_members;
	gint64 created_at;
	gchar* mode;
};

struct _ListListEntryClass {
	GtkListBoxRowClass parent_class;
};

struct _MainWindow {
	GtkApplicationWindow parent_instance;
	MainWindowPrivate * priv;
	GtkButton* back_button;
	GtkToggleButton* compose_tweet_button;
	MainWidget* main_widget;
	Account* account;
};

struct _MainWindowClass {
	GtkApplicationWindowClass parent_class;
};

typedef enum  {
	PAGE_STREAM = 0,
	PAGE_MENTIONS,
	PAGE_FAVORITES,
	PAGE_DM_THREADS,
	PAGE_LISTS,
	PAGE_FILTERS,
	PAGE_SEARCH,
	PAGE_PROFILE,
	PAGE_TWEET_INFO,
	PAGE_DM,
	PAGE_LIST_STATUSES,
	PAGE_PREVIOUS = 1024,
	PAGE_NEXT = 2048
} Page;

struct _Block46Data {
	int _ref_count_;
	UserListsWidget* self;
	Collect* collect_obj;
	gpointer _async_data_;
};

struct _Account {
	GObject parent_instance;
	AccountPrivate * priv;
	gint64 id;
	SqlDatabase* db;
	gchar* screen_name;
	gchar* name;
	gchar* avatar_url;
	gchar* banner_url;
	gchar* website;
	gchar* description;
	OAuthProxy* proxy;
	CbUserStream* user_stream;
	CbUserCounter* user_counter;
	NotificationManager* notifications;
	gint64* friends;
	gint friends_length1;
	gint64* blocked;
	gint blocked_length1;
	gint64* muted;
	gint muted_length1;
	gint64* disabled_rts;
	gint disabled_rts_length1;
	GPtrArray* filters;
};

struct _AccountClass {
	GObjectClass parent_class;
};

struct _UserListsWidgetLoadListsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	UserListsWidget* self;
	gint64 user_id;
	Block46Data* _data46_;
	gint64 _tmp0_;
	Account* _tmp1_;
	gint64 _tmp2_;
	Collect* _tmp3_;
	RestProxyCall* call;
	Account* _tmp4_;
	OAuthProxy* _tmp5_;
	RestProxyCall* _tmp6_;
	gint64 _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	RestProxyCall* user_call;
	Account* _tmp10_;
	OAuthProxy* _tmp11_;
	RestProxyCall* _tmp12_;
	gint64 _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
};

struct _Block47Data {
	int _ref_count_;
	UserListsWidget* self;
	GtkListBox* list_box;
};

struct _Block48Data {
	int _ref_count_;
	UserListsWidget* self;
	guint n_user_lists;
	gint64 list_id;
};

struct _Block49Data {
	int _ref_count_;
	UserListsWidget* self;
	gint64 list_id;
	gchar* name;
	gchar* description;
	gchar* mode;
};

struct _TwitterList {
	gint64 id;
	gchar* name;
	gchar* description;
	gchar* mode;
	guint n_members;
};

struct _Block50Data {
	int _ref_count_;
	UserListsWidget* self;
	RestProxyCall* call;
};


static gpointer user_lists_widget_parent_class = NULL;

GType user_lists_widget_get_type (void) G_GNUC_CONST;
GType new_list_entry_get_type (void) G_GNUC_CONST;
GType main_window_get_type (void) G_GNUC_CONST;
GType account_get_type (void) G_GNUC_CONST;
#define USER_LISTS_WIDGET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_USER_LISTS_WIDGET, UserListsWidgetPrivate))
enum  {
	USER_LISTS_WIDGET_DUMMY_PROPERTY,
	USER_LISTS_WIDGET_MAIN_WINDOW,
	USER_LISTS_WIDGET_ACCOUNT
};
void user_lists_widget_hide_user_list_entry (UserListsWidget* self);
static void user_lists_widget_row_activated (UserListsWidget* self, GtkListBoxRow* row);
void new_list_entry_reveal (NewListEntry* self);
GType list_list_entry_get_type (void) G_GNUC_CONST;
#define LIST_STATUSES_PAGE_KEY_LIST_ID 8
#define LIST_STATUSES_PAGE_KEY_NAME 1
const gchar* list_list_entry_get_name (ListListEntry* self);
#define LIST_STATUSES_PAGE_KEY_USER_LIST 0
#define LIST_STATUSES_PAGE_KEY_DESCRIPTION 2
const gchar* list_list_entry_get_description (ListListEntry* self);
#define LIST_STATUSES_PAGE_KEY_CREATOR 3
#define LIST_STATUSES_PAGE_KEY_N_SUBSCRIBERS 4
#define LIST_STATUSES_PAGE_KEY_N_MEMBERS 5
#define LIST_STATUSES_PAGE_KEY_CREATED_AT 6
#define LIST_STATUSES_PAGE_KEY_MODE 7
MainWindow* user_lists_widget_get_main_window (UserListsWidget* self);
GType main_widget_get_type (void) G_GNUC_CONST;
void main_widget_switch_page (MainWidget* self, gint page_id, CbBundle* args);
GType page_get_type (void) G_GNUC_CONST;
static void _user_lists_widget_row_activated_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self);
static void user_lists_widget_load_lists_data_free (gpointer _data);
void user_lists_widget_load_lists (UserListsWidget* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void user_lists_widget_load_lists_finish (UserListsWidget* self, GAsyncResult* _res_);
static gboolean user_lists_widget_load_lists_co (UserListsWidgetLoadListsData* _data_);
GType collect_get_type (void) G_GNUC_CONST;
static Block46Data* block46_data_ref (Block46Data* _data46_);
static void block46_data_unref (void * _userdata_);
Account* user_lists_widget_get_account (UserListsWidget* self);
GType sql_database_get_type (void) G_GNUC_CONST;
GType notification_manager_get_type (void) G_GNUC_CONST;
Collect* collect_new (gint max);
Collect* collect_construct (GType object_type, gint max);
static void __lambda70_ (Block46Data* _data46_, GObject* _, GAsyncResult* res);
static void _vala_JsonNode_free (JsonNode* self);
static guint user_lists_widget_lists_received_cb (UserListsWidget* self, JsonNode* root, GtkListBox* list_box);
void collect_emit (Collect* self, GError* _error_);
static void ___lambda70__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda72_ (Block46Data* _data46_, GObject* _, GAsyncResult* res);
static void ___lambda72__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void __lambda73_ (Block46Data* _data46_);
static void ___lambda73__collect_finished (Collect* _sender, GError* _error_, gpointer self);
static Block47Data* block47_data_ref (Block47Data* _data47_);
static void block47_data_unref (void * _userdata_);
static void __lambda71_ (Block47Data* _data47_, JsonArray* array, guint index, JsonNode* node);
ListListEntry* list_list_entry_new_from_json_data (JsonObject* obj, Account* account);
ListListEntry* list_list_entry_construct_from_json_data (GType object_type, JsonObject* obj, Account* account);
static void ___lambda71__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self);
void user_lists_widget_remove_list (UserListsWidget* self, gint64 list_id);
static Block48Data* block48_data_ref (Block48Data* _data48_);
static void block48_data_unref (void * _userdata_);
static void __lambda74_ (Block48Data* _data48_, GtkWidget* w);
static void ___lambda74__gtk_callback (GtkWidget* widget, gpointer self);
static void __lambda75_ (Block48Data* _data48_, GtkWidget* w);
static void ___lambda75__gtk_callback (GtkWidget* widget, gpointer self);
void user_lists_widget_add_list (UserListsWidget* self, ListListEntry* entry);
void user_lists_widget_update_list (UserListsWidget* self, gint64 list_id, const gchar* name, const gchar* description, const gchar* mode);
static Block49Data* block49_data_ref (Block49Data* _data49_);
static void block49_data_unref (void * _userdata_);
static void __lambda76_ (Block49Data* _data49_, GtkWidget* w);
void list_list_entry_set_name (ListListEntry* self, const gchar* value);
void list_list_entry_set_description (ListListEntry* self, const gchar* value);
static void ___lambda76__gtk_callback (GtkWidget* widget, gpointer self);
void user_lists_widget_update_member_count (UserListsWidget* self, gint64 list_id, gint increase);
GType twitter_list_get_type (void) G_GNUC_CONST;
TwitterList* twitter_list_dup (const TwitterList* self);
void twitter_list_free (TwitterList* self);
void twitter_list_copy (const TwitterList* self, TwitterList* dest);
void twitter_list_destroy (TwitterList* self);
TwitterList* user_lists_widget_get_user_lists (UserListsWidget* self, int* result_length1);
static void _vala_TwitterList_array_free (TwitterList * array, gint array_length);
void user_lists_widget_clear_lists (UserListsWidget* self);
static void __lambda78_ (UserListsWidget* self, GtkWidget* w);
static void ___lambda78__gtk_callback (GtkWidget* widget, gpointer self);
static void __lambda79_ (UserListsWidget* self, GtkWidget* w);
static void ___lambda79__gtk_callback (GtkWidget* widget, gpointer self);
static void user_lists_widget_new_list_create_activated_cb (UserListsWidget* self, const gchar* list_name);
static Block50Data* block50_data_ref (Block50Data* _data50_);
static void block50_data_unref (void * _userdata_);
static void __lambda80_ (Block50Data* _data50_, GObject* o, GAsyncResult* res);
void utils_show_error_object (const gchar* json_data, const gchar* alternative, gint line, const gchar* file, GtkWindow* transient_for);
static void ___lambda80__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _user_lists_widget_new_list_create_activated_cb_new_list_entry_create_activated (NewListEntry* _sender, const gchar* list_name, gpointer self);
void user_lists_widget_unreveal (UserListsWidget* self);
void new_list_entry_unreveal (NewListEntry* self);
static gboolean user_lists_widget_new_list_box_keynav_failed_cb (UserListsWidget* self, GtkDirectionType direction);
static gboolean _user_lists_widget_new_list_box_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self);
static gboolean user_lists_widget_user_list_box_keynav_failed_cb (UserListsWidget* self, GtkDirectionType direction);
static gboolean _user_lists_widget_user_list_box_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self);
static gboolean user_lists_widget_subscribed_list_box_keynav_failed_cb (UserListsWidget* self, GtkDirectionType direction);
static gboolean _user_lists_widget_subscribed_list_box_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self);
static void user_lists_widget_revealer_child_revealed_cb (UserListsWidget* self, GObject* source, GParamSpec* spec);
static void _user_lists_widget_revealer_child_revealed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
UserListsWidget* user_lists_widget_new (void);
UserListsWidget* user_lists_widget_construct (GType object_type);
void user_lists_widget_set_main_window (UserListsWidget* self, MainWindow* value);
void user_lists_widget_set_account (UserListsWidget* self, Account* value);
static GObject * user_lists_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
void default_header_func (GtkListBoxRow* row, GtkListBoxRow* row_before);
static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self);
gint list_list_entry_sort_func (GtkListBoxRow* r1, GtkListBoxRow* r2);
static gint _list_list_entry_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self);
static void user_lists_widget_finalize (GObject * obj);
static void _vala_user_lists_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_user_lists_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


void user_lists_widget_hide_user_list_entry (UserListsWidget* self) {
	NewListEntry* _tmp0_;
	NewListEntry* _tmp1_;
	GtkLabel* _tmp2_;
	GtkSeparator* _tmp3_;
	GtkSeparator* _tmp4_;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	_tmp0_ = self->priv->new_list_entry;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->priv->new_list_entry;
	gtk_widget_set_no_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget), TRUE);
	_tmp2_ = self->priv->user_list_label;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_widget_get_type (), GtkWidget), TRUE);
	self->priv->show_create_entry = FALSE;
	_tmp3_ = self->priv->upper_separator;
	gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp4_ = self->priv->upper_separator;
	gtk_widget_set_no_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), TRUE);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void user_lists_widget_row_activated (UserListsWidget* self, GtkListBoxRow* row) {
	GtkListBoxRow* _tmp0_;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	g_return_if_fail (GTK_IS_LIST_BOX_ROW (row));
	_tmp0_ = row;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_NEW_LIST_ENTRY)) {
		GtkListBoxRow* _tmp1_;
		_tmp1_ = row;
		new_list_entry_reveal (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_NEW_LIST_ENTRY, NewListEntry));
	} else {
		ListListEntry* entry = NULL;
		GtkListBoxRow* _tmp2_;
		ListListEntry* _tmp3_;
		CbBundle* bundle = NULL;
		CbBundle* _tmp4_;
		CbBundle* _tmp5_;
		ListListEntry* _tmp6_;
		gint64 _tmp7_;
		CbBundle* _tmp8_;
		ListListEntry* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		CbBundle* _tmp12_;
		ListListEntry* _tmp13_;
		gboolean _tmp14_;
		CbBundle* _tmp15_;
		ListListEntry* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		CbBundle* _tmp19_;
		ListListEntry* _tmp20_;
		const gchar* _tmp21_;
		CbBundle* _tmp22_;
		ListListEntry* _tmp23_;
		gint _tmp24_;
		CbBundle* _tmp25_;
		ListListEntry* _tmp26_;
		gint _tmp27_;
		CbBundle* _tmp28_;
		ListListEntry* _tmp29_;
		gint64 _tmp30_;
		CbBundle* _tmp31_;
		ListListEntry* _tmp32_;
		const gchar* _tmp33_;
		MainWindow* _tmp34_;
		MainWidget* _tmp35_;
		CbBundle* _tmp36_;
		_tmp2_ = row;
		_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TYPE_LIST_LIST_ENTRY, ListListEntry));
		entry = _tmp3_;
		_tmp4_ = cb_bundle_new ();
		bundle = _tmp4_;
		_tmp5_ = bundle;
		_tmp6_ = entry;
		_tmp7_ = _tmp6_->id;
		cb_bundle_put_int64 (_tmp5_, LIST_STATUSES_PAGE_KEY_LIST_ID, _tmp7_);
		_tmp8_ = bundle;
		_tmp9_ = entry;
		_tmp10_ = list_list_entry_get_name (_tmp9_);
		_tmp11_ = _tmp10_;
		cb_bundle_put_string (_tmp8_, LIST_STATUSES_PAGE_KEY_NAME, _tmp11_);
		_tmp12_ = bundle;
		_tmp13_ = entry;
		_tmp14_ = _tmp13_->user_list;
		cb_bundle_put_bool (_tmp12_, LIST_STATUSES_PAGE_KEY_USER_LIST, _tmp14_);
		_tmp15_ = bundle;
		_tmp16_ = entry;
		_tmp17_ = list_list_entry_get_description (_tmp16_);
		_tmp18_ = _tmp17_;
		cb_bundle_put_string (_tmp15_, LIST_STATUSES_PAGE_KEY_DESCRIPTION, _tmp18_);
		_tmp19_ = bundle;
		_tmp20_ = entry;
		_tmp21_ = _tmp20_->creator_screen_name;
		cb_bundle_put_string (_tmp19_, LIST_STATUSES_PAGE_KEY_CREATOR, _tmp21_);
		_tmp22_ = bundle;
		_tmp23_ = entry;
		_tmp24_ = _tmp23_->n_subscribers;
		cb_bundle_put_int (_tmp22_, LIST_STATUSES_PAGE_KEY_N_SUBSCRIBERS, _tmp24_);
		_tmp25_ = bundle;
		_tmp26_ = entry;
		_tmp27_ = _tmp26_->n_members;
		cb_bundle_put_int (_tmp25_, LIST_STATUSES_PAGE_KEY_N_MEMBERS, _tmp27_);
		_tmp28_ = bundle;
		_tmp29_ = entry;
		_tmp30_ = _tmp29_->created_at;
		cb_bundle_put_int64 (_tmp28_, LIST_STATUSES_PAGE_KEY_CREATED_AT, _tmp30_);
		_tmp31_ = bundle;
		_tmp32_ = entry;
		_tmp33_ = _tmp32_->mode;
		cb_bundle_put_string (_tmp31_, LIST_STATUSES_PAGE_KEY_MODE, _tmp33_);
		_tmp34_ = self->priv->_main_window;
		_tmp35_ = _tmp34_->main_widget;
		_tmp36_ = bundle;
		main_widget_switch_page (_tmp35_, (gint) PAGE_LIST_STATUSES, _tmp36_);
		_g_object_unref0 (bundle);
		_g_object_unref0 (entry);
	}
}


static void _user_lists_widget_row_activated_gtk_list_box_row_activated (GtkListBox* _sender, GtkListBoxRow* row, gpointer self) {
	user_lists_widget_row_activated ((UserListsWidget*) self, row);
}


static void user_lists_widget_load_lists_data_free (gpointer _data) {
	UserListsWidgetLoadListsData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UserListsWidgetLoadListsData, _data_);
}


void user_lists_widget_load_lists (UserListsWidget* self, gint64 user_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UserListsWidgetLoadListsData* _data_;
	UserListsWidget* _tmp0_;
	gint64 _tmp1_;
	_data_ = g_slice_new0 (UserListsWidgetLoadListsData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, user_lists_widget_load_lists_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = user_id;
	_data_->user_id = _tmp1_;
	user_lists_widget_load_lists_co (_data_);
}


void user_lists_widget_load_lists_finish (UserListsWidget* self, GAsyncResult* _res_) {
	UserListsWidgetLoadListsData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static Block46Data* block46_data_ref (Block46Data* _data46_) {
	g_atomic_int_inc (&_data46_->_ref_count_);
	return _data46_;
}


static void block46_data_unref (void * _userdata_) {
	Block46Data* _data46_;
	_data46_ = (Block46Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data46_->_ref_count_)) {
		UserListsWidget* self;
		self = _data46_->self;
		_g_object_unref0 (_data46_->collect_obj);
		_g_object_unref0 (self);
		g_slice_free (Block46Data, _data46_);
	}
}


static void _vala_JsonNode_free (JsonNode* self) {
	g_boxed_free (json_node_get_type (), self);
}


static void __lambda70_ (Block46Data* _data46_, GObject* _, GAsyncResult* res) {
	UserListsWidget* self;
	JsonNode* root = NULL;
	guint n_subscribed_list = 0U;
	JsonNode* _tmp6_;
	GtkListBox* _tmp7_;
	guint _tmp8_;
	guint _tmp9_;
	GError * _inner_error_ = NULL;
	self = _data46_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_;
		JsonNode* _tmp2_;
		JsonNode* _tmp3_;
		_tmp1_ = res;
		_tmp2_ = cb_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch48_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally48;
	__catch48_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("UserListsWidget.vala:100: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally48:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = root;
	_tmp7_ = self->priv->subscribed_list_box;
	_tmp8_ = user_lists_widget_lists_received_cb (self, _tmp6_, _tmp7_);
	n_subscribed_list = _tmp8_;
	_tmp9_ = n_subscribed_list;
	if (_tmp9_ == ((guint) 0)) {
		GtkListBox* _tmp10_;
		GtkFrame* _tmp11_;
		GtkLabel* _tmp12_;
		_tmp10_ = self->priv->subscribed_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
		_tmp11_ = self->priv->subscribed_list_frame;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_widget_get_type (), GtkWidget));
		_tmp12_ = self->priv->subscribed_list_label;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
	} else {
		GtkListBox* _tmp13_;
		GtkFrame* _tmp14_;
		GtkLabel* _tmp15_;
		_tmp13_ = self->priv->subscribed_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
		_tmp14_ = self->priv->subscribed_list_frame;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
		_tmp15_ = self->priv->subscribed_list_label;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
	}
	collect_emit (_data46_->collect_obj, NULL);
	__vala_JsonNode_free0 (root);
}


static void ___lambda70__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda70_ (self, source_object, res);
	block46_data_unref (self);
}


static void __lambda72_ (Block46Data* _data46_, GObject* _, GAsyncResult* res) {
	UserListsWidget* self;
	JsonNode* root = NULL;
	guint n_user_list = 0U;
	JsonNode* _tmp6_;
	GtkListBox* _tmp7_;
	guint _tmp8_;
	gboolean _tmp9_ = FALSE;
	guint _tmp10_;
	GError * _inner_error_ = NULL;
	self = _data46_->self;
	g_return_if_fail ((_ == NULL) || G_IS_OBJECT (_));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	root = NULL;
	{
		JsonNode* _tmp0_ = NULL;
		GAsyncResult* _tmp1_;
		JsonNode* _tmp2_;
		JsonNode* _tmp3_;
		_tmp1_ = res;
		_tmp2_ = cb_utils_load_threaded_finish (_tmp1_, &_inner_error_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch49_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		__vala_JsonNode_free0 (root);
		root = _tmp3_;
		__vala_JsonNode_free0 (_tmp0_);
	}
	goto __finally49;
	__catch49_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("UserListsWidget.vala:127: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally49:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		__vala_JsonNode_free0 (root);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp6_ = root;
	_tmp7_ = self->priv->user_list_box;
	_tmp8_ = user_lists_widget_lists_received_cb (self, _tmp6_, _tmp7_);
	n_user_list = _tmp8_;
	_tmp10_ = n_user_list;
	if (_tmp10_ == ((guint) 0)) {
		gboolean _tmp11_;
		_tmp11_ = self->priv->show_create_entry;
		_tmp9_ = !_tmp11_;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		GtkLabel* _tmp12_;
		GtkListBox* _tmp13_;
		GtkFrame* _tmp14_;
		GtkFrame* _tmp15_;
		_tmp12_ = self->priv->user_list_label;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
		_tmp13_ = self->priv->user_list_box;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
		_tmp14_ = self->priv->user_list_frame;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
		_tmp15_ = self->priv->user_list_frame;
		gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget), 0);
	} else {
		GtkLabel* _tmp16_;
		gboolean _tmp17_;
		gint _tmp18_ = 0;
		gboolean _tmp19_;
		GtkFrame* _tmp20_;
		GtkListBox* _tmp21_;
		GtkFrame* _tmp22_;
		GtkRevealer* _tmp23_;
		guint _tmp24_;
		_tmp16_ = self->priv->user_list_label;
		_tmp17_ = self->priv->show_create_entry;
		gtk_widget_set_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), !_tmp17_);
		_tmp19_ = self->priv->show_create_entry;
		if (_tmp19_) {
			_tmp18_ = 24;
		} else {
			_tmp18_ = 0;
		}
		_tmp20_ = self->priv->user_list_frame;
		gtk_widget_set_margin_top (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, gtk_widget_get_type (), GtkWidget), _tmp18_);
		_tmp21_ = self->priv->user_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, gtk_widget_get_type (), GtkWidget));
		_tmp22_ = self->priv->user_list_frame;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp22_, gtk_widget_get_type (), GtkWidget));
		_tmp23_ = self->priv->user_lists_revealer;
		_tmp24_ = n_user_list;
		gtk_revealer_set_reveal_child (_tmp23_, _tmp24_ > ((guint) 0));
	}
	collect_emit (_data46_->collect_obj, NULL);
	__vala_JsonNode_free0 (root);
}


static void ___lambda72__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda72_ (self, source_object, res);
	block46_data_unref (self);
}


static void __lambda73_ (Block46Data* _data46_) {
	UserListsWidget* self;
	self = _data46_->self;
	user_lists_widget_load_lists_co (_data46_->_async_data_);
}


static void ___lambda73__collect_finished (Collect* _sender, GError* _error_, gpointer self) {
	__lambda73_ (self);
}


static gboolean user_lists_widget_load_lists_co (UserListsWidgetLoadListsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data46_ = g_slice_new0 (Block46Data);
	_data_->_data46_->_ref_count_ = 1;
	_data_->_data46_->self = g_object_ref (_data_->self);
	_data_->_data46_->_async_data_ = _data_;
	_data_->_tmp0_ = _data_->user_id;
	if (_data_->_tmp0_ == ((gint64) 0)) {
		_data_->_tmp1_ = _data_->self->priv->_account;
		_data_->_tmp2_ = _data_->_tmp1_->id;
		_data_->user_id = _data_->_tmp2_;
	}
	_data_->_tmp3_ = collect_new (2);
	_data_->_data46_->collect_obj = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->self->priv->_account;
	_data_->_tmp5_ = _data_->_tmp4_->proxy;
	_data_->_tmp6_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp5_, rest_proxy_get_type (), RestProxy));
	_data_->call = _data_->_tmp6_;
	rest_proxy_call_set_function (_data_->call, "1.1/lists/subscriptions.json");
	rest_proxy_call_set_method (_data_->call, "GET");
	rest_proxy_call_add_param (_data_->call, "count", "200");
	_data_->_tmp7_ = _data_->user_id;
	_data_->_tmp8_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp7_);
	_data_->_tmp9_ = _data_->_tmp8_;
	rest_proxy_call_add_param (_data_->call, "user_id", _data_->_tmp9_);
	_g_free0 (_data_->_tmp9_);
	cb_utils_load_threaded_async (_data_->call, NULL, ___lambda70__gasync_ready_callback, block46_data_ref (_data_->_data46_));
	_data_->_tmp10_ = _data_->self->priv->_account;
	_data_->_tmp11_ = _data_->_tmp10_->proxy;
	_data_->_tmp12_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp11_, rest_proxy_get_type (), RestProxy));
	_data_->user_call = _data_->_tmp12_;
	rest_proxy_call_set_function (_data_->user_call, "1.1/lists/ownerships.json");
	rest_proxy_call_set_method (_data_->user_call, "GET");
	_data_->_tmp13_ = _data_->user_id;
	_data_->_tmp14_ = g_strdup_printf ("%" G_GINT64_FORMAT, _data_->_tmp13_);
	_data_->_tmp15_ = _data_->_tmp14_;
	rest_proxy_call_add_param (_data_->user_call, "user_id", _data_->_tmp15_);
	_g_free0 (_data_->_tmp15_);
	rest_proxy_call_add_param (_data_->user_call, "count", "200");
	cb_utils_load_threaded_async (_data_->user_call, NULL, ___lambda72__gasync_ready_callback, block46_data_ref (_data_->_data46_));
	g_signal_connect_data (_data_->_data46_->collect_obj, "finished", (GCallback) ___lambda73__collect_finished, block46_data_ref (_data_->_data46_), (GClosureNotify) block46_data_unref, 0);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_g_object_unref0 (_data_->user_call);
	_g_object_unref0 (_data_->call);
	block46_data_unref (_data_->_data46_);
	_data_->_data46_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static Block47Data* block47_data_ref (Block47Data* _data47_) {
	g_atomic_int_inc (&_data47_->_ref_count_);
	return _data47_;
}


static void block47_data_unref (void * _userdata_) {
	Block47Data* _data47_;
	_data47_ = (Block47Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data47_->_ref_count_)) {
		UserListsWidget* self;
		self = _data47_->self;
		_g_object_unref0 (_data47_->list_box);
		_g_object_unref0 (self);
		g_slice_free (Block47Data, _data47_);
	}
}


static gpointer _json_array_ref0 (gpointer self) {
	return self ? json_array_ref (self) : NULL;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void __lambda71_ (Block47Data* _data47_, JsonArray* array, guint index, JsonNode* node) {
	UserListsWidget* self;
	JsonObject* obj = NULL;
	JsonNode* _tmp0_;
	JsonObject* _tmp1_;
	JsonObject* _tmp2_;
	ListListEntry* entry = NULL;
	Account* _tmp3_;
	ListListEntry* _tmp4_;
	GtkListBox* _tmp5_;
	self = _data47_->self;
	g_return_if_fail (array != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node;
	_tmp1_ = json_node_get_object (_tmp0_);
	_tmp2_ = _json_object_ref0 (_tmp1_);
	obj = _tmp2_;
	_tmp3_ = self->priv->_account;
	_tmp4_ = list_list_entry_new_from_json_data (obj, _tmp3_);
	g_object_ref_sink (_tmp4_);
	entry = _tmp4_;
	_tmp5_ = _data47_->list_box;
	gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (entry, gtk_widget_get_type (), GtkWidget));
	_g_object_unref0 (entry);
	_json_object_unref0 (obj);
}


static void ___lambda71__json_array_foreach (JsonArray* array, guint index_, JsonNode* element_node, gpointer self) {
	__lambda71_ (self, array, index_, element_node);
}


static guint user_lists_widget_lists_received_cb (UserListsWidget* self, JsonNode* root, GtkListBox* list_box) {
	guint result = 0U;
	Block47Data* _data47_;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	JsonNode* _tmp2_;
	JsonArray* arr = NULL;
	JsonNode* _tmp3_;
	JsonObject* _tmp4_;
	JsonArray* _tmp5_;
	JsonArray* _tmp6_;
	JsonArray* _tmp7_;
	JsonArray* _tmp8_;
	guint _tmp9_;
	g_return_val_if_fail (IS_USER_LISTS_WIDGET (self), 0U);
	g_return_val_if_fail (GTK_IS_LIST_BOX (list_box), 0U);
	_data47_ = g_slice_new0 (Block47Data);
	_data47_->_ref_count_ = 1;
	_data47_->self = g_object_ref (self);
	_tmp0_ = list_box;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data47_->list_box);
	_data47_->list_box = _tmp1_;
	_tmp2_ = root;
	if (_tmp2_ == NULL) {
		result = (guint) 0;
		block47_data_unref (_data47_);
		_data47_ = NULL;
		return result;
	}
	_tmp3_ = root;
	_tmp4_ = json_node_get_object (_tmp3_);
	_tmp5_ = json_object_get_array_member (_tmp4_, "lists");
	_tmp6_ = _json_array_ref0 (_tmp5_);
	arr = _tmp6_;
	_tmp7_ = arr;
	json_array_foreach_element (_tmp7_, ___lambda71__json_array_foreach, _data47_);
	_tmp8_ = arr;
	_tmp9_ = json_array_get_length (_tmp8_);
	result = _tmp9_;
	_json_array_unref0 (arr);
	block47_data_unref (_data47_);
	_data47_ = NULL;
	return result;
}


static Block48Data* block48_data_ref (Block48Data* _data48_) {
	g_atomic_int_inc (&_data48_->_ref_count_);
	return _data48_;
}


static void block48_data_unref (void * _userdata_) {
	Block48Data* _data48_;
	_data48_ = (Block48Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data48_->_ref_count_)) {
		UserListsWidget* self;
		self = _data48_->self;
		_g_object_unref0 (self);
		g_slice_free (Block48Data, _data48_);
	}
}


static void __lambda74_ (Block48Data* _data48_, GtkWidget* w) {
	UserListsWidget* self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	self = _data48_->self;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LIST_LIST_ENTRY)) {
		return;
	}
	_tmp1_ = w;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIST_LIST_ENTRY, ListListEntry)->id;
	_tmp3_ = _data48_->list_id;
	if (_tmp2_ == _tmp3_) {
		GtkListBox* _tmp4_;
		GtkWidget* _tmp5_;
		guint _tmp6_;
		_tmp4_ = self->priv->user_list_box;
		_tmp5_ = w;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer), _tmp5_);
		_tmp6_ = _data48_->n_user_lists;
		if ((_tmp6_ - 1) == ((guint) 0)) {
			GtkRevealer* _tmp7_;
			_tmp7_ = self->priv->user_lists_revealer;
			gtk_revealer_set_reveal_child (_tmp7_, FALSE);
		}
	}
}


static void ___lambda74__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda74_ (self, widget);
}


static void __lambda75_ (Block48Data* _data48_, GtkWidget* w) {
	UserListsWidget* self;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	gint64 _tmp2_;
	gint64 _tmp3_;
	self = _data48_->self;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LIST_LIST_ENTRY)) {
		return;
	}
	_tmp1_ = w;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIST_LIST_ENTRY, ListListEntry)->id;
	_tmp3_ = _data48_->list_id;
	if (_tmp2_ == _tmp3_) {
		GtkListBox* _tmp4_;
		GtkWidget* _tmp5_;
		_tmp4_ = self->priv->subscribed_list_box;
		_tmp5_ = w;
		gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_container_get_type (), GtkContainer), _tmp5_);
	}
}


static void ___lambda75__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda75_ (self, widget);
}


void user_lists_widget_remove_list (UserListsWidget* self, gint64 list_id) {
	Block48Data* _data48_;
	gint64 _tmp0_;
	GtkListBox* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	guint _tmp4_;
	guint _tmp5_;
	GtkListBox* _tmp6_;
	GtkListBox* _tmp7_;
	GtkListBox* _tmp8_;
	GList* _tmp9_;
	GList* _tmp10_;
	guint _tmp11_;
	gboolean _tmp12_;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	_data48_ = g_slice_new0 (Block48Data);
	_data48_->_ref_count_ = 1;
	_data48_->self = g_object_ref (self);
	_tmp0_ = list_id;
	_data48_->list_id = _tmp0_;
	_tmp1_ = self->priv->user_list_box;
	_tmp2_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer));
	_tmp3_ = _tmp2_;
	_tmp4_ = g_list_length (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_list_free0 (_tmp3_);
	_data48_->n_user_lists = _tmp5_;
	_tmp6_ = self->priv->user_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_container_get_type (), GtkContainer), ___lambda74__gtk_callback, _data48_);
	_tmp7_ = self->priv->subscribed_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer), ___lambda75__gtk_callback, _data48_);
	_tmp8_ = self->priv->subscribed_list_box;
	_tmp9_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, gtk_container_get_type (), GtkContainer));
	_tmp10_ = _tmp9_;
	_tmp11_ = g_list_length (_tmp10_);
	_tmp12_ = _tmp11_ == ((guint) 0);
	_g_list_free0 (_tmp10_);
	if (_tmp12_) {
		GtkLabel* _tmp13_;
		GtkFrame* _tmp14_;
		_tmp13_ = self->priv->subscribed_list_label;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
		_tmp14_ = self->priv->subscribed_list_frame;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_widget_get_type (), GtkWidget));
	}
	block48_data_unref (_data48_);
	_data48_ = NULL;
}


void user_lists_widget_add_list (UserListsWidget* self, ListListEntry* entry) {
	ListListEntry* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	g_return_if_fail (IS_LIST_LIST_ENTRY (entry));
	_tmp0_ = entry;
	_tmp1_ = _tmp0_->user_list;
	if (_tmp1_) {
		GList* user_lists = NULL;
		GtkListBox* _tmp2_;
		GList* _tmp3_;
		GList* _tmp4_;
		GtkListBox* _tmp11_;
		ListListEntry* _tmp12_;
		GtkRevealer* _tmp13_;
		_tmp2_ = self->priv->user_list_box;
		_tmp3_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, gtk_container_get_type (), GtkContainer));
		user_lists = _tmp3_;
		_tmp4_ = user_lists;
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp4_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp5_;
				GtkWidget* w = NULL;
				_tmp5_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp5_;
				{
					GtkWidget* _tmp6_;
					GtkWidget* _tmp7_;
					gint64 _tmp8_;
					ListListEntry* _tmp9_;
					gint64 _tmp10_;
					_tmp6_ = w;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_LIST_LIST_ENTRY)) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp7_ = w;
					_tmp8_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_LIST_LIST_ENTRY, ListListEntry)->id;
					_tmp9_ = entry;
					_tmp10_ = _tmp9_->id;
					if (_tmp8_ == _tmp10_) {
						_g_object_unref0 (w);
						_g_list_free0 (user_lists);
						return;
					}
					_g_object_unref0 (w);
				}
			}
		}
		_tmp11_ = self->priv->user_list_box;
		_tmp12_ = entry;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp11_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
		_tmp13_ = self->priv->user_lists_revealer;
		gtk_revealer_set_reveal_child (_tmp13_, TRUE);
		_g_list_free0 (user_lists);
	} else {
		GList* subscribed_lists = NULL;
		GtkListBox* _tmp14_;
		GList* _tmp15_;
		GList* _tmp16_;
		GtkListBox* _tmp23_;
		ListListEntry* _tmp24_;
		GtkFrame* _tmp25_;
		GtkListBox* _tmp26_;
		GtkLabel* _tmp27_;
		_tmp14_ = self->priv->subscribed_list_box;
		_tmp15_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_container_get_type (), GtkContainer));
		subscribed_lists = _tmp15_;
		_tmp16_ = subscribed_lists;
		{
			GList* w_collection = NULL;
			GList* w_it = NULL;
			w_collection = _tmp16_;
			for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
				GtkWidget* _tmp17_;
				GtkWidget* w = NULL;
				_tmp17_ = _g_object_ref0 ((GtkWidget*) w_it->data);
				w = _tmp17_;
				{
					GtkWidget* _tmp18_;
					GtkWidget* _tmp19_;
					gint64 _tmp20_;
					ListListEntry* _tmp21_;
					gint64 _tmp22_;
					_tmp18_ = w;
					if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, TYPE_LIST_LIST_ENTRY)) {
						_g_object_unref0 (w);
						continue;
					}
					_tmp19_ = w;
					_tmp20_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp19_, TYPE_LIST_LIST_ENTRY, ListListEntry)->id;
					_tmp21_ = entry;
					_tmp22_ = _tmp21_->id;
					if (_tmp20_ == _tmp22_) {
						_g_object_unref0 (w);
						_g_list_free0 (subscribed_lists);
						return;
					}
					_g_object_unref0 (w);
				}
			}
		}
		_tmp23_ = self->priv->subscribed_list_box;
		_tmp24_ = entry;
		gtk_container_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp23_, gtk_container_get_type (), GtkContainer), G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_widget_get_type (), GtkWidget));
		_tmp25_ = self->priv->subscribed_list_frame;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp25_, gtk_widget_get_type (), GtkWidget));
		_tmp26_ = self->priv->subscribed_list_box;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, gtk_widget_get_type (), GtkWidget));
		_tmp27_ = self->priv->subscribed_list_label;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, gtk_widget_get_type (), GtkWidget));
		_g_list_free0 (subscribed_lists);
	}
}


static Block49Data* block49_data_ref (Block49Data* _data49_) {
	g_atomic_int_inc (&_data49_->_ref_count_);
	return _data49_;
}


static void block49_data_unref (void * _userdata_) {
	Block49Data* _data49_;
	_data49_ = (Block49Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data49_->_ref_count_)) {
		UserListsWidget* self;
		self = _data49_->self;
		_g_free0 (_data49_->name);
		_g_free0 (_data49_->description);
		_g_free0 (_data49_->mode);
		_g_object_unref0 (self);
		g_slice_free (Block49Data, _data49_);
	}
}


static void __lambda76_ (Block49Data* _data49_, GtkWidget* w) {
	UserListsWidget* self;
	GtkWidget* _tmp0_;
	ListListEntry* lle = NULL;
	GtkWidget* _tmp1_;
	ListListEntry* _tmp2_;
	ListListEntry* _tmp3_;
	gint64 _tmp4_;
	gint64 _tmp5_;
	self = _data49_->self;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = w;
	if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_LIST_LIST_ENTRY)) {
		return;
	}
	_tmp1_ = w;
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_LIST_LIST_ENTRY, ListListEntry));
	lle = _tmp2_;
	_tmp3_ = lle;
	_tmp4_ = _tmp3_->id;
	_tmp5_ = _data49_->list_id;
	if (_tmp4_ == _tmp5_) {
		ListListEntry* _tmp6_;
		const gchar* _tmp7_;
		ListListEntry* _tmp8_;
		const gchar* _tmp9_;
		ListListEntry* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		ListListEntry* _tmp13_;
		_tmp6_ = lle;
		_tmp7_ = _data49_->name;
		list_list_entry_set_name (_tmp6_, _tmp7_);
		_tmp8_ = lle;
		_tmp9_ = _data49_->description;
		list_list_entry_set_description (_tmp8_, _tmp9_);
		_tmp10_ = lle;
		_tmp11_ = _data49_->mode;
		_tmp12_ = g_strdup (_tmp11_);
		_g_free0 (_tmp10_->mode);
		_tmp10_->mode = _tmp12_;
		_tmp13_ = lle;
		gtk_widget_queue_draw (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
	}
	_g_object_unref0 (lle);
}


static void ___lambda76__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda76_ (self, widget);
}


void user_lists_widget_update_list (UserListsWidget* self, gint64 list_id, const gchar* name, const gchar* description, const gchar* mode) {
	Block49Data* _data49_;
	gint64 _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	GtkListBox* _tmp7_;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	g_return_if_fail (name != NULL);
	g_return_if_fail (description != NULL);
	g_return_if_fail (mode != NULL);
	_data49_ = g_slice_new0 (Block49Data);
	_data49_->_ref_count_ = 1;
	_data49_->self = g_object_ref (self);
	_tmp0_ = list_id;
	_data49_->list_id = _tmp0_;
	_tmp1_ = name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data49_->name);
	_data49_->name = _tmp2_;
	_tmp3_ = description;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data49_->description);
	_data49_->description = _tmp4_;
	_tmp5_ = mode;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (_data49_->mode);
	_data49_->mode = _tmp6_;
	_tmp7_ = self->priv->user_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_container_get_type (), GtkContainer), ___lambda76__gtk_callback, _data49_);
	block49_data_unref (_data49_);
	_data49_ = NULL;
}


void user_lists_widget_update_member_count (UserListsWidget* self, gint64 list_id, gint increase) {
	GList* lists = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	_tmp0_ = self->priv->user_list_box;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	lists = _tmp1_;
	_tmp2_ = lists;
	{
		GList* list_collection = NULL;
		GList* list_it = NULL;
		list_collection = _tmp2_;
		for (list_it = list_collection; list_it != NULL; list_it = list_it->next) {
			GtkWidget* list = NULL;
			list = (GtkWidget*) list_it->data;
			{
				GtkWidget* _tmp3_;
				ListListEntry* lle = NULL;
				GtkWidget* _tmp4_;
				ListListEntry* _tmp5_;
				ListListEntry* _tmp6_;
				gint64 _tmp7_;
				gint64 _tmp8_;
				_tmp3_ = list;
				if (!G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, TYPE_LIST_LIST_ENTRY)) {
					continue;
				}
				_tmp4_ = list;
				_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_LIST_LIST_ENTRY, ListListEntry));
				lle = _tmp5_;
				_tmp6_ = lle;
				_tmp7_ = _tmp6_->id;
				_tmp8_ = list_id;
				if (_tmp7_ == _tmp8_) {
					ListListEntry* _tmp9_;
					ListListEntry* _tmp10_;
					gint _tmp11_;
					gint _tmp12_;
					_tmp9_ = lle;
					_tmp10_ = lle;
					_tmp11_ = _tmp10_->n_members;
					_tmp12_ = increase;
					_tmp10_->n_members = _tmp11_ + _tmp12_;
					_g_object_unref0 (lle);
					break;
				}
				_g_object_unref0 (lle);
			}
		}
	}
	_g_list_free0 (lists);
}


static void _vala_TwitterList_array_free (TwitterList * array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			twitter_list_destroy (&array[i]);
		}
	}
	g_free (array);
}


TwitterList* user_lists_widget_get_user_lists (UserListsWidget* self, int* result_length1) {
	TwitterList* result = NULL;
	GList* children = NULL;
	GtkListBox* _tmp0_;
	GList* _tmp1_;
	TwitterList* lists = NULL;
	GList* _tmp2_;
	guint _tmp3_;
	TwitterList* _tmp4_;
	gint lists_length1;
	gint _lists_size_;
	gint i = 0;
	GList* _tmp5_;
	TwitterList* _tmp36_;
	gint _tmp36__length1;
	g_return_val_if_fail (IS_USER_LISTS_WIDGET (self), NULL);
	_tmp0_ = self->priv->user_list_box;
	_tmp1_ = gtk_container_get_children (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer));
	children = _tmp1_;
	_tmp2_ = children;
	_tmp3_ = g_list_length (_tmp2_);
	_tmp4_ = g_new0 (TwitterList, _tmp3_);
	lists = _tmp4_;
	lists_length1 = _tmp3_;
	_lists_size_ = lists_length1;
	i = 0;
	_tmp5_ = children;
	{
		GList* w_collection = NULL;
		GList* w_it = NULL;
		w_collection = _tmp5_;
		for (w_it = w_collection; w_it != NULL; w_it = w_it->next) {
			GtkWidget* _tmp6_;
			GtkWidget* w = NULL;
			_tmp6_ = _g_object_ref0 ((GtkWidget*) w_it->data);
			w = _tmp6_;
			{
				GtkWidget* _tmp7_;
				ListListEntry* lle = NULL;
				GtkWidget* _tmp8_;
				ListListEntry* _tmp9_;
				TwitterList* _tmp10_;
				gint _tmp10__length1;
				gint _tmp11_;
				ListListEntry* _tmp12_;
				gint64 _tmp13_;
				TwitterList* _tmp14_;
				gint _tmp14__length1;
				gint _tmp15_;
				ListListEntry* _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				gchar* _tmp19_;
				TwitterList* _tmp20_;
				gint _tmp20__length1;
				gint _tmp21_;
				ListListEntry* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				TwitterList* _tmp26_;
				gint _tmp26__length1;
				gint _tmp27_;
				ListListEntry* _tmp28_;
				const gchar* _tmp29_;
				gchar* _tmp30_;
				TwitterList* _tmp31_;
				gint _tmp31__length1;
				gint _tmp32_;
				ListListEntry* _tmp33_;
				gint _tmp34_;
				gint _tmp35_;
				_tmp7_ = w;
				_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp7_, TYPE_LIST_LIST_ENTRY), "w is ListListEntry");
				_tmp8_ = w;
				_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_LIST_LIST_ENTRY, ListListEntry));
				lle = _tmp9_;
				_tmp10_ = lists;
				_tmp10__length1 = lists_length1;
				_tmp11_ = i;
				_tmp12_ = lle;
				_tmp13_ = _tmp12_->id;
				_tmp10_[_tmp11_].id = _tmp13_;
				_tmp14_ = lists;
				_tmp14__length1 = lists_length1;
				_tmp15_ = i;
				_tmp16_ = lle;
				_tmp17_ = list_list_entry_get_name (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = g_strdup (_tmp18_);
				_g_free0 (_tmp14_[_tmp15_].name);
				_tmp14_[_tmp15_].name = _tmp19_;
				_tmp20_ = lists;
				_tmp20__length1 = lists_length1;
				_tmp21_ = i;
				_tmp22_ = lle;
				_tmp23_ = list_list_entry_get_description (_tmp22_);
				_tmp24_ = _tmp23_;
				_tmp25_ = g_strdup (_tmp24_);
				_g_free0 (_tmp20_[_tmp21_].description);
				_tmp20_[_tmp21_].description = _tmp25_;
				_tmp26_ = lists;
				_tmp26__length1 = lists_length1;
				_tmp27_ = i;
				_tmp28_ = lle;
				_tmp29_ = _tmp28_->mode;
				_tmp30_ = g_strdup (_tmp29_);
				_g_free0 (_tmp26_[_tmp27_].mode);
				_tmp26_[_tmp27_].mode = _tmp30_;
				_tmp31_ = lists;
				_tmp31__length1 = lists_length1;
				_tmp32_ = i;
				_tmp33_ = lle;
				_tmp34_ = _tmp33_->n_members;
				_tmp31_[_tmp32_].n_members = (guint) _tmp34_;
				_tmp35_ = i;
				i = _tmp35_ + 1;
				_g_object_unref0 (lle);
				_g_object_unref0 (w);
			}
		}
	}
	_tmp36_ = lists;
	_tmp36__length1 = lists_length1;
	if (result_length1) {
		*result_length1 = _tmp36__length1;
	}
	result = _tmp36_;
	_g_list_free0 (children);
	return result;
}


static void __lambda78_ (UserListsWidget* self, GtkWidget* w) {
	GtkListBox* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->user_list_box;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda78__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda78_ ((UserListsWidget*) self, widget);
}


static void __lambda79_ (UserListsWidget* self, GtkWidget* w) {
	GtkListBox* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (GTK_IS_WIDGET (w));
	_tmp0_ = self->priv->subscribed_list_box;
	_tmp1_ = w;
	gtk_container_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), _tmp1_);
}


static void ___lambda79__gtk_callback (GtkWidget* widget, gpointer self) {
	__lambda79_ ((UserListsWidget*) self, widget);
}


void user_lists_widget_clear_lists (UserListsWidget* self) {
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	_tmp0_ = self->priv->user_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_container_get_type (), GtkContainer), ___lambda78__gtk_callback, self);
	_tmp1_ = self->priv->subscribed_list_box;
	gtk_container_foreach (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_container_get_type (), GtkContainer), ___lambda79__gtk_callback, self);
}


static Block50Data* block50_data_ref (Block50Data* _data50_) {
	g_atomic_int_inc (&_data50_->_ref_count_);
	return _data50_;
}


static void block50_data_unref (void * _userdata_) {
	Block50Data* _data50_;
	_data50_ = (Block50Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data50_->_ref_count_)) {
		UserListsWidget* self;
		self = _data50_->self;
		_g_object_unref0 (_data50_->call);
		_g_object_unref0 (self);
		g_slice_free (Block50Data, _data50_);
	}
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	_tmp1_ = _result_;
	g_strstrip (_tmp1_);
	result = _result_;
	return result;
}


static void __lambda80_ (Block50Data* _data50_, GObject* o, GAsyncResult* res) {
	UserListsWidget* self;
	JsonParser* parser = NULL;
	JsonParser* _tmp8_;
	JsonObject* root = NULL;
	JsonParser* _tmp14_;
	JsonNode* _tmp15_;
	JsonObject* _tmp16_;
	JsonObject* _tmp17_;
	ListListEntry* entry = NULL;
	JsonObject* _tmp18_;
	Account* _tmp19_;
	ListListEntry* _tmp20_;
	ListListEntry* _tmp21_;
	CbBundle* bundle = NULL;
	CbBundle* _tmp22_;
	CbBundle* _tmp23_;
	ListListEntry* _tmp24_;
	gint64 _tmp25_;
	CbBundle* _tmp26_;
	ListListEntry* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	CbBundle* _tmp30_;
	CbBundle* _tmp31_;
	ListListEntry* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	CbBundle* _tmp35_;
	ListListEntry* _tmp36_;
	const gchar* _tmp37_;
	CbBundle* _tmp38_;
	ListListEntry* _tmp39_;
	gint _tmp40_;
	CbBundle* _tmp41_;
	ListListEntry* _tmp42_;
	gint _tmp43_;
	CbBundle* _tmp44_;
	ListListEntry* _tmp45_;
	gint64 _tmp46_;
	CbBundle* _tmp47_;
	ListListEntry* _tmp48_;
	const gchar* _tmp49_;
	MainWindow* _tmp50_;
	MainWidget* _tmp51_;
	CbBundle* _tmp52_;
	NewListEntry* _tmp53_;
	GError * _inner_error_ = NULL;
	self = _data50_->self;
	g_return_if_fail ((o == NULL) || G_IS_OBJECT (o));
	g_return_if_fail (G_IS_ASYNC_RESULT (res));
	{
		RestProxyCall* _tmp0_;
		GAsyncResult* _tmp1_;
		_tmp0_ = _data50_->call;
		_tmp1_ = res;
		rest_proxy_call_invoke_finish (_tmp0_, _tmp1_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch50_g_error;
		}
	}
	goto __finally50;
	__catch50_g_error:
	{
		GError* e = NULL;
		RestProxyCall* _tmp2_;
		const gchar* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		MainWindow* _tmp6_;
		NewListEntry* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = _data50_->call;
		_tmp3_ = rest_proxy_call_get_payload (_tmp2_);
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		_tmp6_ = self->priv->_main_window;
		utils_show_error_object (_tmp3_, _tmp5_, 293, "UserListsWidget.vala", G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow));
		_tmp7_ = self->priv->new_list_entry;
		gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget), TRUE);
		_g_error_free0 (e);
		return;
	}
	__finally50:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = json_parser_new ();
	parser = _tmp8_;
	{
		JsonParser* _tmp9_;
		RestProxyCall* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = parser;
		_tmp10_ = _data50_->call;
		_tmp11_ = rest_proxy_call_get_payload (_tmp10_);
		json_parser_load_from_data (_tmp9_, _tmp11_, (gssize) -1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch51_g_error;
		}
	}
	goto __finally51;
	__catch51_g_error:
	{
		GError* e = NULL;
		GError* _tmp12_;
		const gchar* _tmp13_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		g_critical ("UserListsWidget.vala:301: %s", _tmp13_);
		_g_error_free0 (e);
		_g_object_unref0 (parser);
		return;
	}
	__finally51:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (parser);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp14_ = parser;
	_tmp15_ = json_parser_get_root (_tmp14_);
	_tmp16_ = json_node_get_object (_tmp15_);
	_tmp17_ = _json_object_ref0 (_tmp16_);
	root = _tmp17_;
	_tmp18_ = root;
	_tmp19_ = self->priv->_account;
	_tmp20_ = list_list_entry_new_from_json_data (_tmp18_, _tmp19_);
	g_object_ref_sink (_tmp20_);
	entry = _tmp20_;
	_tmp21_ = entry;
	user_lists_widget_add_list (self, _tmp21_);
	_tmp22_ = cb_bundle_new ();
	bundle = _tmp22_;
	_tmp23_ = bundle;
	_tmp24_ = entry;
	_tmp25_ = _tmp24_->id;
	cb_bundle_put_int64 (_tmp23_, LIST_STATUSES_PAGE_KEY_LIST_ID, _tmp25_);
	_tmp26_ = bundle;
	_tmp27_ = entry;
	_tmp28_ = list_list_entry_get_name (_tmp27_);
	_tmp29_ = _tmp28_;
	cb_bundle_put_string (_tmp26_, LIST_STATUSES_PAGE_KEY_NAME, _tmp29_);
	_tmp30_ = bundle;
	cb_bundle_put_bool (_tmp30_, LIST_STATUSES_PAGE_KEY_USER_LIST, TRUE);
	_tmp31_ = bundle;
	_tmp32_ = entry;
	_tmp33_ = list_list_entry_get_description (_tmp32_);
	_tmp34_ = _tmp33_;
	cb_bundle_put_string (_tmp31_, LIST_STATUSES_PAGE_KEY_DESCRIPTION, _tmp34_);
	_tmp35_ = bundle;
	_tmp36_ = entry;
	_tmp37_ = _tmp36_->creator_screen_name;
	cb_bundle_put_string (_tmp35_, LIST_STATUSES_PAGE_KEY_CREATOR, _tmp37_);
	_tmp38_ = bundle;
	_tmp39_ = entry;
	_tmp40_ = _tmp39_->n_subscribers;
	cb_bundle_put_int (_tmp38_, LIST_STATUSES_PAGE_KEY_N_SUBSCRIBERS, _tmp40_);
	_tmp41_ = bundle;
	_tmp42_ = entry;
	_tmp43_ = _tmp42_->n_members;
	cb_bundle_put_int (_tmp41_, LIST_STATUSES_PAGE_KEY_N_MEMBERS, _tmp43_);
	_tmp44_ = bundle;
	_tmp45_ = entry;
	_tmp46_ = _tmp45_->created_at;
	cb_bundle_put_int64 (_tmp44_, LIST_STATUSES_PAGE_KEY_CREATED_AT, _tmp46_);
	_tmp47_ = bundle;
	_tmp48_ = entry;
	_tmp49_ = _tmp48_->mode;
	cb_bundle_put_string (_tmp47_, LIST_STATUSES_PAGE_KEY_MODE, _tmp49_);
	_tmp50_ = self->priv->_main_window;
	_tmp51_ = _tmp50_->main_widget;
	_tmp52_ = bundle;
	main_widget_switch_page (_tmp51_, (gint) PAGE_LIST_STATUSES, _tmp52_);
	_tmp53_ = self->priv->new_list_entry;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp53_, gtk_widget_get_type (), GtkWidget), TRUE);
	_g_object_unref0 (bundle);
	_g_object_unref0 (entry);
	_json_object_unref0 (root);
	_g_object_unref0 (parser);
}


static void ___lambda80__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda80_ (self, source_object, res);
	block50_data_unref (self);
}


static void user_lists_widget_new_list_create_activated_cb (UserListsWidget* self, const gchar* list_name) {
	Block50Data* _data50_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean _tmp5_;
	NewListEntry* _tmp6_;
	Account* _tmp7_;
	OAuthProxy* _tmp8_;
	RestProxyCall* _tmp9_;
	RestProxyCall* _tmp10_;
	RestProxyCall* _tmp11_;
	RestProxyCall* _tmp12_;
	const gchar* _tmp13_;
	RestProxyCall* _tmp14_;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	g_return_if_fail (list_name != NULL);
	_data50_ = g_slice_new0 (Block50Data);
	_data50_->_ref_count_ = 1;
	_data50_->self = g_object_ref (self);
	_tmp0_ = list_name;
	_tmp1_ = string_strip (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_ <= 0;
	_g_free0 (_tmp2_);
	if (_tmp5_) {
		block50_data_unref (_data50_);
		_data50_ = NULL;
		return;
	}
	_tmp6_ = self->priv->new_list_entry;
	gtk_widget_set_sensitive (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget), FALSE);
	_tmp7_ = self->priv->_account;
	_tmp8_ = _tmp7_->proxy;
	_tmp9_ = rest_proxy_new_call (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, rest_proxy_get_type (), RestProxy));
	_data50_->call = _tmp9_;
	_tmp10_ = _data50_->call;
	rest_proxy_call_set_function (_tmp10_, "1.1/lists/create.json");
	_tmp11_ = _data50_->call;
	rest_proxy_call_set_method (_tmp11_, "POST");
	_tmp12_ = _data50_->call;
	_tmp13_ = list_name;
	rest_proxy_call_add_param (_tmp12_, "name", _tmp13_);
	_tmp14_ = _data50_->call;
	rest_proxy_call_invoke_async (_tmp14_, NULL, ___lambda80__gasync_ready_callback, block50_data_ref (_data50_));
	block50_data_unref (_data50_);
	_data50_ = NULL;
}


static void _user_lists_widget_new_list_create_activated_cb_new_list_entry_create_activated (NewListEntry* _sender, const gchar* list_name, gpointer self) {
	user_lists_widget_new_list_create_activated_cb ((UserListsWidget*) self, list_name);
}


void user_lists_widget_unreveal (UserListsWidget* self) {
	NewListEntry* _tmp0_;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	_tmp0_ = self->priv->new_list_entry;
	new_list_entry_unreveal (_tmp0_);
}


static gboolean user_lists_widget_new_list_box_keynav_failed_cb (UserListsWidget* self, GtkDirectionType direction) {
	gboolean result = FALSE;
	GtkDirectionType _tmp0_;
	g_return_val_if_fail (IS_USER_LISTS_WIDGET (self), FALSE);
	_tmp0_ = direction;
	if (_tmp0_ == GTK_DIR_DOWN) {
		GtkListBox* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->user_list_box;
		_tmp2_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			GtkListBox* _tmp4_;
			GtkDirectionType _tmp5_;
			_tmp4_ = self->priv->user_list_box;
			_tmp5_ = direction;
			gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp5_);
			result = GDK_EVENT_STOP;
			return result;
		} else {
			GtkListBox* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = self->priv->subscribed_list_box;
			_tmp7_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				GtkListBox* _tmp9_;
				GtkDirectionType _tmp10_;
				_tmp9_ = self->priv->subscribed_list_box;
				_tmp10_ = direction;
				gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), _tmp10_);
				result = GDK_EVENT_STOP;
				return result;
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _user_lists_widget_new_list_box_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self) {
	gboolean result;
	result = user_lists_widget_new_list_box_keynav_failed_cb ((UserListsWidget*) self, direction);
	return result;
}


static gboolean user_lists_widget_user_list_box_keynav_failed_cb (UserListsWidget* self, GtkDirectionType direction) {
	gboolean result = FALSE;
	GtkDirectionType _tmp0_;
	g_return_val_if_fail (IS_USER_LISTS_WIDGET (self), FALSE);
	_tmp0_ = direction;
	if (_tmp0_ == GTK_DIR_UP) {
		GtkListBox* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->new_list_box;
		_tmp2_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			GtkListBox* _tmp4_;
			GtkDirectionType _tmp5_;
			_tmp4_ = self->priv->new_list_box;
			_tmp5_ = direction;
			gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp5_);
			result = GDK_EVENT_STOP;
			return result;
		}
	} else {
		GtkDirectionType _tmp6_;
		_tmp6_ = direction;
		if (_tmp6_ == GTK_DIR_DOWN) {
			GtkListBox* _tmp7_;
			gboolean _tmp8_;
			gboolean _tmp9_;
			_tmp7_ = self->priv->subscribed_list_box;
			_tmp8_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, gtk_widget_get_type (), GtkWidget));
			_tmp9_ = _tmp8_;
			if (_tmp9_) {
				GtkListBox* _tmp10_;
				GtkDirectionType _tmp11_;
				_tmp10_ = self->priv->subscribed_list_box;
				_tmp11_ = direction;
				gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget), _tmp11_);
				result = GDK_EVENT_STOP;
				return result;
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _user_lists_widget_user_list_box_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self) {
	gboolean result;
	result = user_lists_widget_user_list_box_keynav_failed_cb ((UserListsWidget*) self, direction);
	return result;
}


static gboolean user_lists_widget_subscribed_list_box_keynav_failed_cb (UserListsWidget* self, GtkDirectionType direction) {
	gboolean result = FALSE;
	GtkDirectionType _tmp0_;
	g_return_val_if_fail (IS_USER_LISTS_WIDGET (self), FALSE);
	_tmp0_ = direction;
	if (_tmp0_ == GTK_DIR_UP) {
		GtkListBox* _tmp1_;
		gboolean _tmp2_;
		gboolean _tmp3_;
		_tmp1_ = self->priv->user_list_box;
		_tmp2_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_widget_get_type (), GtkWidget));
		_tmp3_ = _tmp2_;
		if (_tmp3_) {
			GtkListBox* _tmp4_;
			GtkDirectionType _tmp5_;
			_tmp4_ = self->priv->user_list_box;
			_tmp5_ = direction;
			gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget), _tmp5_);
			result = GDK_EVENT_STOP;
			return result;
		} else {
			GtkListBox* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp6_ = self->priv->new_list_box;
			_tmp7_ = gtk_widget_get_visible (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
			_tmp8_ = _tmp7_;
			if (_tmp8_) {
				GtkListBox* _tmp9_;
				GtkDirectionType _tmp10_;
				_tmp9_ = self->priv->new_list_box;
				_tmp10_ = direction;
				gtk_widget_child_focus (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget), _tmp10_);
				result = GDK_EVENT_STOP;
				return result;
			}
		}
	}
	result = GDK_EVENT_PROPAGATE;
	return result;
}


static gboolean _user_lists_widget_subscribed_list_box_keynav_failed_cb_gtk_widget_keynav_failed (GtkWidget* _sender, GtkDirectionType direction, gpointer self) {
	gboolean result;
	result = user_lists_widget_subscribed_list_box_keynav_failed_cb ((UserListsWidget*) self, direction);
	return result;
}


static void user_lists_widget_revealer_child_revealed_cb (UserListsWidget* self, GObject* source, GParamSpec* spec) {
	GtkRevealer* revealer = NULL;
	GObject* _tmp0_;
	GtkRevealer* _tmp1_;
	GtkRevealer* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	g_return_if_fail (G_IS_OBJECT (source));
	g_return_if_fail (G_IS_PARAM_SPEC (spec));
	_tmp0_ = source;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_revealer_get_type (), GtkRevealer));
	revealer = _tmp1_;
	_tmp2_ = revealer;
	_tmp3_ = gtk_revealer_get_child_revealed (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkRevealer* _tmp5_;
		_tmp5_ = revealer;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_widget_get_type (), GtkWidget));
	} else {
		GtkRevealer* _tmp6_;
		_tmp6_ = revealer;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	}
	_g_object_unref0 (revealer);
}


static void _user_lists_widget_revealer_child_revealed_cb_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	user_lists_widget_revealer_child_revealed_cb ((UserListsWidget*) self, _sender, pspec);
}


UserListsWidget* user_lists_widget_construct (GType object_type) {
	UserListsWidget * self = NULL;
	self = (UserListsWidget*) g_object_new (object_type, NULL);
	return self;
}


UserListsWidget* user_lists_widget_new (void) {
	return user_lists_widget_construct (TYPE_USER_LISTS_WIDGET);
}


MainWindow* user_lists_widget_get_main_window (UserListsWidget* self) {
	MainWindow* result;
	MainWindow* _tmp0_;
	g_return_val_if_fail (IS_USER_LISTS_WIDGET (self), NULL);
	_tmp0_ = self->priv->_main_window;
	result = _tmp0_;
	return result;
}


void user_lists_widget_set_main_window (UserListsWidget* self, MainWindow* value) {
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	if (user_lists_widget_get_main_window (self) != value) {
		MainWindow* _tmp0_;
		_tmp0_ = value;
		self->priv->_main_window = _tmp0_;
		g_object_notify ((GObject *) self, "main-window");
	}
}


Account* user_lists_widget_get_account (UserListsWidget* self) {
	Account* result;
	Account* _tmp0_;
	g_return_val_if_fail (IS_USER_LISTS_WIDGET (self), NULL);
	_tmp0_ = self->priv->_account;
	result = _tmp0_;
	return result;
}


void user_lists_widget_set_account (UserListsWidget* self, Account* value) {
	g_return_if_fail (IS_USER_LISTS_WIDGET (self));
	if (user_lists_widget_get_account (self) != value) {
		Account* _tmp0_;
		_tmp0_ = value;
		self->priv->_account = _tmp0_;
		g_object_notify ((GObject *) self, "account");
	}
}


static void _default_header_func_gtk_list_box_update_header_func (GtkListBoxRow* row, GtkListBoxRow* before, gpointer self) {
	default_header_func (row, before);
}


static gint _list_list_entry_sort_func_gtk_list_box_sort_func (GtkListBoxRow* row1, GtkListBoxRow* row2, gpointer self) {
	gint result;
	result = list_list_entry_sort_func (row1, row2);
	return result;
}


static GObject * user_lists_widget_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UserListsWidget * self;
	GtkListBox* _tmp0_;
	GtkListBox* _tmp1_;
	GtkListBox* _tmp2_;
	GtkListBox* _tmp3_;
	parent_class = G_OBJECT_CLASS (user_lists_widget_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_LISTS_WIDGET, UserListsWidget);
	_tmp0_ = self->priv->user_list_box;
	gtk_list_box_set_header_func (_tmp0_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp1_ = self->priv->user_list_box;
	gtk_list_box_set_sort_func (_tmp1_, _list_list_entry_sort_func_gtk_list_box_sort_func, NULL, NULL);
	_tmp2_ = self->priv->subscribed_list_box;
	gtk_list_box_set_header_func (_tmp2_, _default_header_func_gtk_list_box_update_header_func, NULL, NULL);
	_tmp3_ = self->priv->subscribed_list_box;
	gtk_list_box_set_sort_func (_tmp3_, _list_list_entry_sort_func_gtk_list_box_sort_func, NULL, NULL);
	return obj;
}


static void user_lists_widget_class_init (UserListsWidgetClass * klass) {
	gint UserListsWidget_private_offset;
	user_lists_widget_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UserListsWidgetPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_user_lists_widget_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_user_lists_widget_set_property;
	G_OBJECT_CLASS (klass)->constructor = user_lists_widget_constructor;
	G_OBJECT_CLASS (klass)->finalize = user_lists_widget_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LISTS_WIDGET_MAIN_WINDOW, g_param_spec_object ("main-window", "main-window", "main-window", TYPE_MAIN_WINDOW, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), USER_LISTS_WIDGET_ACCOUNT, g_param_spec_object ("account", "account", "account", TYPE_ACCOUNT, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	UserListsWidget_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/baedert/corebird/ui/user-lists-widget.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list_label", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, user_list_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list_box", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, user_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_list_frame", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, user_list_frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "subscribed_list_label", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, subscribed_list_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "subscribed_list_box", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, subscribed_list_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "subscribed_list_frame", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, subscribed_list_frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_list_entry", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, new_list_entry));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "user_lists_revealer", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, user_lists_revealer));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "upper_separator", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, upper_separator));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_list_box", FALSE, UserListsWidget_private_offset + G_STRUCT_OFFSET (UserListsWidgetPrivate, new_list_box));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "row_activated", G_CALLBACK(_user_lists_widget_row_activated_gtk_list_box_row_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "new_list_create_activated_cb", G_CALLBACK(_user_lists_widget_new_list_create_activated_cb_new_list_entry_create_activated));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "new_list_box_keynav_failed_cb", G_CALLBACK(_user_lists_widget_new_list_box_keynav_failed_cb_gtk_widget_keynav_failed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "user_list_box_keynav_failed_cb", G_CALLBACK(_user_lists_widget_user_list_box_keynav_failed_cb_gtk_widget_keynav_failed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "subscribed_list_box_keynav_failed_cb", G_CALLBACK(_user_lists_widget_subscribed_list_box_keynav_failed_cb_gtk_widget_keynav_failed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "revealer_child_revealed_cb", G_CALLBACK(_user_lists_widget_revealer_child_revealed_cb_g_object_notify));
}


static void user_lists_widget_instance_init (UserListsWidget * self) {
	self->priv = USER_LISTS_WIDGET_GET_PRIVATE (self);
	self->priv->show_create_entry = TRUE;
	g_type_ensure (TYPE_NEW_LIST_ENTRY);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void user_lists_widget_finalize (GObject * obj) {
	UserListsWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_USER_LISTS_WIDGET, UserListsWidget);
	_g_object_unref0 (self->priv->user_list_label);
	_g_object_unref0 (self->priv->user_list_box);
	_g_object_unref0 (self->priv->user_list_frame);
	_g_object_unref0 (self->priv->subscribed_list_label);
	_g_object_unref0 (self->priv->subscribed_list_box);
	_g_object_unref0 (self->priv->subscribed_list_frame);
	_g_object_unref0 (self->priv->new_list_entry);
	_g_object_unref0 (self->priv->user_lists_revealer);
	_g_object_unref0 (self->priv->upper_separator);
	_g_object_unref0 (self->priv->new_list_box);
	G_OBJECT_CLASS (user_lists_widget_parent_class)->finalize (obj);
}


GType user_lists_widget_get_type (void) {
	static volatile gsize user_lists_widget_type_id__volatile = 0;
	if (g_once_init_enter (&user_lists_widget_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UserListsWidgetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) user_lists_widget_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UserListsWidget), 0, (GInstanceInitFunc) user_lists_widget_instance_init, NULL };
		GType user_lists_widget_type_id;
		user_lists_widget_type_id = g_type_register_static (gtk_box_get_type (), "UserListsWidget", &g_define_type_info, 0);
		g_once_init_leave (&user_lists_widget_type_id__volatile, user_lists_widget_type_id);
	}
	return user_lists_widget_type_id__volatile;
}


static void _vala_user_lists_widget_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UserListsWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_LISTS_WIDGET, UserListsWidget);
	switch (property_id) {
		case USER_LISTS_WIDGET_MAIN_WINDOW:
		g_value_set_object (value, user_lists_widget_get_main_window (self));
		break;
		case USER_LISTS_WIDGET_ACCOUNT:
		g_value_set_object (value, user_lists_widget_get_account (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_user_lists_widget_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UserListsWidget * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_USER_LISTS_WIDGET, UserListsWidget);
	switch (property_id) {
		case USER_LISTS_WIDGET_MAIN_WINDOW:
		user_lists_widget_set_main_window (self, g_value_get_object (value));
		break;
		case USER_LISTS_WIDGET_ACCOUNT:
		user_lists_widget_set_account (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



