; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=riscv32 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32
; RUN: llc -mtriple=riscv64 -mattr=+v -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64
; RUN: llc -mtriple=riscv32 -mattr=+v,+zvbb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB,CHECK-ZVBB-RV32
; RUN: llc -mtriple=riscv64 -mattr=+v,+zvbb -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK-ZVBB,CHECK-ZVBB-RV64

; ==============================================================================
; i32 -> i64
; ==============================================================================

define <4 x i64> @vwsll_vv_v4i64_sext(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vwsll_vv_v4i64_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_v4i64_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vv v10, v8, v9
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <4 x i32> %a to <4 x i64>
  %y = sext <4 x i32> %b to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vv_v4i64_zext(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: vwsll_vv_v4i64_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_v4i64_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vv v10, v8, v9
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <4 x i32> %a to <4 x i64>
  %y = zext <4 x i32> %b to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i64_v4i64(<4 x i32> %a, i64 %b) {
; CHECK-LABEL: vwsll_vx_i64_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i64_v4i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <4 x i64> %head, <4 x i64> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i32> %a to <4 x i64>
  %z = shl <4 x i64> %x, %splat
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i32_v4i64_sext(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: vwsll_vx_i32_v4i64_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i32_v4i64_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv.v.x v9, a0
; CHECK-ZVBB-NEXT:    vwsll.vv v10, v8, v9
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <4 x i32> %head, <4 x i32> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i32> %a to <4 x i64>
  %y = sext <4 x i32> %splat to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i32_v4i64_zext(<4 x i32> %a, i32 %b) {
; CHECK-LABEL: vwsll_vx_i32_v4i64_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i32_v4i64_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <4 x i32> %head, <4 x i32> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i32> %a to <4 x i64>
  %y = zext <4 x i32> %splat to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i16_v4i64_sext(<4 x i32> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_v4i64_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf4 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_v4i64_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <4 x i16> %head, <4 x i16> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i32> %a to <4 x i64>
  %y = sext <4 x i16> %splat to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i16_v4i64_zext(<4 x i32> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_v4i64_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf4 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_v4i64_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <4 x i16> %head, <4 x i16> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i32> %a to <4 x i64>
  %y = zext <4 x i16> %splat to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i8_v4i64_sext(<4 x i32> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_v4i64_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf8 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_v4i64_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <4 x i8> %head, <4 x i8> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i32> %a to <4 x i64>
  %y = sext <4 x i8> %splat to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i8_v4i64_zext(<4 x i32> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_v4i64_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf8 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_v4i64_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <4 x i8> %head, <4 x i8> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i32> %a to <4 x i64>
  %y = zext <4 x i8> %splat to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vi_v4i64(<4 x i32> %a) {
; CHECK-LABEL: vwsll_vi_v4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vi v8, v10, 2
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vi_v4i64:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vi v10, v8, 2
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <4 x i32> %a to <4 x i64>
  %z = shl <4 x i64> %x, splat (i64 2)
  ret <4 x i64> %z
}

; ==============================================================================
; i16 -> i32
; ==============================================================================

define <8 x i32> @vwsll_vv_v8i32_sext(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vwsll_vv_v8i32_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_v8i32_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vv v10, v8, v9
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <8 x i16> %a to <8 x i32>
  %y = sext <8 x i16> %b to <8 x i32>
  %z = shl <8 x i32> %x, %y
  ret <8 x i32> %z
}

define <8 x i32> @vwsll_vv_v8i32_zext(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: vwsll_vv_v8i32_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_v8i32_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vv v10, v8, v9
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <8 x i16> %a to <8 x i32>
  %y = zext <8 x i16> %b to <8 x i32>
  %z = shl <8 x i32> %x, %y
  ret <8 x i32> %z
}

define <8 x i32> @vwsll_vx_i64_v8i32(<8 x i16> %a, i64 %b) {
; CHECK-LABEL: vwsll_vx_i64_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i64_v8i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <8 x i64> %head, <8 x i64> poison, <8 x i32> zeroinitializer
  %x = zext <8 x i16> %a to <8 x i32>
  %y = trunc <8 x i64> %splat to <8 x i32>
  %z = shl <8 x i32> %x, %y
  ret <8 x i32> %z
}

define <8 x i32> @vwsll_vx_i32_v8i32(<8 x i16> %a, i32 %b) {
; CHECK-LABEL: vwsll_vx_i32_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i32_v8i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <8 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <8 x i32> %head, <8 x i32> poison, <8 x i32> zeroinitializer
  %x = zext <8 x i16> %a to <8 x i32>
  %z = shl <8 x i32> %x, %splat
  ret <8 x i32> %z
}

define <8 x i32> @vwsll_vx_i16_v8i32_sext(<8 x i16> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_v8i32_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_v8i32_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv.v.x v9, a0
; CHECK-ZVBB-NEXT:    vwsll.vv v10, v8, v9
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <8 x i16> %head, <8 x i16> poison, <8 x i32> zeroinitializer
  %x = zext <8 x i16> %a to <8 x i32>
  %y = sext <8 x i16> %splat to <8 x i32>
  %z = shl <8 x i32> %x, %y
  ret <8 x i32> %z
}

define <8 x i32> @vwsll_vx_i16_v8i32_zext(<8 x i16> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_v8i32_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_v8i32_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <8 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <8 x i16> %head, <8 x i16> poison, <8 x i32> zeroinitializer
  %x = zext <8 x i16> %a to <8 x i32>
  %y = zext <8 x i16> %splat to <8 x i32>
  %z = shl <8 x i32> %x, %y
  ret <8 x i32> %z
}

define <8 x i32> @vwsll_vx_i8_v8i32_sext(<8 x i16> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_v8i32_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf4 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_v8i32_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <8 x i8> %head, <8 x i8> poison, <8 x i32> zeroinitializer
  %x = zext <8 x i16> %a to <8 x i32>
  %y = sext <8 x i8> %splat to <8 x i32>
  %z = shl <8 x i32> %x, %y
  ret <8 x i32> %z
}

define <8 x i32> @vwsll_vx_i8_v8i32_zext(<8 x i16> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_v8i32_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e8, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf4 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_v8i32_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <8 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <8 x i8> %head, <8 x i8> poison, <8 x i32> zeroinitializer
  %x = zext <8 x i16> %a to <8 x i32>
  %y = zext <8 x i8> %splat to <8 x i32>
  %z = shl <8 x i32> %x, %y
  ret <8 x i32> %z
}

define <8 x i32> @vwsll_vi_v8i32(<8 x i16> %a) {
; CHECK-LABEL: vwsll_vi_v8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 8, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vi v8, v10, 2
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vi_v8i32:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 8, e16, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vi v10, v8, 2
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <8 x i16> %a to <8 x i32>
  %z = shl <8 x i32> %x, splat (i32 2)
  ret <8 x i32> %z
}

; ==============================================================================
; i8 -> i16
; ==============================================================================

define <16 x i16> @vwsll_vv_v16i16_sext(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vwsll_vv_v16i16_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_v16i16_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vv v10, v8, v9
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <16 x i8> %a to <16 x i16>
  %y = sext <16 x i8> %b to <16 x i16>
  %z = shl <16 x i16> %x, %y
  ret <16 x i16> %z
}

define <16 x i16> @vwsll_vv_v16i16_zext(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: vwsll_vv_v16i16_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_v16i16_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vv v10, v8, v9
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <16 x i8> %a to <16 x i16>
  %y = zext <16 x i8> %b to <16 x i16>
  %z = shl <16 x i16> %x, %y
  ret <16 x i16> %z
}

define <16 x i16> @vwsll_vx_i64_v16i16(<16 x i8> %a, i64 %b) {
; RV32-LABEL: vwsll_vx_i64_v16i16:
; RV32:       # %bb.0:
; RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; RV32-NEXT:    vmv.v.x v16, a0
; RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV32-NEXT:    vrgather.vi v24, v16, 0
; RV32-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; RV32-NEXT:    vzext.vf2 v10, v8
; RV32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV32-NEXT:    vnsrl.wi v12, v24, 0
; RV32-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; RV32-NEXT:    vnsrl.wi v8, v12, 0
; RV32-NEXT:    vsll.vv v8, v10, v8
; RV32-NEXT:    ret
;
; RV64-LABEL: vwsll_vx_i64_v16i16:
; RV64:       # %bb.0:
; RV64-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; RV64-NEXT:    vmv.v.x v16, a0
; RV64-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; RV64-NEXT:    vzext.vf2 v10, v8
; RV64-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; RV64-NEXT:    vnsrl.wi v12, v16, 0
; RV64-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; RV64-NEXT:    vnsrl.wi v8, v12, 0
; RV64-NEXT:    vsll.vv v8, v10, v8
; RV64-NEXT:    ret
;
; CHECK-ZVBB-RV32-LABEL: vwsll_vx_i64_v16i16:
; CHECK-ZVBB-RV32:       # %bb.0:
; CHECK-ZVBB-RV32-NEXT:    vsetivli zero, 8, e64, m4, ta, ma
; CHECK-ZVBB-RV32-NEXT:    vmv.v.x v16, a0
; CHECK-ZVBB-RV32-NEXT:    vsetivli zero, 16, e64, m8, ta, ma
; CHECK-ZVBB-RV32-NEXT:    vrgather.vi v24, v16, 0
; CHECK-ZVBB-RV32-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-ZVBB-RV32-NEXT:    vzext.vf2 v10, v8
; CHECK-ZVBB-RV32-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-ZVBB-RV32-NEXT:    vnsrl.wi v12, v24, 0
; CHECK-ZVBB-RV32-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-ZVBB-RV32-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-ZVBB-RV32-NEXT:    vsll.vv v8, v10, v8
; CHECK-ZVBB-RV32-NEXT:    ret
;
; CHECK-ZVBB-RV64-LABEL: vwsll_vx_i64_v16i16:
; CHECK-ZVBB-RV64:       # %bb.0:
; CHECK-ZVBB-RV64-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-ZVBB-RV64-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-RV64-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-RV64-NEXT:    ret
  %head = insertelement <8 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <8 x i64> %head, <8 x i64> poison, <16 x i32> zeroinitializer
  %x = zext <16 x i8> %a to <16 x i16>
  %y = trunc <16 x i64> %splat to <16 x i16>
  %z = shl <16 x i16> %x, %y
  ret <16 x i16> %z
}

define <16 x i16> @vwsll_vx_i32_v16i16(<16 x i8> %a, i32 %b) {
; CHECK-LABEL: vwsll_vx_i32_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e32, m4, ta, ma
; CHECK-NEXT:    vmv.v.x v12, a0
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    vsll.vv v8, v10, v8
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i32_v16i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <16 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <16 x i32> %head, <16 x i32> poison, <16 x i32> zeroinitializer
  %x = zext <16 x i8> %a to <16 x i16>
  %y = trunc <16 x i32> %splat to <16 x i16>
  %z = shl <16 x i16> %x, %y
  ret <16 x i16> %z
}

define <16 x i16> @vwsll_vx_i16_v16i16(<16 x i8> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_v16i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <16 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <16 x i16> %head, <16 x i16> poison, <16 x i32> zeroinitializer
  %x = zext <16 x i8> %a to <16 x i16>
  %z = shl <16 x i16> %x, %splat
  ret <16 x i16> %z
}

define <16 x i16> @vwsll_vx_i8_v16i16_sext(<16 x i8> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_v16i16_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_v16i16_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv.v.x v9, a0
; CHECK-ZVBB-NEXT:    vwsll.vv v10, v8, v9
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <16 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <16 x i8> %head, <16 x i8> poison, <16 x i32> zeroinitializer
  %x = zext <16 x i8> %a to <16 x i16>
  %y = sext <16 x i8> %splat to <16 x i16>
  %z = shl <16 x i16> %x, %y
  ret <16 x i16> %z
}

define <16 x i16> @vwsll_vx_i8_v16i16_zext(<16 x i8> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_v16i16_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vzext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_v16i16_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vx v10, v8, a0
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <16 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <16 x i8> %head, <16 x i8> poison, <16 x i32> zeroinitializer
  %x = zext <16 x i8> %a to <16 x i16>
  %y = zext <16 x i8> %splat to <16 x i16>
  %z = shl <16 x i16> %x, %y
  ret <16 x i16> %z
}

define <16 x i16> @vwsll_vi_v16i16(<16 x i8> %a) {
; CHECK-LABEL: vwsll_vi_v16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 16, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v10, v8
; CHECK-NEXT:    vsll.vi v8, v10, 2
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vi_v16i16:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 16, e8, m1, ta, ma
; CHECK-ZVBB-NEXT:    vwsll.vi v10, v8, 2
; CHECK-ZVBB-NEXT:    vmv2r.v v8, v10
; CHECK-ZVBB-NEXT:    ret
  %x = zext <16 x i8> %a to <16 x i16>
  %z = shl <16 x i16> %x, splat (i16 2)
  ret <16 x i16> %z
}

; ==============================================================================
; i8 -> i64
; ==============================================================================

define <4 x i64> @vwsll_vv_v4i64_v4i8_sext(<4 x i8> %a, <4 x i8> %b) {
; CHECK-LABEL: vwsll_vv_v4i64_v4i8_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vsext.vf8 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_v4i64_v4i8_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf8 v10, v8
; CHECK-ZVBB-NEXT:    vsext.vf8 v12, v9
; CHECK-ZVBB-NEXT:    vsll.vv v8, v10, v12
; CHECK-ZVBB-NEXT:    ret
  %x = zext <4 x i8> %a to <4 x i64>
  %y = sext <4 x i8> %b to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vv_v4i64_v4i8_zext(<4 x i8> %a, <4 x i8> %b) {
; CHECK-LABEL: vwsll_vv_v4i64_v4i8_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vzext.vf8 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vv_v4i64_v4i8_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf4 v10, v8
; CHECK-ZVBB-NEXT:    vzext.vf4 v11, v9
; CHECK-ZVBB-NEXT:    vwsll.vv v8, v10, v11
; CHECK-ZVBB-NEXT:    ret
  %x = zext <4 x i8> %a to <4 x i64>
  %y = zext <4 x i8> %b to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i64_v4i64_v4i8(<4 x i8> %a, i64 %b) {
; CHECK-LABEL: vwsll_vx_i64_v4i64_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vsll.vx v8, v10, a0
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i64_v4i64_v4i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf8 v10, v8
; CHECK-ZVBB-NEXT:    vsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i64> poison, i64 %b, i32 0
  %splat = shufflevector <4 x i64> %head, <4 x i64> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i8> %a to <4 x i64>
  %z = shl <4 x i64> %x, %splat
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i32_v4i64_v4i8_sext(<4 x i8> %a, i32 %b) {
; CHECK-LABEL: vwsll_vx_i32_v4i64_v4i8_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vsext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i32_v4i64_v4i8_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vmv.v.x v9, a0
; CHECK-ZVBB-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf8 v10, v8
; CHECK-ZVBB-NEXT:    vsext.vf2 v12, v9
; CHECK-ZVBB-NEXT:    vsll.vv v8, v10, v12
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <4 x i32> %head, <4 x i32> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i8> %a to <4 x i64>
  %y = sext <4 x i32> %splat to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i32_v4i64_v4i8_zext(<4 x i8> %a, i32 %b) {
; CHECK-LABEL: vwsll_vx_i32_v4i64_v4i8_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vzext.vf2 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i32_v4i64_v4i8_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf4 v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i32> poison, i32 %b, i32 0
  %splat = shufflevector <4 x i32> %head, <4 x i32> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i8> %a to <4 x i64>
  %y = zext <4 x i32> %splat to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i16_v4i64_v4i8_sext(<4 x i8> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_v4i64_v4i8_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vsext.vf4 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_v4i64_v4i8_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-ZVBB-NEXT:    vmv.v.x v9, a0
; CHECK-ZVBB-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf8 v10, v8
; CHECK-ZVBB-NEXT:    vsext.vf4 v12, v9
; CHECK-ZVBB-NEXT:    vsll.vv v8, v10, v12
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <4 x i16> %head, <4 x i16> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i8> %a to <4 x i64>
  %y = sext <4 x i16> %splat to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i16_v4i64_v4i8_zext(<4 x i8> %a, i16 %b) {
; CHECK-LABEL: vwsll_vx_i16_v4i64_v4i8_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vzext.vf4 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i16_v4i64_v4i8_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf4 v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i16> poison, i16 %b, i32 0
  %splat = shufflevector <4 x i16> %head, <4 x i16> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i8> %a to <4 x i64>
  %y = zext <4 x i16> %splat to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i8_v4i64_v4i8_sext(<4 x i8> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_v4i64_v4i8_sext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vsext.vf8 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_v4i64_v4i8_sext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-ZVBB-NEXT:    vmv.v.x v9, a0
; CHECK-ZVBB-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf8 v10, v8
; CHECK-ZVBB-NEXT:    vsext.vf8 v12, v9
; CHECK-ZVBB-NEXT:    vsll.vv v8, v10, v12
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <4 x i8> %head, <4 x i8> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i8> %a to <4 x i64>
  %y = sext <4 x i8> %splat to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vx_i8_v4i64_v4i8_zext(<4 x i8> %a, i8 %b) {
; CHECK-LABEL: vwsll_vx_i8_v4i64_v4i8_zext:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e8, mf4, ta, ma
; CHECK-NEXT:    vmv.v.x v9, a0
; CHECK-NEXT:    vsetvli zero, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vzext.vf8 v12, v9
; CHECK-NEXT:    vsll.vv v8, v10, v12
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vx_i8_v4i64_v4i8_zext:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf4 v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vx v8, v10, a0
; CHECK-ZVBB-NEXT:    ret
  %head = insertelement <4 x i8> poison, i8 %b, i32 0
  %splat = shufflevector <4 x i8> %head, <4 x i8> poison, <4 x i32> zeroinitializer
  %x = zext <4 x i8> %a to <4 x i64>
  %y = zext <4 x i8> %splat to <4 x i64>
  %z = shl <4 x i64> %x, %y
  ret <4 x i64> %z
}

define <4 x i64> @vwsll_vi_v4i64_v4i8(<4 x i8> %a) {
; CHECK-LABEL: vwsll_vi_v4i64_v4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 4, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf8 v10, v8
; CHECK-NEXT:    vsll.vi v8, v10, 2
; CHECK-NEXT:    ret
;
; CHECK-ZVBB-LABEL: vwsll_vi_v4i64_v4i8:
; CHECK-ZVBB:       # %bb.0:
; CHECK-ZVBB-NEXT:    vsetivli zero, 4, e32, m1, ta, ma
; CHECK-ZVBB-NEXT:    vzext.vf4 v10, v8
; CHECK-ZVBB-NEXT:    vwsll.vi v8, v10, 2
; CHECK-ZVBB-NEXT:    ret
  %x = zext <4 x i8> %a to <4 x i64>
  %z = shl <4 x i64> %x, splat (i64 2)
  ret <4 x i64> %z
}
