; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py

; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv2_sf | FileCheck %s --check-prefix=CHECK-SF
; RUN: llc -verify-machineinstrs -csky-no-aliases < %s -mtriple=csky -float-abi=hard -mattr=+hard-float -mattr=+2e3 -mattr=+fpuv3_sf | FileCheck %s --check-prefix=CHECK-SF2


; float --> i32
define i32 @fptosiR_float_1(float %x) {
;
; CHECK-SF-LABEL: fptosiR_float_1:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fstosi.rz vr0, vr0
; CHECK-SF-NEXT:    fmfvrl a0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fptosiR_float_1:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fftoi.f32.s32.rz vr0, vr0
; CHECK-SF2-NEXT:    fmfvr.32.1 a0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %fptosi = fptosi float %x to i32
  ret i32 %fptosi
}


; float --> i16
define i16 @fptosiR_float_2(float %x) {
;
; CHECK-SF-LABEL: fptosiR_float_2:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fstosi.rz vr0, vr0
; CHECK-SF-NEXT:    fmfvrl a0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fptosiR_float_2:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fftoi.f32.s32.rz vr0, vr0
; CHECK-SF2-NEXT:    fmfvr.32.1 a0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %fptosi = fptosi float %x to i16
  ret i16 %fptosi
}


; float --> i8
define i8 @fptosiR_float_3(float %x) {
;
; CHECK-SF-LABEL: fptosiR_float_3:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fstosi.rz vr0, vr0
; CHECK-SF-NEXT:    fmfvrl a0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fptosiR_float_3:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fftoi.f32.s32.rz vr0, vr0
; CHECK-SF2-NEXT:    fmfvr.32.1 a0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %fptosi = fptosi float %x to i8
  ret i8 %fptosi
}


; float --> i1
define i1 @fptosiR_float_4(float %x) {
;
; CHECK-SF-LABEL: fptosiR_float_4:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fstosi.rz vr0, vr0
; CHECK-SF-NEXT:    fmfvrl a0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fptosiR_float_4:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fftoi.f32.s32.rz vr0, vr0
; CHECK-SF2-NEXT:    fmfvr.32.1 a0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %fptosi = fptosi float %x to i1
  ret i1 %fptosi
}




; float --> i32
define i32 @fptouiR_float_1(float %x) {
;
; CHECK-SF-LABEL: fptouiR_float_1:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fstoui.rz vr0, vr0
; CHECK-SF-NEXT:    fmfvrl a0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fptouiR_float_1:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fftoi.f32.u32.rz vr0, vr0
; CHECK-SF2-NEXT:    fmfvr.32.1 a0, vr0
; CHECK-SF2-NEXT:    rts16


entry:
  %fptoui = fptoui float %x to i32
  ret i32 %fptoui
}



; float --> i16
define i16 @fptouiR_float_2(float %x) {
;
; CHECK-SF-LABEL: fptouiR_float_2:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fstoui.rz vr0, vr0
; CHECK-SF-NEXT:    fmfvrl a0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fptouiR_float_2:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fftoi.f32.u32.rz vr0, vr0
; CHECK-SF2-NEXT:    fmfvr.32.1 a0, vr0
; CHECK-SF2-NEXT:    rts16


entry:
  %fptoui = fptoui float %x to i16
  ret i16 %fptoui
}



; float --> i8
define i8 @fptouiR_float_3(float %x) {
;
; CHECK-SF-LABEL: fptouiR_float_3:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fstoui.rz vr0, vr0
; CHECK-SF-NEXT:    fmfvrl a0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fptouiR_float_3:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fftoi.f32.u32.rz vr0, vr0
; CHECK-SF2-NEXT:    fmfvr.32.1 a0, vr0
; CHECK-SF2-NEXT:    rts16


entry:
  %fptoui = fptoui float %x to i8
  ret i8 %fptoui
}


; float --> i1
define i1 @fptouiR_float_4(float %x) {
;
; CHECK-SF-LABEL: fptouiR_float_4:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fstoui.rz vr0, vr0
; CHECK-SF-NEXT:    fmfvrl a0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: fptouiR_float_4:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fftoi.f32.u32.rz vr0, vr0
; CHECK-SF2-NEXT:    fmfvr.32.1 a0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %fptoui = fptoui float %x to i1
  ret i1 %fptoui
}

; i32/i16/i8/i1 --> float

define float @sitofpR_float_0(i32 %x) {
;
; CHECK-SF-LABEL: sitofpR_float_0:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fmtvrl vr0, a0
; CHECK-SF-NEXT:    fsitos vr0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: sitofpR_float_0:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fmtvr.32.1 vr0, a0
; CHECK-SF2-NEXT:    fitof.s32.f32 vr0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %sitofp = sitofp i32 %x to float
  ret float %sitofp
}

define float @sitofpR_float_1(i16 %x) {
;
; CHECK-SF-LABEL: sitofpR_float_1:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    sexth16 a0, a0
; CHECK-SF-NEXT:    fmtvrl vr0, a0
; CHECK-SF-NEXT:    fsitos vr0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: sitofpR_float_1:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    sexth16 a0, a0
; CHECK-SF2-NEXT:    fmtvr.32.1 vr0, a0
; CHECK-SF2-NEXT:    fitof.s32.f32 vr0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %sitofp = sitofp i16 %x to float
  ret float %sitofp
}

define float @sitofpR_float_2(i8 %x) {
;
; CHECK-SF-LABEL: sitofpR_float_2:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    sextb16 a0, a0
; CHECK-SF-NEXT:    fmtvrl vr0, a0
; CHECK-SF-NEXT:    fsitos vr0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: sitofpR_float_2:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    sextb16 a0, a0
; CHECK-SF2-NEXT:    fmtvr.32.1 vr0, a0
; CHECK-SF2-NEXT:    fitof.s32.f32 vr0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %sitofp = sitofp i8 %x to float
  ret float %sitofp
}

define float @sitofpR_float_3(i1 %x) {
;
; CHECK-SF-LABEL: sitofpR_float_3:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    sext32 a0, a0, 0, 0
; CHECK-SF-NEXT:    fmtvrl vr0, a0
; CHECK-SF-NEXT:    fsitos vr0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: sitofpR_float_3:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    sext32 a0, a0, 0, 0
; CHECK-SF2-NEXT:    fmtvr.32.1 vr0, a0
; CHECK-SF2-NEXT:    fitof.s32.f32 vr0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %sitofp = sitofp i1 %x to float
  ret float %sitofp
}

; i32/i16/i8/i1 --> float

define float @uitofpR_float_0(i32 %x) {
;
; CHECK-SF-LABEL: uitofpR_float_0:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    fmtvrl vr0, a0
; CHECK-SF-NEXT:    fuitos vr0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: uitofpR_float_0:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    fmtvr.32.1 vr0, a0
; CHECK-SF2-NEXT:    fitof.u32.f32 vr0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %uitofp = uitofp i32 %x to float
  ret float %uitofp
}

define float @uitofpR_float_1(i16 %x) {
;
; CHECK-SF-LABEL: uitofpR_float_1:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    zexth16 a0, a0
; CHECK-SF-NEXT:    fmtvrl vr0, a0
; CHECK-SF-NEXT:    fuitos vr0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: uitofpR_float_1:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    zexth16 a0, a0
; CHECK-SF2-NEXT:    fmtvr.32.1 vr0, a0
; CHECK-SF2-NEXT:    fitof.u32.f32 vr0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %uitofp = uitofp i16 %x to float
  ret float %uitofp
}

define float @uitofpR_float_2(i8 %x) {
;
; CHECK-SF-LABEL: uitofpR_float_2:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    zextb16 a0, a0
; CHECK-SF-NEXT:    fmtvrl vr0, a0
; CHECK-SF-NEXT:    fuitos vr0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: uitofpR_float_2:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    zextb16 a0, a0
; CHECK-SF2-NEXT:    fmtvr.32.1 vr0, a0
; CHECK-SF2-NEXT:    fitof.u32.f32 vr0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %uitofp = uitofp i8 %x to float
  ret float %uitofp
}

define float @uitofpR_float_3(i1 %x) {
;
; CHECK-SF-LABEL: uitofpR_float_3:
; CHECK-SF:       # %bb.0: # %entry
; CHECK-SF-NEXT:    andi32 a0, a0, 1
; CHECK-SF-NEXT:    fmtvrl vr0, a0
; CHECK-SF-NEXT:    fuitos vr0, vr0
; CHECK-SF-NEXT:    rts16
;
; CHECK-SF2-LABEL: uitofpR_float_3:
; CHECK-SF2:       # %bb.0: # %entry
; CHECK-SF2-NEXT:    andi32 a0, a0, 1
; CHECK-SF2-NEXT:    fmtvr.32.1 vr0, a0
; CHECK-SF2-NEXT:    fitof.u32.f32 vr0, vr0
; CHECK-SF2-NEXT:    rts16
entry:
  %uitofp = uitofp i1 %x to float
  ret float %uitofp
}
