/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.44 from the
 * contents of Socket.xs. Do not edit this file, edit Socket.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

/////////////////////////////////////////////////////////////////////////////
// Name:        ext/socket/Socket.xs
// Purpose:     XS for Wx::Socket
// Author:      Graciliano M. P.
// Modified by:
// Created:     27/02/2003
// RCS-ID:      $Id: Socket.xs 2757 2010-01-17 10:26:27Z mbarbon $
// Copyright:   (c) 2003-2004, 2006, 2008-2010 Graciliano M. P.
// Licence:     This program is free software; you can redistribute it and/or
//              modify it under the same terms as Perl itself
/////////////////////////////////////////////////////////////////////////////

#define PERL_NO_GET_CONTEXT

#include "cpp/wxapi.h"
#include "wx/socket.h"

#undef THIS

#include "cpp/sk_constants.cpp"
#include "cpp/socket.h"

#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif


/* INCLUDE:  Including 'XS/SocketBase.xs' from 'Socket.xs' */


/* INCLUDE:  Including 'XS/SocketClient.xs' from 'XS/SocketBase.xs' */


/* INCLUDE:  Including 'XS/SocketServer.xs' from 'XS/SocketClient.xs' */


/* INCLUDE:  Including 'XS/SocketEvent.xs' from 'XS/SocketServer.xs' */


XS_EUPXS(XS_Wx__SocketEvent_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketEvent_new)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "CLASS, id = 0");
    {
	int	id;
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxSocketEvent *	RETVAL;

	if (items < 2)
	    id = 0;
	else {
	    id = (int)SvIV(ST(1))
;
	}
    RETVAL = new wxSocketEvent( id ) ;
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    wxPli_object_2_sv( aTHX_ RETVALSV, RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketEvent_GetSocket); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketEvent_GetSocket)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketEvent *    THIS = (wxSocketEvent *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketEvent" )
;
	wxSocketBase *	RETVAL;

	RETVAL = THIS->GetSocket();
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    wxPli_object_2_sv( aTHX_ RETVALSV, RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketEvent_GetSocketEvent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketEvent_GetSocketEvent)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketEvent *    THIS = (wxSocketEvent *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketEvent" )
;
	long	RETVAL;
	dXSTARG;

	RETVAL = THIS->GetSocketEvent();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'XS/SocketServer.xs' from 'XS/SocketEvent.xs' */


XS_EUPXS(XS_Wx__SocketServer_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketServer_new)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "CLASS, host, port, style = 0");
    {
	wxString	host;
	wxString	port;
	long	style;
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxSocketServer *	RETVAL;

    WXSTRING_INPUT( host, wxString, ST(1) )
;

    WXSTRING_INPUT( port, wxString, ST(2) )
;

	if (items < 4)
	    style = 0;
	else {
	    style = (long)SvIV(ST(3))
;
	}
    wxIPV4address addr ;
    addr.Hostname(host) ;
    addr.Service(port) ;
    RETVAL = new wxPlSocketServer( CLASS , addr , style ) ;
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    wxPli_object_2_sv( aTHX_ RETVALSV, RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketServer_Accept); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketServer_Accept)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "THIS, wait = true");
    {
	bool	wait;
	wxSocketServer *    THIS = (wxSocketServer *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketServer" )
;
	wxSocketBase *	RETVAL;

	if (items < 2)
	    wait = true;
	else {
	    wait = (bool)SvTRUE(ST(1))
;
	}
    // works, more or less; not a good example of C++
    RETVAL = ((wxPlSocketServer*)THIS)->Accept(wait);
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    wxPli_object_2_sv( aTHX_ RETVALSV, RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketServer_AcceptWith); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketServer_AcceptWith)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, socket, wait = true");
    {
	wxSocketBase*    socket = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(1), "Wx::SocketBase" )
;
	bool	wait;
	wxSocketServer *    THIS = (wxSocketServer *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketServer" )
;
	bool	RETVAL;

	if (items < 3)
	    wait = true;
	else {
	    wait = (bool)SvTRUE(ST(2))
;
	}
    RETVAL = THIS->AcceptWith( *socket , wait );
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketServer_WaitForAccept); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketServer_WaitForAccept)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "THIS, seconds = -1, millisecond = 0");
    {
	long	seconds;
	long	millisecond;
	wxSocketServer *    THIS = (wxSocketServer *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketServer" )
;
	bool	RETVAL;

	if (items < 2)
	    seconds = -1;
	else {
	    seconds = (long)SvIV(ST(1))
;
	}

	if (items < 3)
	    millisecond = 0;
	else {
	    millisecond = (long)SvIV(ST(2))
;
	}

	RETVAL = THIS->WaitForAccept(seconds, millisecond);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'XS/SocketClient.xs' from 'XS/SocketServer.xs' */


XS_EUPXS(XS_Wx__SocketClient_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketClient_new)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "CLASS, style = 0");
    {
	long	style;
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxSocketClient *	RETVAL;

	if (items < 2)
	    style = 0;
	else {
	    style = (long)SvIV(ST(1))
;
	}
    RETVAL = new wxPliSocketClient( CLASS , style ) ;
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    wxPli_object_2_sv( aTHX_ RETVALSV, RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketClient_Connect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketClient_Connect)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, host, port, wait = 1");
    {
	wxString	host;
	wxString	port;
	bool	wait;
	wxSocketClient *    THIS = (wxSocketClient *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketClient" )
;
	bool	RETVAL;

    WXSTRING_INPUT( host, wxString, ST(1) )
;

    WXSTRING_INPUT( port, wxString, ST(2) )
;

	if (items < 4)
	    wait = 1;
	else {
	    wait = (bool)SvTRUE(ST(3))
;
	}
    wxIPV4address addr ;
    addr.Hostname(host) ;
    addr.Service(port) ;
    RETVAL = THIS->Connect( addr , wait ) ;
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'XS/SocketBase.xs' from 'XS/SocketClient.xs' */

#if 0
#define XSubPPtmpAAAA 1


XS_EUPXS(XS_Wx__SocketBase_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxSocketBase *	RETVAL;
    RETVAL = new wxPlSocketBase( CLASS ) ;
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    wxPli_object_2_sv( aTHX_ RETVALSV, RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#endif

XS_EUPXS(XS_Wx__SocketBase_Destroy); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Destroy)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->Destroy();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_Ok); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Ok)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	RETVAL = THIS->Ok();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_IsConnected); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_IsConnected)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	RETVAL = THIS->IsConnected();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_IsDisconnected); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_IsDisconnected)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	RETVAL = THIS->IsDisconnected();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_IsData); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_IsData)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	RETVAL = THIS->IsData();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_LastCount); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_LastCount)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	RETVAL = THIS->LastCount();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_Notify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Notify)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, notify");
    {
	bool	notify = (bool)SvTRUE(ST(1))
;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->Notify(notify);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_SetTimeout); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_SetTimeout)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, seconds");
    {
	int	seconds = (int)SvIV(ST(1))
;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->SetTimeout(seconds);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_Wait); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Wait)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "THIS, seconds = -1, millisecond = 0");
    {
	long	seconds;
	long	millisecond;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	if (items < 2)
	    seconds = -1;
	else {
	    seconds = (long)SvIV(ST(1))
;
	}

	if (items < 3)
	    millisecond = 0;
	else {
	    millisecond = (long)SvIV(ST(2))
;
	}

	RETVAL = THIS->Wait(seconds, millisecond);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_WaitForRead); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_WaitForRead)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "THIS, seconds = -1, millisecond = 0");
    {
	long	seconds;
	long	millisecond;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	if (items < 2)
	    seconds = -1;
	else {
	    seconds = (long)SvIV(ST(1))
;
	}

	if (items < 3)
	    millisecond = 0;
	else {
	    millisecond = (long)SvIV(ST(2))
;
	}

	RETVAL = THIS->WaitForRead(seconds, millisecond);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_WaitForWrite); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_WaitForWrite)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "THIS, seconds = -1, millisecond = 0");
    {
	long	seconds;
	long	millisecond;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	if (items < 2)
	    seconds = -1;
	else {
	    seconds = (long)SvIV(ST(1))
;
	}

	if (items < 3)
	    millisecond = 0;
	else {
	    millisecond = (long)SvIV(ST(2))
;
	}

	RETVAL = THIS->WaitForWrite(seconds, millisecond);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_Read); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Read)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, buf, size, leng = 0");
    {
	SV*	buf = ST(1)
;
	size_t    size = (size_t)SvUV( ST(2) )
;
	size_t	leng;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	if (items < 4)
	    leng = 0;
	else {
    leng = (size_t)SvUV( ST(3) )
;
	}
    // Upgrade the SV to scalar if needed. If the scalar is undef
    // can't use SvGROW.
    SvUPGRADE(buf , SVt_PV) ;
    // Tell that the scalar is string only (not integer, double, utf8...):
    SvPOK_only(buf) ;

    // Grow the scalar to receive the data and return a char* point:
    char* buffer = SvGROW( buf , leng + size + 2 ) ;

    // To read at the offset the user specified (works even if offset = 0):
    if ( leng > 0 ) buffer += leng ;

    THIS->Read( buffer , size ) ;
    int nread = THIS->LastCount() ;

    // Null-terminate the buffer, not necessary, but does not hurt:
    buffer[nread] = 0 ;
    // Tell Perl how long the string is:
    SvCUR_set( buf , leng + nread ) ;
    // Undef on read error:
    if( THIS->Error() ) XSRETURN_UNDEF ;
    // Return the amount of data read, like Perl read().
    RETVAL = nread ;
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_Close); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Close)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->Close();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_Discard); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Discard)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->Discard();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_Error); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Error)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	RETVAL = THIS->Error();
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_GetFlags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_GetFlags)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	RETVAL = THIS->GetFlags();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_GetLocal); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_GetLocal)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
    wxIPV4address addr ;
    THIS->GetLocal( addr ) ;
    XPUSHs( sv_2mortal( newSVpv( addr.Hostname().mb_str(), 0 ) ) );
    XPUSHs( sv_2mortal( newSViv( addr.Service() ) ) );
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Wx__SocketBase_GetPeer); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_GetPeer)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
    wxIPV4address addr ;
    THIS->GetPeer( addr ) ;
    XPUSHs( sv_2mortal( newSVpv( addr.Hostname().mb_str(), 0 ) ) );
    XPUSHs( sv_2mortal( newSViv( addr.Service() ) ) );
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Wx__SocketBase_InterruptWait); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_InterruptWait)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->InterruptWait();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_LastError); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_LastError)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	RETVAL = THIS->LastError();
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_Peek); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Peek)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, buf, size, leng = 0");
    {
	SV*	buf = ST(1)
;
	size_t    size = (size_t)SvUV( ST(2) )
;
	size_t	leng;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	if (items < 4)
	    leng = 0;
	else {
    leng = (size_t)SvUV( ST(3) )
;
	}
    SvUPGRADE(buf , SVt_PV) ;
    SvPOK_only(buf) ;
    char* buffer = SvGROW( buf , leng + size + 2 ) ;
    if ( leng > 0 ) { buffer += leng ;}

    THIS->Peek( buffer , size ) ;
    int nread = THIS->LastCount() ;

    buffer[nread] = 0 ;
    SvCUR_set( buf , leng + nread ) ;
    if( THIS->Error() ) XSRETURN_UNDEF ;
    RETVAL = nread ;
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_ReadMsg); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_ReadMsg)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "THIS, buf, size, leng = 0");
    {
	SV*	buf = ST(1)
;
	size_t    size = (size_t)SvUV( ST(2) )
;
	size_t	leng;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	if (items < 4)
	    leng = 0;
	else {
    leng = (size_t)SvUV( ST(3) )
;
	}
    SvUPGRADE(buf , SVt_PV) ;
    SvPOK_only(buf) ;
    char* buffer = SvGROW( buf , leng + size + 2 ) ;
    if ( leng > 0 ) { buffer += leng ;}

    THIS->ReadMsg( buffer , size ) ;
    int nread = THIS->LastCount() ;

    buffer[nread] = 0 ;
    SvCUR_set( buf , leng + nread ) ;
    if( THIS->Error() ) XSRETURN_UNDEF ;
    RETVAL = nread ;
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_RestoreState); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_RestoreState)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->RestoreState();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_SaveState); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_SaveState)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->SaveState();
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_SetFlags); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_SetFlags)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, flags");
    {
	long	flags = (long)SvIV(ST(1))
;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->SetFlags(flags);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_SetNotify); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_SetNotify)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, flags");
    {
	long	flags = (long)SvIV(ST(1))
;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	THIS->SetNotify(flags);
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SocketBase_Unread); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Unread)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, buf, size = 0");
    {
	SV*	buf = ST(1)
;
	long	size;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	if (items < 3)
	    size = 0;
	else {
	    size = (long)SvIV(ST(2))
;
	}
    // Upgrade the SV to scalar if needed. If the scalar is undef 
    // can't use SvGROW.
    SvUPGRADE(buf , SVt_PV) ;

    if ( size == 0 ) { size = SvCUR(buf) ;}
    THIS->Unread( SvPV_nolen(buf) , size ) ;
    RETVAL = THIS->LastCount() ;
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_WaitForLost); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_WaitForLost)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 3)
       croak_xs_usage(cv,  "THIS, seconds = -1, millisecond = 0");
    {
	long	seconds;
	long	millisecond;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	bool	RETVAL;

	if (items < 2)
	    seconds = -1;
	else {
	    seconds = (long)SvIV(ST(1))
;
	}

	if (items < 3)
	    millisecond = 0;
	else {
	    millisecond = (long)SvIV(ST(2))
;
	}

	RETVAL = THIS->WaitForLost(seconds, millisecond);
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_Write); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_Write)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, buf, size = 0");
    {
	SV*	buf = ST(1)
;
	long	size;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	if (items < 3)
	    size = 0;
	else {
	    size = (long)SvIV(ST(2))
;
	}
    if ( size == 0 ) { size = SvCUR(buf) ;}
    THIS->Write( SvPV_nolen(buf) , size ) ;
    RETVAL = THIS->LastCount() ;
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_WriteMsg); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_WriteMsg)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, buf, size = 0");
    {
	SV*	buf = ST(1)
;
	long	size;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;
	long	RETVAL;
	dXSTARG;

	if (items < 3)
	    size = 0;
	else {
	    size = (long)SvIV(ST(2))
;
	}
    if ( size == 0 ) { size = SvCUR(buf) ;}
    THIS->WriteMsg( SvPV_nolen(buf) , size ) ;
    RETVAL = THIS->LastCount() ;
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__SocketBase_SetEventHandler); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SocketBase_SetEventHandler)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "THIS, evthnd, id = wxID_ANY");
    {
	wxEvtHandler*    evthnd = (wxEvtHandler *) wxPli_sv_2_object( aTHX_ ST(1), "Wx::EvtHandler" )
;
	int	id;
	wxSocketBase *    THIS = (wxSocketBase *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SocketBase" )
;

	if (items < 3)
	    id = wxID_ANY;
	else {
	    id = (int)SvIV(ST(2))
;
	}
    THIS->SetEventHandler( *evthnd , id );
    }
    XSRETURN_EMPTY;
}


/* INCLUDE: Returning to 'Socket.xs' from 'XS/SocketBase.xs' */


/* INCLUDE_COMMAND:  Including output of '/usr/bin/perl -MExtUtils::XSpp::Cmd -e xspp -- -t ../../typemap.xsp XS/SockAddress.xsp' from 'Socket.xs' */

#include <exception>

#undef  xsp_constructor_class
#define xsp_constructor_class(c) (c)

XS_EUPXS(XS_Wx__SockAddress_CLONE); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SockAddress_CLONE)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
    wxPli_thread_sv_clone( aTHX_ CLASS, (wxPliCloneSV)wxPli_detach_object );
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SockAddress_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SockAddress_DESTROY)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSockAddress *    THIS = (wxSockAddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SockAddress" )
;
     wxPli_thread_sv_unregister( aTHX_ wxPli_get_class( aTHX_ ST(0) ), THIS, ST(0) );
                delete THIS;
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SockAddress_Clear); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SockAddress_Clear)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSockAddress *    THIS = (wxSockAddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SockAddress" )
;
    try {
      THIS->Clear();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Wx__SockAddress_Type); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__SockAddress_Type)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxSockAddress *    THIS = (wxSockAddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::SockAddress" )
;
	int	RETVAL;
	dXSTARG;
    try {
      RETVAL = THIS->Type();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#if WXPERL_W_VERSION_GE( 2, 5, 1 )
#define XSpp_2c048bf0_051395
#define XSubPPtmpAAAB 1


XS_EUPXS(XS_Wx__IPaddress_SetHostname); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_SetHostname)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, name");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	bool	RETVAL;
	wxString	name;

    WXSTRING_INPUT( name, wxString, ST(1) )
;
    try {
      RETVAL = THIS->Hostname( name );
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__IPaddress_SetService); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_SetService)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, port");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	bool	RETVAL;
	wxString	port;

    WXSTRING_INPUT( port, wxString, ST(1) )
;
    try {
      RETVAL = THIS->Service( port );
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__IPaddress_IsLocalHost); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_IsLocalHost)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	bool	RETVAL;
    try {
      RETVAL = THIS->IsLocalHost();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__IPaddress_SetAnyAddress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_SetAnyAddress)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	bool	RETVAL;
    try {
      RETVAL = THIS->AnyAddress();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__IPaddress_GetIPAddress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_GetIPAddress)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	wxString	RETVAL;
    try {
      RETVAL = THIS->IPAddress();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    WXSTRING_OUTPUT( RETVAL, RETVALSV );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__IPaddress_GetHostname); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_GetHostname)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	wxString	RETVAL;
    try {
      RETVAL = THIS->Hostname();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    WXSTRING_OUTPUT( RETVAL, RETVALSV );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__IPaddress_GetService); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPaddress_GetService)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPaddress *    THIS = (wxIPaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPaddress" )
;
	unsigned short	RETVAL;
	dXSTARG;
    try {
      RETVAL = THIS->Service();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	XSprePUSH;
	PUSHu((UV)RETVAL );
    }
    XSRETURN(1);
}

#endif
#undef  xsp_constructor_class
#define xsp_constructor_class(c) (CLASS)

XS_EUPXS(XS_Wx__IPV4address_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPV4address_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxIPV4address *	RETVAL;
    try {
      RETVAL = new wxIPV4address();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    wxPli_object_2_sv( aTHX_ RETVALSV, RETVAL );
    wxPli_thread_sv_register( aTHX_ "Wx::IPV4address", RETVAL, RETVALSV );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#undef  xsp_constructor_class
#define xsp_constructor_class(c) (c)

XS_EUPXS(XS_Wx__IPV4address_GetOrigHostname); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPV4address_GetOrigHostname)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPV4address *    THIS = (wxIPV4address *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPV4address" )
;
	wxString	RETVAL;
    try {
      RETVAL = THIS->OrigHostname();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    WXSTRING_OUTPUT( RETVAL, RETVALSV );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#if WXPERL_W_VERSION_GE( 2, 9, 0 )
#define XSpp_2c048bf0_045262
#define XSubPPtmpAAAC 1


XS_EUPXS(XS_Wx__IPV4address_SetBroadcastAddress); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPV4address_SetBroadcastAddress)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxIPV4address *    THIS = (wxIPV4address *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::IPV4address" )
;
	bool	RETVAL;
    try {
      RETVAL = THIS->BroadcastAddress();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	ST(0) = boolSV(RETVAL);
    }
    XSRETURN(1);
}

#endif
#if wxUSE_IPV6
#define XSpp_2c048bf0_038547
#undef  xsp_constructor_class
#define xsp_constructor_class(c) (CLASS)
#define XSubPPtmpAAAD 1


XS_EUPXS(XS_Wx__IPV6address_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__IPV6address_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxIPV6address *	RETVAL;
    try {
      RETVAL = new wxIPV6address();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    wxPli_object_2_sv( aTHX_ RETVALSV, RETVAL );
    wxPli_thread_sv_register( aTHX_ "Wx::IPV6address", RETVAL, RETVALSV );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#undef  xsp_constructor_class
#define xsp_constructor_class(c) (c)
#endif
#ifdef __UNIX__
#define XSpp_2c048bf0_079626
#undef  xsp_constructor_class
#define xsp_constructor_class(c) (CLASS)
#define XSubPPtmpAAAE 1


XS_EUPXS(XS_Wx__UNIXaddress_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__UNIXaddress_new)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "CLASS");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxUNIXaddress *	RETVAL;
    try {
      RETVAL = new wxUNIXaddress();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    wxPli_object_2_sv( aTHX_ RETVALSV, RETVAL );
    wxPli_thread_sv_register( aTHX_ "Wx::UNIXaddress", RETVAL, RETVALSV );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#undef  xsp_constructor_class
#define xsp_constructor_class(c) (c)

XS_EUPXS(XS_Wx__UNIXaddress_GetFilename); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__UNIXaddress_GetFilename)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "THIS");
    {
	wxUNIXaddress *    THIS = (wxUNIXaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::UNIXaddress" )
;
	wxString	RETVAL;
    try {
      RETVAL = THIS->Filename();
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    WXSTRING_OUTPUT( RETVAL, RETVALSV );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__UNIXaddress_SetFilename); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__UNIXaddress_SetFilename)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "THIS, filename");
    {
	wxUNIXaddress *    THIS = (wxUNIXaddress *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::UNIXaddress" )
;
	wxString	filename;

    WXSTRING_INPUT( filename, wxString, ST(1) )
;
    try {
      THIS->Filename( filename );
    }
    catch (std::exception& e) {
      croak("Caught C++ exception of type or derived from 'std::exception': %s", e.what());
    }
    catch (...) {
      croak("Caught C++ exception of unknown type");
    }
    }
    XSRETURN_EMPTY;
}

#endif

/* INCLUDE: Returning to 'Socket.xs' from '/usr/bin/perl -MExtUtils::XSpp::Cmd -e xspp -- -t ../../typemap.xsp XS/SockAddress.xsp' */


/* INCLUDE_COMMAND:  Including output of '/usr/bin/perl -MExtUtils::XSpp::Cmd -e xspp -- -t ../../typemap.xsp XS/DatagramSocket.xsp' from 'Socket.xs' */

#include <exception>

#undef  xsp_constructor_class
#define xsp_constructor_class(c) (c)
#undef  xsp_constructor_class
#define xsp_constructor_class(c) (CLASS)

XS_EUPXS(XS_Wx__DatagramSocket_new); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__DatagramSocket_new)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "CLASS, addr, flags= wxSOCKET_NONE");
    {
	char *	CLASS = (char *)SvPV_nolen(ST(0))
;
	wxDatagramSocket *	RETVAL;
	wxSockAddress*    addr = (wxSockAddress *) wxPli_sv_2_object( aTHX_ ST(1), "Wx::SockAddress" )
;
	wxSocketFlags	flags;

	if (items < 3)
	    flags = wxSOCKET_NONE;
	else {
	    flags = (wxSocketFlags)SvIV(ST(2))
;
	}
     RETVAL = new wxPliDatagramSocket( CLASS , *addr, flags ); 
	{
	    SV * RETVALSV;
	    RETVALSV = sv_newmortal();
    wxPli_object_2_sv( aTHX_ RETVALSV, RETVAL );
	    ST(0) = RETVALSV;
	}
    }
    XSRETURN(1);
}

#undef  xsp_constructor_class
#define xsp_constructor_class(c) (c)

XS_EUPXS(XS_Wx__DatagramSocket_RecvFrom); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__DatagramSocket_RecvFrom)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "THIS, addr, buf, nBytes");
    {
	wxSockAddress*    addr = (wxSockAddress *) wxPli_sv_2_object( aTHX_ ST(1), "Wx::SockAddress" )
;
	SV*	buf = ST(2)
;
	wxUint32	nBytes = (wxUint32)SvIV(ST(3))
;
	wxDatagramSocket *    THIS = (wxDatagramSocket *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::DatagramSocket" )
;
	size_t	RETVAL;
	dXSTARG;
    DO_READ( THIS->RecvFrom( *addr, buffer, nBytes ), buf, nBytes, 0 );
	XSprePUSH;
	PUSHu((UV)RETVAL );
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Wx__DatagramSocket_SendTo); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Wx__DatagramSocket_SendTo)
{
    dVAR; dXSARGS;
    if (items != 4)
       croak_xs_usage(cv,  "THIS, addr, buf, nBytes");
    {
	wxSockAddress*    addr = (wxSockAddress *) wxPli_sv_2_object( aTHX_ ST(1), "Wx::SockAddress" )
;
	SV*	buf = ST(2)
;
	wxUint32	nBytes = (wxUint32)SvIV(ST(3))
;
	wxDatagramSocket *    THIS = (wxDatagramSocket *) wxPli_sv_2_object( aTHX_ ST(0), "Wx::DatagramSocket" )
;
	size_t	RETVAL;
	dXSTARG;
    DO_WRITE( THIS->SendTo( *addr, buffer, nBytes ), buf, nBytes );
	XSprePUSH;
	PUSHu((UV)RETVAL );
    }
    XSRETURN(1);
}


/* INCLUDE: Returning to 'Socket.xs' from '/usr/bin/perl -MExtUtils::XSpp::Cmd -e xspp -- -t ../../typemap.xsp XS/DatagramSocket.xsp' */

#if defined(__WXMSW__)
#undef XS
#define XS( name ) WXXS( name )
#endif
#ifdef __cplusplus
extern "C"
#endif
XS_EXTERNAL(boot_Wx__Socket); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Wx__Socket)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Wx::SocketEvent::new", XS_Wx__SocketEvent_new);
        newXS_deffile("Wx::SocketEvent::GetSocket", XS_Wx__SocketEvent_GetSocket);
        newXS_deffile("Wx::SocketEvent::GetSocketEvent", XS_Wx__SocketEvent_GetSocketEvent);
        newXS_deffile("Wx::SocketServer::new", XS_Wx__SocketServer_new);
        newXS_deffile("Wx::SocketServer::Accept", XS_Wx__SocketServer_Accept);
        newXS_deffile("Wx::SocketServer::AcceptWith", XS_Wx__SocketServer_AcceptWith);
        newXS_deffile("Wx::SocketServer::WaitForAccept", XS_Wx__SocketServer_WaitForAccept);
        newXS_deffile("Wx::SocketClient::new", XS_Wx__SocketClient_new);
        newXS_deffile("Wx::SocketClient::Connect", XS_Wx__SocketClient_Connect);
#if XSubPPtmpAAAA
        newXS_deffile("Wx::SocketBase::new", XS_Wx__SocketBase_new);
#endif
        newXS_deffile("Wx::SocketBase::Destroy", XS_Wx__SocketBase_Destroy);
        newXS_deffile("Wx::SocketBase::Ok", XS_Wx__SocketBase_Ok);
        newXS_deffile("Wx::SocketBase::IsConnected", XS_Wx__SocketBase_IsConnected);
        newXS_deffile("Wx::SocketBase::IsDisconnected", XS_Wx__SocketBase_IsDisconnected);
        newXS_deffile("Wx::SocketBase::IsData", XS_Wx__SocketBase_IsData);
        newXS_deffile("Wx::SocketBase::LastCount", XS_Wx__SocketBase_LastCount);
        newXS_deffile("Wx::SocketBase::Notify", XS_Wx__SocketBase_Notify);
        newXS_deffile("Wx::SocketBase::SetTimeout", XS_Wx__SocketBase_SetTimeout);
        newXS_deffile("Wx::SocketBase::Wait", XS_Wx__SocketBase_Wait);
        newXS_deffile("Wx::SocketBase::WaitForRead", XS_Wx__SocketBase_WaitForRead);
        newXS_deffile("Wx::SocketBase::WaitForWrite", XS_Wx__SocketBase_WaitForWrite);
        newXS_deffile("Wx::SocketBase::Read", XS_Wx__SocketBase_Read);
        newXS_deffile("Wx::SocketBase::Close", XS_Wx__SocketBase_Close);
        newXS_deffile("Wx::SocketBase::Discard", XS_Wx__SocketBase_Discard);
        newXS_deffile("Wx::SocketBase::Error", XS_Wx__SocketBase_Error);
        newXS_deffile("Wx::SocketBase::GetFlags", XS_Wx__SocketBase_GetFlags);
        newXS_deffile("Wx::SocketBase::GetLocal", XS_Wx__SocketBase_GetLocal);
        newXS_deffile("Wx::SocketBase::GetPeer", XS_Wx__SocketBase_GetPeer);
        newXS_deffile("Wx::SocketBase::InterruptWait", XS_Wx__SocketBase_InterruptWait);
        newXS_deffile("Wx::SocketBase::LastError", XS_Wx__SocketBase_LastError);
        newXS_deffile("Wx::SocketBase::Peek", XS_Wx__SocketBase_Peek);
        newXS_deffile("Wx::SocketBase::ReadMsg", XS_Wx__SocketBase_ReadMsg);
        newXS_deffile("Wx::SocketBase::RestoreState", XS_Wx__SocketBase_RestoreState);
        newXS_deffile("Wx::SocketBase::SaveState", XS_Wx__SocketBase_SaveState);
        newXS_deffile("Wx::SocketBase::SetFlags", XS_Wx__SocketBase_SetFlags);
        newXS_deffile("Wx::SocketBase::SetNotify", XS_Wx__SocketBase_SetNotify);
        newXS_deffile("Wx::SocketBase::Unread", XS_Wx__SocketBase_Unread);
        newXS_deffile("Wx::SocketBase::WaitForLost", XS_Wx__SocketBase_WaitForLost);
        newXS_deffile("Wx::SocketBase::Write", XS_Wx__SocketBase_Write);
        newXS_deffile("Wx::SocketBase::WriteMsg", XS_Wx__SocketBase_WriteMsg);
        newXS_deffile("Wx::SocketBase::SetEventHandler", XS_Wx__SocketBase_SetEventHandler);
        newXS_deffile("Wx::SockAddress::CLONE", XS_Wx__SockAddress_CLONE);
        newXS_deffile("Wx::SockAddress::DESTROY", XS_Wx__SockAddress_DESTROY);
        newXS_deffile("Wx::SockAddress::Clear", XS_Wx__SockAddress_Clear);
        newXS_deffile("Wx::SockAddress::Type", XS_Wx__SockAddress_Type);
#if XSubPPtmpAAAB
        newXS_deffile("Wx::IPaddress::SetHostname", XS_Wx__IPaddress_SetHostname);
        newXS_deffile("Wx::IPaddress::SetService", XS_Wx__IPaddress_SetService);
        newXS_deffile("Wx::IPaddress::IsLocalHost", XS_Wx__IPaddress_IsLocalHost);
        newXS_deffile("Wx::IPaddress::SetAnyAddress", XS_Wx__IPaddress_SetAnyAddress);
        newXS_deffile("Wx::IPaddress::GetIPAddress", XS_Wx__IPaddress_GetIPAddress);
        newXS_deffile("Wx::IPaddress::GetHostname", XS_Wx__IPaddress_GetHostname);
        newXS_deffile("Wx::IPaddress::GetService", XS_Wx__IPaddress_GetService);
#endif
        newXS_deffile("Wx::IPV4address::new", XS_Wx__IPV4address_new);
        newXS_deffile("Wx::IPV4address::GetOrigHostname", XS_Wx__IPV4address_GetOrigHostname);
#if XSubPPtmpAAAC
        newXS_deffile("Wx::IPV4address::SetBroadcastAddress", XS_Wx__IPV4address_SetBroadcastAddress);
#endif
#if XSubPPtmpAAAD
        newXS_deffile("Wx::IPV6address::new", XS_Wx__IPV6address_new);
#endif
#if XSubPPtmpAAAE
        newXS_deffile("Wx::UNIXaddress::new", XS_Wx__UNIXaddress_new);
        newXS_deffile("Wx::UNIXaddress::GetFilename", XS_Wx__UNIXaddress_GetFilename);
        newXS_deffile("Wx::UNIXaddress::SetFilename", XS_Wx__UNIXaddress_SetFilename);
#endif
        newXS_deffile("Wx::DatagramSocket::new", XS_Wx__DatagramSocket_new);
        newXS_deffile("Wx::DatagramSocket::RecvFrom", XS_Wx__DatagramSocket_RecvFrom);
        newXS_deffile("Wx::DatagramSocket::SendTo", XS_Wx__DatagramSocket_SendTo);

    /* Initialisation Section */

  INIT_PLI_HELPERS( wx_pli_helpers );

#if XSubPPtmpAAAA
#endif
#if XSubPPtmpAAAB
#endif
#if XSubPPtmpAAAC
#endif
#if XSubPPtmpAAAD
#endif
#if XSubPPtmpAAAE
#endif

    /* End of Initialisation Section */

#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

