/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.16
 *
 *     Copyright: (c) 2018 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_html.h"

        #include <wx/html/htmlwin.h>

        #include <wx/cursor.h>
        #include <wx/bitmap.h>
        #include <wx/colour.h>
        #include <wx/window.h>
        #include <wx/gdicmn.h>
        #include <wx/html/htmlcell.h>
        #include <wx/html/htmlcell.h>


class sipwxHtmlWindowInterface : public  ::wxHtmlWindowInterface
{
public:
    sipwxHtmlWindowInterface();
    sipwxHtmlWindowInterface(const  ::wxHtmlWindowInterface&);
    virtual ~sipwxHtmlWindowInterface();

    /*
     * There is a protected method for every virtual method visible from
     * this class.
     */
protected:
     ::wxCursor GetHTMLCursor( ::wxHtmlWindowInterface::HTMLCursor) const SIP_OVERRIDE;
    void SetHTMLStatusText(const  ::wxString&) SIP_OVERRIDE;
    void SetHTMLBackgroundImage(const  ::wxBitmap&) SIP_OVERRIDE;
    void SetHTMLBackgroundColour(const  ::wxColour&) SIP_OVERRIDE;
     ::wxColour GetHTMLBackgroundColour() const SIP_OVERRIDE;
     ::wxWindow* GetHTMLWindow() SIP_OVERRIDE;
     ::wxPoint HTMLCoordsToWindow( ::wxHtmlCell*,const  ::wxPoint&) const SIP_OVERRIDE;
     ::wxHtmlOpeningStatus OnHTMLOpeningURL( ::wxHtmlURLType,const  ::wxString&, ::wxString*) const SIP_OVERRIDE;
    void OnHTMLLinkClicked(const  ::wxHtmlLinkInfo&) SIP_OVERRIDE;
    void SetHTMLWindowTitle(const  ::wxString&) SIP_OVERRIDE;

public:
    sipSimpleWrapper *sipPySelf;

private:
    sipwxHtmlWindowInterface(const sipwxHtmlWindowInterface &);
    sipwxHtmlWindowInterface &operator = (const sipwxHtmlWindowInterface &);

    char sipPyMethods[10];
};

sipwxHtmlWindowInterface::sipwxHtmlWindowInterface():  ::wxHtmlWindowInterface(), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxHtmlWindowInterface::sipwxHtmlWindowInterface(const  ::wxHtmlWindowInterface& a0):  ::wxHtmlWindowInterface(a0), sipPySelf(SIP_NULLPTR)
{
    memset(sipPyMethods, 0, sizeof (sipPyMethods));
}

sipwxHtmlWindowInterface::~sipwxHtmlWindowInterface()
{
    sipInstanceDestroyedEx(&sipPySelf);
}

 ::wxCursor sipwxHtmlWindowInterface::GetHTMLCursor( ::wxHtmlWindowInterface::HTMLCursor type) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[0]),sipPySelf,sipName_HtmlWindowInterface,sipName_GetHTMLCursor);

    if (!sipMeth)
        return  ::wxCursor();

    extern  ::wxCursor sipVH__html_32(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxHtmlWindowInterface::HTMLCursor);

    return sipVH__html_32(sipGILState, 0, sipPySelf, sipMeth, type);
}

void sipwxHtmlWindowInterface::SetHTMLStatusText(const  ::wxString& text)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[1],sipPySelf,sipName_HtmlWindowInterface,sipName_SetHTMLStatusText);

    if (!sipMeth)
        return;

    extern void sipVH__html_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    sipVH__html_22(sipGILState, 0, sipPySelf, sipMeth, text);
}

void sipwxHtmlWindowInterface::SetHTMLBackgroundImage(const  ::wxBitmap& bmpBg)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[2],sipPySelf,sipName_HtmlWindowInterface,sipName_SetHTMLBackgroundImage);

    if (!sipMeth)
        return;

    extern void sipVH__html_31(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxBitmap&);

    sipVH__html_31(sipGILState, 0, sipPySelf, sipMeth, bmpBg);
}

void sipwxHtmlWindowInterface::SetHTMLBackgroundColour(const  ::wxColour& clr)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[3],sipPySelf,sipName_HtmlWindowInterface,sipName_SetHTMLBackgroundColour);

    if (!sipMeth)
        return;

    extern void sipVH__html_30(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxColour&);

    sipVH__html_30(sipGILState, 0, sipPySelf, sipMeth, clr);
}

 ::wxColour sipwxHtmlWindowInterface::GetHTMLBackgroundColour() const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[4]),sipPySelf,sipName_HtmlWindowInterface,sipName_GetHTMLBackgroundColour);

    if (!sipMeth)
        return  ::wxColour();

    extern  ::wxColour sipVH__html_29(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__html_29(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxWindow* sipwxHtmlWindowInterface::GetHTMLWindow()
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[5],sipPySelf,sipName_HtmlWindowInterface,sipName_GetHTMLWindow);

    if (!sipMeth)
        return 0;

    extern  ::wxWindow* sipVH__html_28(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *);

    return sipVH__html_28(sipGILState, 0, sipPySelf, sipMeth);
}

 ::wxPoint sipwxHtmlWindowInterface::HTMLCoordsToWindow( ::wxHtmlCell*cell,const  ::wxPoint& pos) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[6]),sipPySelf,sipName_HtmlWindowInterface,sipName_HTMLCoordsToWindow);

    if (!sipMeth)
        return  ::wxPoint();

    extern  ::wxPoint sipVH__html_27(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxHtmlCell*,const  ::wxPoint&);

    return sipVH__html_27(sipGILState, 0, sipPySelf, sipMeth, cell, pos);
}

 ::wxHtmlOpeningStatus sipwxHtmlWindowInterface::OnHTMLOpeningURL( ::wxHtmlURLType type,const  ::wxString& url, ::wxString*redirectTo) const
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,const_cast<char *>(&sipPyMethods[7]),sipPySelf,sipName_HtmlWindowInterface,sipName_OnHTMLOpeningURL);

    if (!sipMeth)
        return ::wxHTML_OPEN;

    extern  ::wxHtmlOpeningStatus sipVH__html_26(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *,  ::wxHtmlURLType,const  ::wxString&, ::wxString*);

    return sipVH__html_26(sipGILState, 0, sipPySelf, sipMeth, type, url, redirectTo);
}

void sipwxHtmlWindowInterface::OnHTMLLinkClicked(const  ::wxHtmlLinkInfo& link)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[8],sipPySelf,sipName_HtmlWindowInterface,sipName_OnHTMLLinkClicked);

    if (!sipMeth)
        return;

    extern void sipVH__html_25(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxHtmlLinkInfo&);

    sipVH__html_25(sipGILState, 0, sipPySelf, sipMeth, link);
}

void sipwxHtmlWindowInterface::SetHTMLWindowTitle(const  ::wxString& title)
{
    sip_gilstate_t sipGILState;
    PyObject *sipMeth;

    sipMeth = sipIsPyMethod(&sipGILState,&sipPyMethods[9],sipPySelf,sipName_HtmlWindowInterface,sipName_SetHTMLWindowTitle);

    if (!sipMeth)
        return;

    extern void sipVH__html_22(sip_gilstate_t, sipVirtErrorHandlerFunc, sipSimpleWrapper *, PyObject *, const  ::wxString&);

    sipVH__html_22(sipGILState, 0, sipPySelf, sipMeth, title);
}


PyDoc_STRVAR(doc_wxHtmlWindowInterface_SetHTMLWindowTitle, "SetHTMLWindowTitle(title)\n"
"\n"
"Called by the parser to set window's title to given text.");

extern "C" {static PyObject *meth_wxHtmlWindowInterface_SetHTMLWindowTitle(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWindowInterface_SetHTMLWindowTitle(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* title;
        int titleState = 0;
         ::wxHtmlWindowInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_title,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxHtmlWindowInterface, &sipCpp, sipType_wxString,&title, &titleState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlWindowInterface, sipName_SetHTMLWindowTitle);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHTMLWindowTitle(*title);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(title),sipType_wxString,titleState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWindowInterface, sipName_SetHTMLWindowTitle, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlWindowInterface_OnHTMLLinkClicked, "OnHTMLLinkClicked(link)\n"
"\n"
"Called when a link is clicked.");

extern "C" {static PyObject *meth_wxHtmlWindowInterface_OnHTMLLinkClicked(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWindowInterface_OnHTMLLinkClicked(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxHtmlLinkInfo* link;
         ::wxHtmlWindowInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_link,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxHtmlWindowInterface, &sipCpp, sipType_wxHtmlLinkInfo, &link))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlWindowInterface, sipName_OnHTMLLinkClicked);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->OnHTMLLinkClicked(*link);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWindowInterface, sipName_OnHTMLLinkClicked, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlWindowInterface_OnHTMLOpeningURL, "OnHTMLOpeningURL(type, url) -> (HtmlOpeningStatus, redirectTo)\n"
"\n"
"Called when the parser needs to open another URL (e.g.");

extern "C" {static PyObject *meth_wxHtmlWindowInterface_OnHTMLOpeningURL(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWindowInterface_OnHTMLOpeningURL(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxHtmlURLType type;
        const  ::wxString* url;
        int urlState = 0;
         ::wxString* redirectTo;
        const  ::wxHtmlWindowInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_type,
            sipName_url,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BEJ1", &sipSelf, sipType_wxHtmlWindowInterface, &sipCpp, sipType_wxHtmlURLType, &type, sipType_wxString,&url, &urlState))
        {
             ::wxHtmlOpeningStatus sipRes;
            redirectTo = new  ::wxString();

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlWindowInterface, sipName_OnHTMLOpeningURL);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->OnHTMLOpeningURL(type,*url,redirectTo);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(url),sipType_wxString,urlState);

            if (PyErr_Occurred())
                return 0;

            return sipBuildResult(0,"(FN)",sipRes,sipType_wxHtmlOpeningStatus,redirectTo,sipType_wxString,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWindowInterface, sipName_OnHTMLOpeningURL, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlWindowInterface_HTMLCoordsToWindow, "HTMLCoordsToWindow(cell, pos) -> wx.Point\n"
"\n"
"Converts coordinates pos relative to given cell to physical\n"
"coordinates in the window.");

extern "C" {static PyObject *meth_wxHtmlWindowInterface_HTMLCoordsToWindow(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWindowInterface_HTMLCoordsToWindow(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxHtmlCell* cell;
        const  ::wxPoint* pos;
        int posState = 0;
        const  ::wxHtmlWindowInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_cell,
            sipName_pos,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J1", &sipSelf, sipType_wxHtmlWindowInterface, &sipCpp, sipType_wxHtmlCell, &cell, sipType_wxPoint, &pos, &posState))
        {
             ::wxPoint*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlWindowInterface, sipName_HTMLCoordsToWindow);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxPoint(sipCpp->HTMLCoordsToWindow(cell,*pos));
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxPoint *>(pos),sipType_wxPoint,posState);

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxPoint,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWindowInterface, sipName_HTMLCoordsToWindow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlWindowInterface_GetHTMLWindow, "GetHTMLWindow() -> wx.Window\n"
"\n"
"Returns the window used for rendering (may be NULL).");

extern "C" {static PyObject *meth_wxHtmlWindowInterface_GetHTMLWindow(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWindowInterface_GetHTMLWindow(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxHtmlWindowInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWindowInterface, &sipCpp))
        {
             ::wxWindow*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlWindowInterface, sipName_GetHTMLWindow);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetHTMLWindow();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxWindow,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWindowInterface, sipName_GetHTMLWindow, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlWindowInterface_GetHTMLBackgroundColour, "GetHTMLBackgroundColour() -> wx.Colour\n"
"\n"
"Returns background colour to use by default.");

extern "C" {static PyObject *meth_wxHtmlWindowInterface_GetHTMLBackgroundColour(PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWindowInterface_GetHTMLBackgroundColour(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxHtmlWindowInterface *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxHtmlWindowInterface, &sipCpp))
        {
             ::wxColour*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlWindowInterface, sipName_GetHTMLBackgroundColour);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxColour(sipCpp->GetHTMLBackgroundColour());
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxColour,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWindowInterface, sipName_GetHTMLBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlWindowInterface_SetHTMLBackgroundColour, "SetHTMLBackgroundColour(clr)\n"
"\n"
"Sets window's background to colour clr.");

extern "C" {static PyObject *meth_wxHtmlWindowInterface_SetHTMLBackgroundColour(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWindowInterface_SetHTMLBackgroundColour(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxColour* clr;
        int clrState = 0;
         ::wxHtmlWindowInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_clr,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxHtmlWindowInterface, &sipCpp, sipType_wxColour, &clr, &clrState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlWindowInterface, sipName_SetHTMLBackgroundColour);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHTMLBackgroundColour(*clr);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxColour *>(clr),sipType_wxColour,clrState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWindowInterface, sipName_SetHTMLBackgroundColour, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlWindowInterface_SetHTMLBackgroundImage, "SetHTMLBackgroundImage(bmpBg)\n"
"\n"
"Sets window's background to given bitmap.");

extern "C" {static PyObject *meth_wxHtmlWindowInterface_SetHTMLBackgroundImage(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWindowInterface_SetHTMLBackgroundImage(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxBitmap* bmpBg;
         ::wxHtmlWindowInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_bmpBg,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxHtmlWindowInterface, &sipCpp, sipType_wxBitmap, &bmpBg))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlWindowInterface, sipName_SetHTMLBackgroundImage);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHTMLBackgroundImage(*bmpBg);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWindowInterface, sipName_SetHTMLBackgroundImage, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlWindowInterface_SetHTMLStatusText, "SetHTMLStatusText(text)\n"
"\n"
"Sets status bar text.");

extern "C" {static PyObject *meth_wxHtmlWindowInterface_SetHTMLStatusText(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWindowInterface_SetHTMLStatusText(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
        const  ::wxString* text;
        int textState = 0;
         ::wxHtmlWindowInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_text,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxHtmlWindowInterface, &sipCpp, sipType_wxString,&text, &textState))
        {
            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlWindowInterface, sipName_SetHTMLStatusText);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetHTMLStatusText(*text);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxString *>(text),sipType_wxString,textState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWindowInterface, sipName_SetHTMLStatusText, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxHtmlWindowInterface_GetHTMLCursor, "GetHTMLCursor(type) -> wx.Cursor\n"
"\n"
"Returns mouse cursor of given type.");

extern "C" {static PyObject *meth_wxHtmlWindowInterface_GetHTMLCursor(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxHtmlWindowInterface_GetHTMLCursor(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;
    PyObject *sipOrigSelf = sipSelf;

    {
         ::wxHtmlWindowInterface::HTMLCursor type;
        const  ::wxHtmlWindowInterface *sipCpp;

        static const char *sipKwdList[] = {
            sipName_type,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BE", &sipSelf, sipType_wxHtmlWindowInterface, &sipCpp, sipType_wxHtmlWindowInterface_HTMLCursor, &type))
        {
             ::wxCursor*sipRes;

            if (!sipOrigSelf)
            {
                sipAbstractMethod(sipName_HtmlWindowInterface, sipName_GetHTMLCursor);
                return SIP_NULLPTR;
            }

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = new  ::wxCursor(sipCpp->GetHTMLCursor(type));
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromNewType(sipRes,sipType_wxCursor,SIP_NULLPTR);
        }
    }

    /* Raise an exception if the arguments couldn't be parsed. */
    sipNoMethod(sipParseErr, sipName_HtmlWindowInterface, sipName_GetHTMLCursor, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxHtmlWindowInterface(void *, int);}
static void release_wxHtmlWindowInterface(void *sipCppV, int sipState)
{
    Py_BEGIN_ALLOW_THREADS

    if (sipState & SIP_DERIVED_CLASS)
        delete reinterpret_cast<sipwxHtmlWindowInterface *>(sipCppV);
    else
        delete reinterpret_cast< ::wxHtmlWindowInterface *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void dealloc_wxHtmlWindowInterface(sipSimpleWrapper *);}
static void dealloc_wxHtmlWindowInterface(sipSimpleWrapper *sipSelf)
{
    if (sipIsDerivedClass(sipSelf))
        reinterpret_cast<sipwxHtmlWindowInterface *>(sipGetAddress(sipSelf))->sipPySelf = SIP_NULLPTR;

    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxHtmlWindowInterface(sipGetAddress(sipSelf), sipIsDerivedClass(sipSelf));
    }
}


extern "C" {static void *init_type_wxHtmlWindowInterface(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxHtmlWindowInterface(sipSimpleWrapper *sipSelf, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
    sipwxHtmlWindowInterface *sipCpp = SIP_NULLPTR;

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxHtmlWindowInterface();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    {
        const  ::wxHtmlWindowInterface* a0;

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, "J9", sipType_wxHtmlWindowInterface, &a0))
        {
            Py_BEGIN_ALLOW_THREADS
            sipCpp = new sipwxHtmlWindowInterface(*a0);
            Py_END_ALLOW_THREADS

            sipCpp->sipPySelf = sipSelf;

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxHtmlWindowInterface[] = {
    {SIP_MLNAME_CAST(sipName_GetHTMLBackgroundColour), meth_wxHtmlWindowInterface_GetHTMLBackgroundColour, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWindowInterface_GetHTMLBackgroundColour)},
    {SIP_MLNAME_CAST(sipName_GetHTMLCursor), SIP_MLMETH_CAST(meth_wxHtmlWindowInterface_GetHTMLCursor), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWindowInterface_GetHTMLCursor)},
    {SIP_MLNAME_CAST(sipName_GetHTMLWindow), meth_wxHtmlWindowInterface_GetHTMLWindow, METH_VARARGS, SIP_MLDOC_CAST(doc_wxHtmlWindowInterface_GetHTMLWindow)},
    {SIP_MLNAME_CAST(sipName_HTMLCoordsToWindow), SIP_MLMETH_CAST(meth_wxHtmlWindowInterface_HTMLCoordsToWindow), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWindowInterface_HTMLCoordsToWindow)},
    {SIP_MLNAME_CAST(sipName_OnHTMLLinkClicked), SIP_MLMETH_CAST(meth_wxHtmlWindowInterface_OnHTMLLinkClicked), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWindowInterface_OnHTMLLinkClicked)},
    {SIP_MLNAME_CAST(sipName_OnHTMLOpeningURL), SIP_MLMETH_CAST(meth_wxHtmlWindowInterface_OnHTMLOpeningURL), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWindowInterface_OnHTMLOpeningURL)},
    {SIP_MLNAME_CAST(sipName_SetHTMLBackgroundColour), SIP_MLMETH_CAST(meth_wxHtmlWindowInterface_SetHTMLBackgroundColour), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWindowInterface_SetHTMLBackgroundColour)},
    {SIP_MLNAME_CAST(sipName_SetHTMLBackgroundImage), SIP_MLMETH_CAST(meth_wxHtmlWindowInterface_SetHTMLBackgroundImage), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWindowInterface_SetHTMLBackgroundImage)},
    {SIP_MLNAME_CAST(sipName_SetHTMLStatusText), SIP_MLMETH_CAST(meth_wxHtmlWindowInterface_SetHTMLStatusText), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWindowInterface_SetHTMLStatusText)},
    {SIP_MLNAME_CAST(sipName_SetHTMLWindowTitle), SIP_MLMETH_CAST(meth_wxHtmlWindowInterface_SetHTMLWindowTitle), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxHtmlWindowInterface_SetHTMLWindowTitle)}
};

static sipEnumMemberDef enummembers_wxHtmlWindowInterface[] = {
    {sipName_HTMLCursor_Default, static_cast<int>( ::wxHtmlWindowInterface::HTMLCursor_Default), 38},
    {sipName_HTMLCursor_Link, static_cast<int>( ::wxHtmlWindowInterface::HTMLCursor_Link), 38},
    {sipName_HTMLCursor_Text, static_cast<int>( ::wxHtmlWindowInterface::HTMLCursor_Text), 38},
};

sipVariableDef variables_wxHtmlWindowInterface[] = {
    {PropertyVariable, sipName_HTMLWindow, &methods_wxHtmlWindowInterface[2], SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    {PropertyVariable, sipName_HTMLBackgroundColour, &methods_wxHtmlWindowInterface[0], &methods_wxHtmlWindowInterface[6], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxHtmlWindowInterface, "HtmlWindowInterface()\n"
"\n"
"Abstract interface to a HTML rendering window (such as wxHtmlWindow or\n"
"wxHtmlListBox) that is passed to wxHtmlWinParser.");


sipClassTypeDef sipTypeDef__html_wxHtmlWindowInterface = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_ABSTRACT|SIP_TYPE_CLASS,
        sipNameNr_wxHtmlWindowInterface,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_HtmlWindowInterface,
        {0, 0, 1},
        10, methods_wxHtmlWindowInterface,
        3, enummembers_wxHtmlWindowInterface,
        2, variables_wxHtmlWindowInterface,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxHtmlWindowInterface,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxHtmlWindowInterface,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxHtmlWindowInterface,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    release_wxHtmlWindowInterface,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
