/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLFrameSetElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLFrameSetElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLFrameSetElement* kit(WebCore::HTMLFrameSetElement* obj)
{
    return WEBKIT_DOM_HTML_FRAME_SET_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLFrameSetElement* core(WebKitDOMHTMLFrameSetElement* request)
{
    return request ? static_cast<WebCore::HTMLFrameSetElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLFrameSetElement* wrapHTMLFrameSetElement(WebCore::HTMLFrameSetElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_FRAME_SET_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_FRAME_SET_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLFrameSetElement, webkit_dom_html_frame_set_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_COLS,
    PROP_ROWS,
};

static void webkit_dom_html_frame_set_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLFrameSetElement* self = WEBKIT_DOM_HTML_FRAME_SET_ELEMENT(object);
    WebCore::HTMLFrameSetElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_COLS: {
        coreSelf->setAttribute(WebCore::HTMLNames::colsAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ROWS: {
        coreSelf->setAttribute(WebCore::HTMLNames::rowsAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_frame_set_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLFrameSetElement* self = WEBKIT_DOM_HTML_FRAME_SET_ELEMENT(object);
    WebCore::HTMLFrameSetElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_COLS: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::colsAttr)));
        break;
    }
    case PROP_ROWS: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::rowsAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_frame_set_element_class_init(WebKitDOMHTMLFrameSetElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_frame_set_element_set_property;
    gobjectClass->get_property = webkit_dom_html_frame_set_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_COLS,
                                    g_param_spec_string("cols", /* name */
                                                           "html_frame_set_element_cols", /* short description */
                                                           "read-write  gchar* HTMLFrameSetElement.cols", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ROWS,
                                    g_param_spec_string("rows", /* name */
                                                           "html_frame_set_element_rows", /* short description */
                                                           "read-write  gchar* HTMLFrameSetElement.rows", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_frame_set_element_init(WebKitDOMHTMLFrameSetElement* request)
{
}

gchar*
webkit_dom_html_frame_set_element_get_cols(WebKitDOMHTMLFrameSetElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_SET_ELEMENT(self), 0);
    WebCore::HTMLFrameSetElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::colsAttr));
    return result;
}

void
webkit_dom_html_frame_set_element_set_cols(WebKitDOMHTMLFrameSetElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FRAME_SET_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFrameSetElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::colsAttr, convertedValue);
}

gchar*
webkit_dom_html_frame_set_element_get_rows(WebKitDOMHTMLFrameSetElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_FRAME_SET_ELEMENT(self), 0);
    WebCore::HTMLFrameSetElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::rowsAttr));
    return result;
}

void
webkit_dom_html_frame_set_element_set_rows(WebKitDOMHTMLFrameSetElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_FRAME_SET_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLFrameSetElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::rowsAttr, convertedValue);
}

