/* Copyright (C) 2022-2025 Free Software Foundation

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses>.  */

package org.gprofng.mpmt.settings;

import org.gprofng.analyzer.AnEnvironment;
import org.gprofng.mpmt.AnLocale;
import org.gprofng.mpmt.AnWindow;
import org.gprofng.mpmt.persistence.UserPref;
import org.gprofng.mpmt.util.gui.AnUtility;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

/**
 * @author tpreisle
 */
public class CallTreePanel extends JPanel {

  private final ChangeListener spinnerChangeListener;

  public CallTreePanel() {
    initComponents();
    setBackground(AnEnvironment.DEFAULT_PANEL_BACKGROUND);
    AnUtility.setTextAndAccessibleContext(
        label,
        AnLocale.getString("Expand branches when percent of metric exceeds this threshold (%):"));
    JComponent editor = ((JSpinner.DefaultEditor) spinner.getEditor());
    Dimension size = editor.getPreferredSize();
    editor.setPreferredSize(new Dimension(20, size.height));
    label.setLabelFor(spinner);
    label.setDisplayedMnemonic(AnLocale.getString('E', "MN_SETTINGS_CALLTREE_THRESHOLD"));
    AnUtility.setTTAndAccessibleContext(spinner, AnLocale.getString("Threshold"));
    spinner.setValue(UserPref.getInstance().getCallStackThreshold());
    spinner.addChangeListener(
        spinnerChangeListener =
            new ChangeListener() {
              @Override
              public void stateChanged(ChangeEvent e) {
                Integer val = (Integer) spinner.getValue();
                if (val < 0) {
                  spinner.setValue(0);
                } else if (val > 100) {
                  spinner.setValue(100);
                }
                AnWindow.getInstance().getSettings().stateChanged(null);
              }
            });
  }

  public void updateGUI() {
    int threshold = AnWindow.getInstance().getSettings().getCallTreeSetting().getThreshold();
    spinner.removeChangeListener(spinnerChangeListener);
    spinner.setValue(threshold);
    spinner.addChangeListener(spinnerChangeListener);
  }

  public void checkChanges(Object originalSource) {
    Integer val = (Integer) spinner.getValue();
    AnWindow.getInstance()
        .getSettings()
        .getCallTreeSetting()
        .setThreshold(originalSource, val.intValue());
  }

  /**
   * This method is called from within the constructor to initialize the form. WARNING: Do NOT
   * modify this code. The content of this method is always regenerated by the Form Editor.
   */
  @SuppressWarnings("unchecked")
  // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
  private void initComponents() {
    java.awt.GridBagConstraints gridBagConstraints;

    label = new javax.swing.JLabel();
    spinner = new javax.swing.JSpinner();

    setLayout(new java.awt.GridBagLayout());

    label.setText("<NOI18N>");
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_START;
    gridBagConstraints.insets = new java.awt.Insets(12, 0, 0, 0);
    add(label, gridBagConstraints);
    gridBagConstraints = new java.awt.GridBagConstraints();
    gridBagConstraints.anchor = java.awt.GridBagConstraints.PAGE_START;
    gridBagConstraints.weighty = 1.0;
    gridBagConstraints.insets = new java.awt.Insets(12, 4, 0, 0);
    add(spinner, gridBagConstraints);
  } // </editor-fold>//GEN-END:initComponents

  // Variables declaration - do not modify//GEN-BEGIN:variables
  private javax.swing.JLabel label;
  private javax.swing.JSpinner spinner;
  // End of variables declaration//GEN-END:variables
}
