/*
 * Copyright (c) 2006 Jean-François Wauthy (pollux@xfce.org)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <glib.h>

#include <libxfprint/printer.h>

static gint
compare_name_func (const Printer * pr, const gchar * name)
{
  return (g_ascii_strcasecmp (pr->name, name));
}

static gint
compare_alias_func (const Printer * pr, const gchar * alias)
{
  return (g_ascii_strcasecmp (pr->alias, alias));
}

void
printer_free (Printer * printer)
{
  if (!printer)
    return;

  g_free (printer->name);
  g_free (printer->alias);
}

static void
printers_free_foreach (Printer * printer, gpointer data)
{
  printer_free (printer);
}

void
printers_free (GList * printers)
{
  g_list_foreach (printers, (GFunc) printers_free_foreach, NULL);
  g_list_free (printers);
}

Printer *
printer_lookup_byalias (GList * list, const gchar * alias)
{
  GList *el;

  el = g_list_find_custom (list, alias, (GCompareFunc) compare_alias_func);

  if (el)
    return ((Printer *) el->data);
  else
    return NULL;
}

Printer *
printer_lookup_byname (GList * list, const gchar * name)
{
  GList *el;

  el = g_list_find_custom (list, name, (GCompareFunc) compare_name_func);

  if (el)
    return ((Printer *) el->data);
  else
    return NULL;
}
