.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XChangePointerControl __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XChangePointerControl, XGetPointerControl \- control pointer
.SH SYNTAX
.HP
int XChangePointerControl\^(\^Display *\fIdisplay\fP\^, Bool \fIdo_accel\fP\^,
Bool \fIdo_threshold\fP\^, int \fIaccel_numerator\fP\^, int
\fIaccel_denominator\fP\^, int \fIthreshold\fP\^);
.HP
int XGetPointerControl\^(\^Display *\fIdisplay\fP\^, int
*\fIaccel_numerator_return\fP\^, int *\fIaccel_denominator_return\fP\^, int
*\fIthreshold_return\fP\^);
.SH ARGUMENTS
.IP \fIaccel_denominator\fP 1i
Specifies the denominator for the acceleration multiplier.
.IP \fIaccel_denominator_return\fP 1i
Returns the denominator for the acceleration multiplier.
.IP \fIaccel_numerator\fP 1i
Specifies the numerator for the acceleration multiplier.
.IP \fIaccel_numerator_return\fP 1i
Returns the numerator for the acceleration multiplier.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIdo_accel\fP 1i
Specifies a Boolean value that controls whether the values for
the accel_numerator or accel_denominator are used.
.IP \fIdo_threshold\fP 1i
Specifies a Boolean value that controls whether the value for the
threshold is used.
.IP \fIthreshold\fP 1i
Specifies the acceleration threshold.
.IP \fIthreshold_return\fP 1i
Returns the acceleration threshold.
.SH DESCRIPTION
The
.B XChangePointerControl
function defines how the pointing device moves.
The acceleration, expressed as a fraction, is a
multiplier for movement.
For example,
specifying 3/1 means the pointer moves three times as fast as normal.
The fraction may be rounded arbitrarily by the X server.
Acceleration
only takes effect if the pointer moves more than threshold pixels at
once and only applies to the amount beyond the value in the threshold argument.
Setting a value to \-1 restores the default.
The values of the do_accel and do_threshold arguments must be
.B True
for the pointer values to be set,
or the parameters are unchanged.
Negative values (other than \-1) generate a
.B BadValue
error, as does a zero value
for the accel_denominator argument.
.LP
.B XChangePointerControl
can generate a
.B BadValue
error.
.LP
The
.B XGetPointerControl
function returns the pointer's current acceleration multiplier
and acceleration threshold.
.SH DIAGNOSTICS
.TP 1i
.B BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.
Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
\fI\*(xL\fP
