// Copyright 2025 The Sigstore Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.6
// 	protoc        v5.29.3
// source: rekor/v2/entry.proto

package protobuf

import (
	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Entry is the message that is canonicalized and uploaded to the log.
// This format is meant to be compliant with Rekor v1 entries in that
// the `apiVersion` and `kind` can be parsed before parsing the spec.
// Clients are expected to understand and handle the differences in the
// contents of `spec` between Rekor v1 (a polymorphic OpenAPI defintion)
// and Rekor v2 (a typed proto defintion).
type Entry struct {
	state         protoimpl.MessageState `protogen:"open.v1"`
	Kind          string                 `protobuf:"bytes,1,opt,name=kind,proto3" json:"kind,omitempty"`
	ApiVersion    string                 `protobuf:"bytes,2,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
	Spec          *Spec                  `protobuf:"bytes,3,opt,name=spec,proto3" json:"spec,omitempty"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Entry) Reset() {
	*x = Entry{}
	mi := &file_rekor_v2_entry_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Entry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entry) ProtoMessage() {}

func (x *Entry) ProtoReflect() protoreflect.Message {
	mi := &file_rekor_v2_entry_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entry.ProtoReflect.Descriptor instead.
func (*Entry) Descriptor() ([]byte, []int) {
	return file_rekor_v2_entry_proto_rawDescGZIP(), []int{0}
}

func (x *Entry) GetKind() string {
	if x != nil {
		return x.Kind
	}
	return ""
}

func (x *Entry) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

func (x *Entry) GetSpec() *Spec {
	if x != nil {
		return x.Spec
	}
	return nil
}

// Spec contains one of the Rekor entry types.
type Spec struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Spec:
	//
	//	*Spec_HashedRekordV002
	//	*Spec_DsseV002
	Spec          isSpec_Spec `protobuf_oneof:"spec"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *Spec) Reset() {
	*x = Spec{}
	mi := &file_rekor_v2_entry_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Spec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Spec) ProtoMessage() {}

func (x *Spec) ProtoReflect() protoreflect.Message {
	mi := &file_rekor_v2_entry_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Spec.ProtoReflect.Descriptor instead.
func (*Spec) Descriptor() ([]byte, []int) {
	return file_rekor_v2_entry_proto_rawDescGZIP(), []int{1}
}

func (x *Spec) GetSpec() isSpec_Spec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *Spec) GetHashedRekordV002() *HashedRekordLogEntryV002 {
	if x != nil {
		if x, ok := x.Spec.(*Spec_HashedRekordV002); ok {
			return x.HashedRekordV002
		}
	}
	return nil
}

func (x *Spec) GetDsseV002() *DSSELogEntryV002 {
	if x != nil {
		if x, ok := x.Spec.(*Spec_DsseV002); ok {
			return x.DsseV002
		}
	}
	return nil
}

type isSpec_Spec interface {
	isSpec_Spec()
}

type Spec_HashedRekordV002 struct {
	HashedRekordV002 *HashedRekordLogEntryV002 `protobuf:"bytes,1,opt,name=hashed_rekord_v002,json=hashedRekordV002,proto3,oneof"`
}

type Spec_DsseV002 struct {
	DsseV002 *DSSELogEntryV002 `protobuf:"bytes,2,opt,name=dsse_v002,json=dsseV002,proto3,oneof"`
}

func (*Spec_HashedRekordV002) isSpec_Spec() {}

func (*Spec_DsseV002) isSpec_Spec() {}

// Create a new HashedRekord or DSSE
type CreateEntryRequest struct {
	state protoimpl.MessageState `protogen:"open.v1"`
	// Types that are valid to be assigned to Spec:
	//
	//	*CreateEntryRequest_HashedRekordRequestV002
	//	*CreateEntryRequest_DsseRequestV002
	Spec          isCreateEntryRequest_Spec `protobuf_oneof:"spec"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *CreateEntryRequest) Reset() {
	*x = CreateEntryRequest{}
	mi := &file_rekor_v2_entry_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateEntryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntryRequest) ProtoMessage() {}

func (x *CreateEntryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_rekor_v2_entry_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntryRequest.ProtoReflect.Descriptor instead.
func (*CreateEntryRequest) Descriptor() ([]byte, []int) {
	return file_rekor_v2_entry_proto_rawDescGZIP(), []int{2}
}

func (x *CreateEntryRequest) GetSpec() isCreateEntryRequest_Spec {
	if x != nil {
		return x.Spec
	}
	return nil
}

func (x *CreateEntryRequest) GetHashedRekordRequestV002() *HashedRekordRequestV002 {
	if x != nil {
		if x, ok := x.Spec.(*CreateEntryRequest_HashedRekordRequestV002); ok {
			return x.HashedRekordRequestV002
		}
	}
	return nil
}

func (x *CreateEntryRequest) GetDsseRequestV002() *DSSERequestV002 {
	if x != nil {
		if x, ok := x.Spec.(*CreateEntryRequest_DsseRequestV002); ok {
			return x.DsseRequestV002
		}
	}
	return nil
}

type isCreateEntryRequest_Spec interface {
	isCreateEntryRequest_Spec()
}

type CreateEntryRequest_HashedRekordRequestV002 struct {
	HashedRekordRequestV002 *HashedRekordRequestV002 `protobuf:"bytes,1,opt,name=hashed_rekord_request_v002,json=hashedRekordRequestV002,proto3,oneof"`
}

type CreateEntryRequest_DsseRequestV002 struct {
	DsseRequestV002 *DSSERequestV002 `protobuf:"bytes,2,opt,name=dsse_request_v002,json=dsseRequestV002,proto3,oneof"`
}

func (*CreateEntryRequest_HashedRekordRequestV002) isCreateEntryRequest_Spec() {}

func (*CreateEntryRequest_DsseRequestV002) isCreateEntryRequest_Spec() {}

var File_rekor_v2_entry_proto protoreflect.FileDescriptor

const file_rekor_v2_entry_proto_rawDesc = "" +
	"\n" +
	"\x14rekor/v2/entry.proto\x12\x15dev.sigstore.rekor.v2\x1a\x1fgoogle/api/field_behavior.proto\x1a\x13rekor/v2/dsse.proto\x1a\x1brekor/v2/hashedrekord.proto\"|\n" +
	"\x05Entry\x12\x17\n" +
	"\x04kind\x18\x01 \x01(\tB\x03\xe0A\x02R\x04kind\x12$\n" +
	"\vapi_version\x18\x02 \x01(\tB\x03\xe0A\x02R\n" +
	"apiVersion\x124\n" +
	"\x04spec\x18\x03 \x01(\v2\x1b.dev.sigstore.rekor.v2.SpecB\x03\xe0A\x02R\x04spec\"\xc1\x01\n" +
	"\x04Spec\x12d\n" +
	"\x12hashed_rekord_v002\x18\x01 \x01(\v2/.dev.sigstore.rekor.v2.HashedRekordLogEntryV002B\x03\xe0A\x02H\x00R\x10hashedRekordV002\x12K\n" +
	"\tdsse_v002\x18\x02 \x01(\v2'.dev.sigstore.rekor.v2.DSSELogEntryV002B\x03\xe0A\x02H\x00R\bdsseV002B\x06\n" +
	"\x04spec\"\xeb\x01\n" +
	"\x12CreateEntryRequest\x12r\n" +
	"\x1ahashed_rekord_request_v002\x18\x01 \x01(\v2..dev.sigstore.rekor.v2.HashedRekordRequestV002B\x03\xe0A\x02H\x00R\x17hashedRekordRequestV002\x12Y\n" +
	"\x11dsse_request_v002\x18\x02 \x01(\v2&.dev.sigstore.rekor.v2.DSSERequestV002B\x03\xe0A\x02H\x00R\x0fdsseRequestV002B\x06\n" +
	"\x04specB{\n" +
	"\x1bdev.sigstore.proto.rekor.v2B\fRekorV2EntryP\x01Z6github.com/sigstore/rekor-tiles/pkg/generated/protobuf\xea\x02\x13Sigstore::Rekor::V2b\x06proto3"

var (
	file_rekor_v2_entry_proto_rawDescOnce sync.Once
	file_rekor_v2_entry_proto_rawDescData []byte
)

func file_rekor_v2_entry_proto_rawDescGZIP() []byte {
	file_rekor_v2_entry_proto_rawDescOnce.Do(func() {
		file_rekor_v2_entry_proto_rawDescData = protoimpl.X.CompressGZIP(unsafe.Slice(unsafe.StringData(file_rekor_v2_entry_proto_rawDesc), len(file_rekor_v2_entry_proto_rawDesc)))
	})
	return file_rekor_v2_entry_proto_rawDescData
}

var file_rekor_v2_entry_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_rekor_v2_entry_proto_goTypes = []any{
	(*Entry)(nil),                    // 0: dev.sigstore.rekor.v2.Entry
	(*Spec)(nil),                     // 1: dev.sigstore.rekor.v2.Spec
	(*CreateEntryRequest)(nil),       // 2: dev.sigstore.rekor.v2.CreateEntryRequest
	(*HashedRekordLogEntryV002)(nil), // 3: dev.sigstore.rekor.v2.HashedRekordLogEntryV002
	(*DSSELogEntryV002)(nil),         // 4: dev.sigstore.rekor.v2.DSSELogEntryV002
	(*HashedRekordRequestV002)(nil),  // 5: dev.sigstore.rekor.v2.HashedRekordRequestV002
	(*DSSERequestV002)(nil),          // 6: dev.sigstore.rekor.v2.DSSERequestV002
}
var file_rekor_v2_entry_proto_depIdxs = []int32{
	1, // 0: dev.sigstore.rekor.v2.Entry.spec:type_name -> dev.sigstore.rekor.v2.Spec
	3, // 1: dev.sigstore.rekor.v2.Spec.hashed_rekord_v002:type_name -> dev.sigstore.rekor.v2.HashedRekordLogEntryV002
	4, // 2: dev.sigstore.rekor.v2.Spec.dsse_v002:type_name -> dev.sigstore.rekor.v2.DSSELogEntryV002
	5, // 3: dev.sigstore.rekor.v2.CreateEntryRequest.hashed_rekord_request_v002:type_name -> dev.sigstore.rekor.v2.HashedRekordRequestV002
	6, // 4: dev.sigstore.rekor.v2.CreateEntryRequest.dsse_request_v002:type_name -> dev.sigstore.rekor.v2.DSSERequestV002
	5, // [5:5] is the sub-list for method output_type
	5, // [5:5] is the sub-list for method input_type
	5, // [5:5] is the sub-list for extension type_name
	5, // [5:5] is the sub-list for extension extendee
	0, // [0:5] is the sub-list for field type_name
}

func init() { file_rekor_v2_entry_proto_init() }
func file_rekor_v2_entry_proto_init() {
	if File_rekor_v2_entry_proto != nil {
		return
	}
	file_rekor_v2_dsse_proto_init()
	file_rekor_v2_hashedrekord_proto_init()
	file_rekor_v2_entry_proto_msgTypes[1].OneofWrappers = []any{
		(*Spec_HashedRekordV002)(nil),
		(*Spec_DsseV002)(nil),
	}
	file_rekor_v2_entry_proto_msgTypes[2].OneofWrappers = []any{
		(*CreateEntryRequest_HashedRekordRequestV002)(nil),
		(*CreateEntryRequest_DsseRequestV002)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_rekor_v2_entry_proto_rawDesc), len(file_rekor_v2_entry_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_rekor_v2_entry_proto_goTypes,
		DependencyIndexes: file_rekor_v2_entry_proto_depIdxs,
		MessageInfos:      file_rekor_v2_entry_proto_msgTypes,
	}.Build()
	File_rekor_v2_entry_proto = out.File
	file_rekor_v2_entry_proto_goTypes = nil
	file_rekor_v2_entry_proto_depIdxs = nil
}
