'use strict';

function _typeof(obj) {
  "@babel/helpers - typeof";

  return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) {
    return typeof obj;
  } : function (obj) {
    return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
  }, _typeof(obj);
}
function _classCallCheck(instance, Constructor) {
  if (!(instance instanceof Constructor)) {
    throw new TypeError("Cannot call a class as a function");
  }
}
function _defineProperties(target, props) {
  for (var i = 0; i < props.length; i++) {
    var descriptor = props[i];
    descriptor.enumerable = descriptor.enumerable || false;
    descriptor.configurable = true;
    if ("value" in descriptor) descriptor.writable = true;
    Object.defineProperty(target, _toPropertyKey(descriptor.key), descriptor);
  }
}
function _createClass(Constructor, protoProps, staticProps) {
  if (protoProps) _defineProperties(Constructor.prototype, protoProps);
  if (staticProps) _defineProperties(Constructor, staticProps);
  Object.defineProperty(Constructor, "prototype", {
    writable: false
  });
  return Constructor;
}
function _toPrimitive(input, hint) {
  if (typeof input !== "object" || input === null) return input;
  var prim = input[Symbol.toPrimitive];
  if (prim !== undefined) {
    var res = prim.call(input, hint || "default");
    if (typeof res !== "object") return res;
    throw new TypeError("@@toPrimitive must return a primitive value.");
  }
  return (hint === "string" ? String : Number)(input);
}
function _toPropertyKey(arg) {
  var key = _toPrimitive(arg, "string");
  return typeof key === "symbol" ? key : String(key);
}
function _classPrivateFieldGet(receiver, privateMap) {
  var descriptor = _classExtractFieldDescriptor(receiver, privateMap, "get");
  return _classApplyDescriptorGet(receiver, descriptor);
}
function _classPrivateFieldSet(receiver, privateMap, value) {
  var descriptor = _classExtractFieldDescriptor(receiver, privateMap, "set");
  _classApplyDescriptorSet(receiver, descriptor, value);
  return value;
}
function _classExtractFieldDescriptor(receiver, privateMap, action) {
  if (!privateMap.has(receiver)) {
    throw new TypeError("attempted to " + action + " private field on non-instance");
  }
  return privateMap.get(receiver);
}
function _classApplyDescriptorGet(receiver, descriptor) {
  if (descriptor.get) {
    return descriptor.get.call(receiver);
  }
  return descriptor.value;
}
function _classApplyDescriptorSet(receiver, descriptor, value) {
  if (descriptor.set) {
    descriptor.set.call(receiver, value);
  } else {
    if (!descriptor.writable) {
      throw new TypeError("attempted to set read only private field");
    }
    descriptor.value = value;
  }
}
function _checkPrivateRedeclaration(obj, privateCollection) {
  if (privateCollection.has(obj)) {
    throw new TypeError("Cannot initialize the same private elements twice on an object");
  }
}
function _classPrivateFieldInitSpec(obj, privateMap, value) {
  _checkPrivateRedeclaration(obj, privateMap);
  privateMap.set(obj, value);
}

var canonicalizeLocaleList = function canonicalizeLocaleList(locales) {
  if (!locales) return [];
  if (!Array.isArray(locales)) locales = [locales];
  var res = {};
  for (var i = 0; i < locales.length; ++i) {
    var _in$iw$ji$lc;
    var tag = locales[i];
    if (tag && _typeof(tag) === 'object') tag = String(tag);
    if (typeof tag !== 'string') {
      // Requiring tag to be a String or Object means that the Number value
      // NaN will not be interpreted as the language tag "nan", which stands
      // for Min Nan Chinese.
      var msg = "Locales should be strings, ".concat(JSON.stringify(tag), " isn't.");
      throw new TypeError(msg);
    }
    var parts = tag.split('-');

    // does not check for duplicate subtags
    if (!parts.every(function (subtag) {
      return /[a-z0-9]+/i.test(subtag);
    })) {
      var strTag = JSON.stringify(tag);
      var _msg = "The locale ".concat(strTag, " is not a structurally valid BCP 47 language tag.");
      throw new RangeError(_msg);
    }

    // always use lower case for primary language subtag
    var lc = parts[0].toLowerCase();
    // replace deprecated codes for Indonesian, Hebrew & Yiddish
    parts[0] = (_in$iw$ji$lc = {
      in: 'id',
      iw: 'he',
      ji: 'yi'
    }[lc]) !== null && _in$iw$ji$lc !== void 0 ? _in$iw$ji$lc : lc;
    res[parts.join('-')] = true;
  }
  return Object.keys(res);
};
function getType(opt) {
  var type = Object.prototype.hasOwnProperty.call(opt, 'type') && opt.type;
  if (!type) return 'cardinal';
  if (type === 'cardinal' || type === 'ordinal') return type;
  throw new RangeError('Not a valid plural type: ' + JSON.stringify(type));
}
function toNumber(value) {
  switch (_typeof(value)) {
    case 'number':
      return value;
    case 'bigint':
      throw new TypeError('Cannot convert a BigInt value to a number');
    default:
      return Number(value);
  }
}
function getPluralRules(NumberFormat, getSelector, getCategories, getRangeSelector) {
  var findLocale = function findLocale(locale) {
    do {
      if (getSelector(locale)) return locale;
      locale = locale.replace(/-?[^-]*$/, '');
    } while (locale);
    return null;
  };
  var resolveLocale = function resolveLocale(locales) {
    var canonicalLocales = canonicalizeLocaleList(locales);
    for (var i = 0; i < canonicalLocales.length; ++i) {
      var _lc = findLocale(canonicalLocales[i]);
      if (_lc) return _lc;
    }
    var lc = new NumberFormat().resolvedOptions().locale;
    return findLocale(lc);
  };
  var _locale = /*#__PURE__*/new WeakMap();
  var _range = /*#__PURE__*/new WeakMap();
  var _select = /*#__PURE__*/new WeakMap();
  var _type = /*#__PURE__*/new WeakMap();
  var _nf = /*#__PURE__*/new WeakMap();
  var PluralRules = /*#__PURE__*/function () {
    function PluralRules() {
      var locales = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var opt = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
      _classCallCheck(this, PluralRules);
      _classPrivateFieldInitSpec(this, _locale, {
        writable: true,
        value: void 0
      });
      _classPrivateFieldInitSpec(this, _range, {
        writable: true,
        value: void 0
      });
      _classPrivateFieldInitSpec(this, _select, {
        writable: true,
        value: void 0
      });
      _classPrivateFieldInitSpec(this, _type, {
        writable: true,
        value: void 0
      });
      _classPrivateFieldInitSpec(this, _nf, {
        writable: true,
        value: void 0
      });
      _classPrivateFieldSet(this, _locale, resolveLocale(locales));
      _classPrivateFieldSet(this, _select, getSelector(_classPrivateFieldGet(this, _locale)));
      _classPrivateFieldSet(this, _range, getRangeSelector(_classPrivateFieldGet(this, _locale)));
      _classPrivateFieldSet(this, _type, getType(opt));
      _classPrivateFieldSet(this, _nf, new NumberFormat('en', opt)); // make-plural expects latin digits with . decimal separator
    }
    _createClass(PluralRules, [{
      key: "resolvedOptions",
      value: function resolvedOptions() {
        var _classPrivateFieldGet2 = _classPrivateFieldGet(this, _nf).resolvedOptions(),
          minimumIntegerDigits = _classPrivateFieldGet2.minimumIntegerDigits,
          minimumFractionDigits = _classPrivateFieldGet2.minimumFractionDigits,
          maximumFractionDigits = _classPrivateFieldGet2.maximumFractionDigits,
          minimumSignificantDigits = _classPrivateFieldGet2.minimumSignificantDigits,
          maximumSignificantDigits = _classPrivateFieldGet2.maximumSignificantDigits,
          roundingPriority = _classPrivateFieldGet2.roundingPriority;
        var opt = {
          locale: _classPrivateFieldGet(this, _locale),
          type: _classPrivateFieldGet(this, _type),
          minimumIntegerDigits: minimumIntegerDigits,
          minimumFractionDigits: minimumFractionDigits,
          maximumFractionDigits: maximumFractionDigits
        };
        if (typeof minimumSignificantDigits === 'number') {
          opt.minimumSignificantDigits = minimumSignificantDigits;
          opt.maximumSignificantDigits = maximumSignificantDigits;
        }
        opt.pluralCategories = getCategories(_classPrivateFieldGet(this, _locale), _classPrivateFieldGet(this, _type) === 'ordinal').slice(0);
        opt.roundingPriority = roundingPriority || 'auto';
        return opt;
      }
    }, {
      key: "select",
      value: function select(number) {
        if (!(this instanceof PluralRules)) throw new TypeError("select() called on incompatible ".concat(this));
        if (typeof number !== 'number') number = Number(number);
        if (!isFinite(number)) return 'other';
        var fmt = _classPrivateFieldGet(this, _nf).format(Math.abs(number));
        return _classPrivateFieldGet(this, _select).call(this, fmt, _classPrivateFieldGet(this, _type) === 'ordinal');
      }
    }, {
      key: "selectRange",
      value: function selectRange(start, end) {
        if (!(this instanceof PluralRules)) throw new TypeError("selectRange() called on incompatible ".concat(this));
        if (start === undefined) throw new TypeError('start is undefined');
        if (end === undefined) throw new TypeError('end is undefined');
        var start_ = toNumber(start);
        var end_ = toNumber(end);
        if (!isFinite(start_)) throw new RangeError('start must be finite');
        if (!isFinite(end_)) throw new RangeError('end must be finite');
        return _classPrivateFieldGet(this, _range).call(this, this.select(start_), this.select(end_));
      }
    }], [{
      key: "supportedLocalesOf",
      value: function supportedLocalesOf(locales) {
        return canonicalizeLocaleList(locales).filter(findLocale);
      }
    }]);
    return PluralRules;
  }();
  if (typeof Symbol !== 'undefined' && Symbol.toStringTag) {
    Object.defineProperty(PluralRules.prototype, Symbol.toStringTag, {
      value: 'Intl.PluralRules',
      writable: false,
      configurable: true
    });
  }
  Object.defineProperty(PluralRules, 'prototype', {
    writable: false
  });
  return PluralRules;
}

module.exports = getPluralRules;
