/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { isObservable, of as observableOf } from 'rxjs';
import { DataSource } from './data-source';
/** DataSource wrapper for a native array. */
export class ArrayDataSource extends DataSource {
    constructor(_data) {
        super();
        this._data = _data;
    }
    connect() {
        return isObservable(this._data) ? this._data : observableOf(this._data);
    }
    disconnect() { }
}
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYXJyYXktZGF0YS1zb3VyY2UuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi8uLi9zcmMvY2RrL2NvbGxlY3Rpb25zL2FycmF5LWRhdGEtc291cmNlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7R0FNRztBQUVILE9BQU8sRUFBYSxZQUFZLEVBQUUsRUFBRSxJQUFJLFlBQVksRUFBQyxNQUFNLE1BQU0sQ0FBQztBQUNsRSxPQUFPLEVBQUMsVUFBVSxFQUFDLE1BQU0sZUFBZSxDQUFDO0FBRXpDLDZDQUE2QztBQUM3QyxNQUFNLE9BQU8sZUFBbUIsU0FBUSxVQUFhO0lBQ25ELFlBQW9CLEtBQThDO1FBQ2hFLEtBQUssRUFBRSxDQUFDO1FBRFUsVUFBSyxHQUFMLEtBQUssQ0FBeUM7SUFFbEUsQ0FBQztJQUVELE9BQU87UUFDTCxPQUFPLFlBQVksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsQ0FBQyxDQUFDLFlBQVksQ0FBQyxJQUFJLENBQUMsS0FBSyxDQUFDLENBQUM7SUFDMUUsQ0FBQztJQUVELFVBQVUsS0FBSSxDQUFDO0NBQ2hCIiwic291cmNlc0NvbnRlbnQiOlsiLyoqXG4gKiBAbGljZW5zZVxuICogQ29weXJpZ2h0IEdvb2dsZSBMTEMgQWxsIFJpZ2h0cyBSZXNlcnZlZC5cbiAqXG4gKiBVc2Ugb2YgdGhpcyBzb3VyY2UgY29kZSBpcyBnb3Zlcm5lZCBieSBhbiBNSVQtc3R5bGUgbGljZW5zZSB0aGF0IGNhbiBiZVxuICogZm91bmQgaW4gdGhlIExJQ0VOU0UgZmlsZSBhdCBodHRwczovL2FuZ3VsYXIuaW8vbGljZW5zZVxuICovXG5cbmltcG9ydCB7T2JzZXJ2YWJsZSwgaXNPYnNlcnZhYmxlLCBvZiBhcyBvYnNlcnZhYmxlT2Z9IGZyb20gJ3J4anMnO1xuaW1wb3J0IHtEYXRhU291cmNlfSBmcm9tICcuL2RhdGEtc291cmNlJztcblxuLyoqIERhdGFTb3VyY2Ugd3JhcHBlciBmb3IgYSBuYXRpdmUgYXJyYXkuICovXG5leHBvcnQgY2xhc3MgQXJyYXlEYXRhU291cmNlPFQ+IGV4dGVuZHMgRGF0YVNvdXJjZTxUPiB7XG4gIGNvbnN0cnVjdG9yKHByaXZhdGUgX2RhdGE6IHJlYWRvbmx5IFRbXSB8IE9ic2VydmFibGU8cmVhZG9ubHkgVFtdPikge1xuICAgIHN1cGVyKCk7XG4gIH1cblxuICBjb25uZWN0KCk6IE9ic2VydmFibGU8cmVhZG9ubHkgVFtdPiB7XG4gICAgcmV0dXJuIGlzT2JzZXJ2YWJsZSh0aGlzLl9kYXRhKSA/IHRoaXMuX2RhdGEgOiBvYnNlcnZhYmxlT2YodGhpcy5fZGF0YSk7XG4gIH1cblxuICBkaXNjb25uZWN0KCkge31cbn1cbiJdfQ==