import _extends from "@babel/runtime/helpers/extends";
import React, { forwardRef } from 'react';
import { useAnalyticsEvents } from '../hooks/useAnalyticsEvents';
import { usePatchedProps } from '../hooks/usePatchedProps';
var withAnalyticsEvents = function withAnalyticsEvents() {
  var createEventMap = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
  return function (WrappedComponent) {
    var WithAnalyticsEvents = /*#__PURE__*/forwardRef(function (props, ref) {
      var _usePatchedProps = usePatchedProps(createEventMap, props),
        patchedEventProps = _usePatchedProps.patchedEventProps;
      var _useAnalyticsEvents = useAnalyticsEvents(),
        createAnalyticsEvent = _useAnalyticsEvents.createAnalyticsEvent;
      return /*#__PURE__*/React.createElement(WrappedComponent, _extends({}, props, patchedEventProps, {
        createAnalyticsEvent: createAnalyticsEvent,
        ref: ref
      }));
    });
    WithAnalyticsEvents.displayName = "WithAnalyticsEvents(".concat(WrappedComponent.displayName || WrappedComponent.name, ")");
    return WithAnalyticsEvents;
  };
};
export default withAnalyticsEvents;