import { migrateEvaluationDetails, migrateSecondaryExposures } from '../utils';
// Reference: https://github.com/statsig-io/js-lite/blob/main/src/Layer.ts
export class Layer {
  static fromLayer(layer) {
    var _layer$__evaluation$s, _layer$__evaluation, _layer$__evaluation$u, _layer$__evaluation2, _layer$__evaluation3, _layer$__evaluation4;
    const value = new Layer(layer.name, layer.__value, layer.ruleID, migrateEvaluationDetails(layer.details), (_layer, parameterName) => layer.get(parameterName), migrateSecondaryExposures((_layer$__evaluation$s = (_layer$__evaluation = layer.__evaluation) === null || _layer$__evaluation === void 0 ? void 0 : _layer$__evaluation.secondary_exposures) !== null && _layer$__evaluation$s !== void 0 ? _layer$__evaluation$s : []), migrateSecondaryExposures((_layer$__evaluation$u = (_layer$__evaluation2 = layer.__evaluation) === null || _layer$__evaluation2 === void 0 ? void 0 : _layer$__evaluation2.undelegated_secondary_exposures) !== null && _layer$__evaluation$u !== void 0 ? _layer$__evaluation$u : []), (_layer$__evaluation3 = layer.__evaluation) === null || _layer$__evaluation3 === void 0 ? void 0 : _layer$__evaluation3.allocated_experiment_name, (_layer$__evaluation4 = layer.__evaluation) === null || _layer$__evaluation4 === void 0 ? void 0 : _layer$__evaluation4.explicit_parameters);
    return value;
  }

  /** @deprecated - do not use, this is still exported for backwards compatibility but will be removed in the next major version  */

  /** @deprecated - do not use, this is still exported for backwards compatibility but will be removed in the next major version  */

  constructor(name, layerValue, ruleID, evaluationDetails, logParameterFunction = null, secondaryExposures = [], undelegatedSecondaryExposures = [], allocatedExperimentName = '', explicitParameters = []) {
    this._logParameterFunction = logParameterFunction;
    this._name = name;
    this._value = JSON.parse(JSON.stringify(layerValue !== null && layerValue !== void 0 ? layerValue : {}));
    this._ruleID = ruleID !== null && ruleID !== void 0 ? ruleID : '';
    this._evaluationDetails = evaluationDetails;
    this._secondaryExposures = secondaryExposures;
    this._undelegatedSecondaryExposures = undelegatedSecondaryExposures;
    this._allocatedExperimentName = allocatedExperimentName;
    this._explicitParameters = explicitParameters;
  }
  get(key, defaultValue, typeGuard) {
    const val = this._value[key];
    if (val == null) {
      return defaultValue;
    }
    const logAndReturn = () => {
      this._logLayerParameterExposure(key);
      return val;
    };
    if (typeGuard) {
      return typeGuard(val) ? logAndReturn() : defaultValue;
    }
    if (defaultValue == null) {
      return logAndReturn();
    }
    if (typeof val === typeof defaultValue && Array.isArray(defaultValue) === Array.isArray(val)) {
      return logAndReturn();
    }
    return defaultValue;
  }
  getValue(key, defaultValue) {
    // eslint-disable-next-line eqeqeq
    if (defaultValue == undefined) {
      defaultValue = null;
    }
    const val = this._value[key];
    if (val != null) {
      this._logLayerParameterExposure(key);
    }
    return val !== null && val !== void 0 ? val : defaultValue;
  }
  _logLayerParameterExposure(parameterName) {
    var _this$_logParameterFu;
    (_this$_logParameterFu = this._logParameterFunction) === null || _this$_logParameterFu === void 0 ? void 0 : _this$_logParameterFu.call(this, this, parameterName);
  }
}