import React, { createContext, useContext, useMemo } from 'react';
import { rbdInvariant } from './rbd-invariant';
const DragDropContext = /*#__PURE__*/createContext(null);
export function useDragDropContext() {
  const value = useContext(DragDropContext);
  rbdInvariant(value !== null, 'Unable to find DragDropContext context');
  return value;
}
export function DragDropContextProvider({
  children,
  contextId,
  getDragState,
  startKeyboardDrag,
  droppableRegistry
}) {
  const value = useMemo(() => {
    return {
      contextId,
      getDragState,
      startKeyboardDrag,
      droppableRegistry
    };
  }, [contextId, getDragState, startKeyboardDrag, droppableRegistry]);
  return /*#__PURE__*/React.createElement(DragDropContext.Provider, {
    value: value
  }, children);
}