/*
 * Decompiled with CFR 0.152.
 */
package net.sf.launch4j.binding;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTextArea;
import net.sf.launch4j.binding.Binding;
import net.sf.launch4j.binding.BindingException;
import net.sf.launch4j.binding.IValidatable;
import org.apache.commons.beanutils.PropertyUtils;

public class JTextAreaBinding
implements Binding {
    private final String _property;
    private final JTextArea _textArea;
    private final Color _validColor;

    public JTextAreaBinding(String property, JTextArea textArea) {
        if (property == null || textArea == null) {
            throw new NullPointerException();
        }
        if (property.equals("")) {
            throw new IllegalArgumentException();
        }
        this._property = property;
        this._textArea = textArea;
        this._validColor = this._textArea.getBackground();
    }

    public String getProperty() {
        return this._property;
    }

    public void clear(IValidatable bean) {
        this.put(bean);
    }

    public void put(IValidatable bean) {
        try {
            List list = (List)PropertyUtils.getProperty(bean, this._property);
            StringBuffer sb = new StringBuffer();
            if (list != null) {
                for (int i = 0; i < list.size(); ++i) {
                    sb.append(list.get(i));
                    if (i >= list.size() - 1) continue;
                    sb.append("\n");
                }
            }
            this._textArea.setText(sb.toString());
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    public void get(IValidatable bean) {
        try {
            String text = this._textArea.getText();
            if (!text.equals("")) {
                String[] items = text.split("\n");
                ArrayList<String> list = new ArrayList<String>();
                for (int i = 0; i < items.length; ++i) {
                    list.add(items[i]);
                }
                PropertyUtils.setProperty(bean, this._property, list);
            } else {
                PropertyUtils.setProperty(bean, this._property, null);
            }
        }
        catch (Exception e) {
            throw new BindingException(e);
        }
    }

    public void markValid() {
        this._textArea.setBackground(this._validColor);
        this._textArea.requestFocusInWindow();
    }

    public void markInvalid() {
        this._textArea.setBackground(Binding.INVALID_COLOR);
    }

    public void setEnabled(boolean enabled) {
        this._textArea.setEnabled(enabled);
    }
}

