// generated by diplomat-tool
import type { CollatorOptions } from "./CollatorOptions"
import type { CollatorOptions_obj } from "./CollatorOptions"
import type { CollatorResolvedOptions } from "./CollatorResolvedOptions"
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { Locale } from "./Locale"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * See the [Rust documentation for `Collator`](https://docs.rs/icu/latest/icu/collator/struct.Collator.html) for more information.
 */


export class Collator {
    get ffiValue(): pointer;


    /**
     * Construct a new Collator instance using compiled data.
     *
     * See the [Rust documentation for `try_new`](https://docs.rs/icu/latest/icu/collator/struct.Collator.html#method.try_new) for more information.
     */
    static create(locale: Locale, options: CollatorOptions_obj): Collator;

    /**
     * Compare two strings.
     *
     * Ill-formed input is treated as if errors had been replaced with REPLACEMENT CHARACTERs according
     * to the WHATWG Encoding Standard.
     *
     * See the [Rust documentation for `compare_utf16`](https://docs.rs/icu/latest/icu/collator/struct.CollatorBorrowed.html#method.compare_utf16) for more information.
     */
    compare(left: string, right: string): number;

    /**
     * The resolved options showing how the default options, the requested options,
     * and the options from locale data were combined. None of the struct fields
     * will have `Auto` as the value.
     *
     * See the [Rust documentation for `resolved_options`](https://docs.rs/icu/latest/icu/collator/struct.CollatorBorrowed.html#method.resolved_options) for more information.
     */
    get resolvedOptions(): CollatorResolvedOptions;

    constructor(provider: DataProvider, locale: Locale, options: CollatorOptions_obj);
}