<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/health/notifications/smseagle/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/health/notifications/smseagle/metadata.yaml"
sidebar_label: "SMSEagle"
learn_status: "Published"
learn_rel_path: "Alerts & Notifications/Notifications/Agent Dispatched Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# SMSEagle


<img src="https://netdata.cloud/img/smseagle.svg" width="150"/>


Forward notifications to SMSEagle device to send SMS, MMS, wake-up, or text-to-speech calls.



<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup

### Prerequisites

#### 

Before using the API, you'll need to enable API access on your SMSEagle device by following these steps:

1. Navigate to the Web-GUI and select the "Users" menu.
2. Create a new user account with "User" access level.
3. Locate the "Access to API" option next to your newly created user.
4. Select APIv2 and click the "Generate new token" button to create your API access token.
5. Set up the appropriate permissions in the APIv2 Permission section.

Optional: Enable the "Access to resources of all users" checkbox if you want this API key to access data across all users. By default, the API key can only access data created under its credentials.



### Configuration

#### File

The configuration file name for this integration is `health_alarm_notify.conf`.


You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config health_alarm_notify.conf
```
#### Options

The following options can be defined for this notification

<details open><summary>Config Options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| DEFAULT_RECIPIENT_SMSEAGLE | If a role's recipients are not configured, a notification will be sent to this SMS recipient (empty = do not send a notification for unconfigured roles). Multiple recipients can be given like this: "PHONE1,PHONE2..." |  | yes |
| SMSEAGLE_API_URL |  |  | yes |
| SMSEAGLE_API_ACCESSTOKEN |  |  | yes |
| SMSEAGLE_MSG_TYPE |  | sms | yes |
| SMSEAGLE_CALL_DURATION |  | 10 | yes |
| SMSEAGLE_VOICE_ID |  | 10 | yes |

##### DEFAULT_RECIPIENT_SMSEAGLE

All roles will default to this variable if left unconfigured.

You can then have different recipients per role, by editing `DEFAULT_RECIPIENT_SMSEAGLE` with the number you want, in the following entries at the bottom of the same file:
```
role_recipients_smseagle[sysadmin]="+11222333444"
role_recipients_smseagle[domainadmin]="+11222333445"
role_recipients_smseagle[dba]="+11222333446"
role_recipients_smseagle[webmaster]="+11222333447"
role_recipients_smseagle[proxyadmin]="+11222333448"
role_recipients_smseagle[sitemgr]="+11222333449"
```


##### SMSEAGLE_API_URL

The url of the SMSEagle device accessible from NetData, e.g https://192.168.0.101


##### SMSEAGLE_API_ACCESSTOKEN

An access token for the user created at SMSEagle device


##### SMSEAGLE_MSG_TYPE

Choose a type of message/call. Available types: sms, mms, ring (wake-up call), tts (text-to-speech call), tts_advanced (multilanguage text-to-speech call). Be aware that some types require additional parameters to be set.


##### SMSEAGLE_CALL_DURATION

Call duration, parameter required for Ring, TTS and TTS Advanced.


##### SMSEAGLE_VOICE_ID

ID of the voice model, required for TTS Advanced.


</details>

#### Examples

##### Basic Configuration



```yaml
#------------------------------------------------------------------------------
# SMSEagle options

SEND_SMSEAGLE="YES"
SMSEAGLE_API_URL="XXXXXXXX"
SMSEAGLE_API_ACCESSTOKEN="XXXXXXX"
SMSEAGLE_MSG_TYPE="sms"
SMSEAGLE_CALL_DURATION="10"
SMSEAGLE_VOICE_ID="1"
DEFAULT_RECIPIENT_SMSEAGLE="+11222333444"

```


## Troubleshooting

### Test Notification

You can run the following command by hand, to test alerts configuration:

```bash
# become user netdata
sudo su -s /bin/bash netdata

# enable debugging info on the console
export NETDATA_ALARM_NOTIFY_DEBUG=1

# send test alarms to sysadmin
/usr/libexec/netdata/plugins.d/alarm-notify.sh test

# send test alarms to any role
/usr/libexec/netdata/plugins.d/alarm-notify.sh test "ROLE"
```

Note that this will test _all_ alert mechanisms for the selected role.


