﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock/model/AutomatedReasoningPolicyUpdateVariableAnnotation.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Utils::Json;
using namespace Aws::Utils;

namespace Aws {
namespace Bedrock {
namespace Model {

AutomatedReasoningPolicyUpdateVariableAnnotation::AutomatedReasoningPolicyUpdateVariableAnnotation(JsonView jsonValue) {
  *this = jsonValue;
}

AutomatedReasoningPolicyUpdateVariableAnnotation& AutomatedReasoningPolicyUpdateVariableAnnotation::operator=(JsonView jsonValue) {
  if (jsonValue.ValueExists("name")) {
    m_name = jsonValue.GetString("name");
    m_nameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("newName")) {
    m_newName = jsonValue.GetString("newName");
    m_newNameHasBeenSet = true;
  }
  if (jsonValue.ValueExists("description")) {
    m_description = jsonValue.GetString("description");
    m_descriptionHasBeenSet = true;
  }
  return *this;
}

JsonValue AutomatedReasoningPolicyUpdateVariableAnnotation::Jsonize() const {
  JsonValue payload;

  if (m_nameHasBeenSet) {
    payload.WithString("name", m_name);
  }

  if (m_newNameHasBeenSet) {
    payload.WithString("newName", m_newName);
  }

  if (m_descriptionHasBeenSet) {
    payload.WithString("description", m_description);
  }

  return payload;
}

}  // namespace Model
}  // namespace Bedrock
}  // namespace Aws
