﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/SearchWorkspaceAssociationsResult.h>
#include <aws/core/AmazonWebServiceResult.h>
#include <aws/core/utils/StringUtils.h>
#include <aws/core/utils/UnreferencedParam.h>
#include <aws/core/utils/json/JsonSerializer.h>
#include <aws/core/utils/memory/stl/AWSStringStream.h>

#include <utility>

using namespace Aws::Connect::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;
using namespace Aws;

SearchWorkspaceAssociationsResult::SearchWorkspaceAssociationsResult(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  *this = result;
}

SearchWorkspaceAssociationsResult& SearchWorkspaceAssociationsResult::operator=(const Aws::AmazonWebServiceResult<JsonValue>& result) {
  JsonView jsonValue = result.GetPayload().View();
  if (jsonValue.ValueExists("NextToken")) {
    m_nextToken = jsonValue.GetString("NextToken");
    m_nextTokenHasBeenSet = true;
  }
  if (jsonValue.ValueExists("WorkspaceAssociations")) {
    Aws::Utils::Array<JsonView> workspaceAssociationsJsonList = jsonValue.GetArray("WorkspaceAssociations");
    for (unsigned workspaceAssociationsIndex = 0; workspaceAssociationsIndex < workspaceAssociationsJsonList.GetLength();
         ++workspaceAssociationsIndex) {
      m_workspaceAssociations.push_back(workspaceAssociationsJsonList[workspaceAssociationsIndex].AsObject());
    }
    m_workspaceAssociationsHasBeenSet = true;
  }
  if (jsonValue.ValueExists("ApproximateTotalCount")) {
    m_approximateTotalCount = jsonValue.GetInt64("ApproximateTotalCount");
    m_approximateTotalCountHasBeenSet = true;
  }

  const auto& headers = result.GetHeaderValueCollection();
  const auto& requestIdIter = headers.find("x-amzn-requestid");
  if (requestIdIter != headers.end()) {
    m_requestId = requestIdIter->second;
    m_requestIdHasBeenSet = true;
  }

  return *this;
}
