﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/connect/model/StartContactMediaProcessingRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::Connect::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String StartContactMediaProcessingRequest::SerializePayload() const {
  JsonValue payload;

  if (m_instanceIdHasBeenSet) {
    payload.WithString("InstanceId", m_instanceId);
  }

  if (m_contactIdHasBeenSet) {
    payload.WithString("ContactId", m_contactId);
  }

  if (m_processorArnHasBeenSet) {
    payload.WithString("ProcessorArn", m_processorArn);
  }

  if (m_failureModeHasBeenSet) {
    payload.WithString("FailureMode", ContactMediaProcessingFailureModeMapper::GetNameForContactMediaProcessingFailureMode(m_failureMode));
  }

  return payload.View().WriteReadable();
}
