/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.layout;

import org.netbeans.api.visual.graph.GraphPinScene;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.layout.Layout;
import org.netbeans.api.visual.layout.SceneLayout;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.layout.AbsoluteLayout;
import org.netbeans.modules.visual.layout.CardLayout;
import org.netbeans.modules.visual.layout.DevolveWidgetLayout;
import org.netbeans.modules.visual.layout.FlowLayout;
import org.netbeans.modules.visual.layout.OverlayLayout;
import org.netbeans.modules.visual.util.GeomUtil;

public final class LayoutFactory {
    private static final AbsoluteLayout LAYOUT_ABSOLUTE = new AbsoluteLayout();
    private static final OverlayLayout LAYOUT_OVERLAY = new OverlayLayout();

    private LayoutFactory() {
    }

    public static Layout createAbsoluteLayout() {
        return LAYOUT_ABSOLUTE;
    }

    @Deprecated
    public static Layout createVerticalLayout() {
        GeomUtil.LOG.warning("LayoutFactory.createVerticalLayout() method is deprecated. Use LayoutFactory.createVerticalFlowLayout() method instead.");
        return LayoutFactory.createVerticalFlowLayout(null, 0);
    }

    @Deprecated
    public static Layout createVerticalLayout(SerialAlignment serialAlignment, int n) {
        GeomUtil.LOG.warning("LayoutFactory.createVerticalLayout(alignment,gap) method is deprecated. Use LayoutFactory.createVerticalFlowLayout(alignment,gap) method instead.");
        return new FlowLayout(true, serialAlignment != null ? serialAlignment : SerialAlignment.JUSTIFY, n);
    }

    public static Layout createVerticalFlowLayout() {
        return LayoutFactory.createVerticalFlowLayout(null, 0);
    }

    public static Layout createVerticalFlowLayout(SerialAlignment serialAlignment, int n) {
        return new FlowLayout(true, serialAlignment != null ? serialAlignment : SerialAlignment.JUSTIFY, n);
    }

    @Deprecated
    public static Layout createHorizontalLayout() {
        GeomUtil.LOG.warning("LayoutFactory.createHorizontalLayout() method is deprecated. Use LayoutFactory.createHorizontalFlowLayout() method instead.");
        return LayoutFactory.createHorizontalFlowLayout(null, 0);
    }

    @Deprecated
    public static Layout createHorizontalLayout(SerialAlignment serialAlignment, int n) {
        GeomUtil.LOG.warning("LayoutFactory.createHorizontalLayout(alignment,gap) method is deprecated. Use LayoutFactory.createHorizontalFlowLayout(alignment,gap) method instead.");
        return new FlowLayout(false, serialAlignment != null ? serialAlignment : SerialAlignment.JUSTIFY, n);
    }

    public static Layout createHorizontalFlowLayout() {
        return LayoutFactory.createHorizontalFlowLayout(null, 0);
    }

    public static Layout createHorizontalFlowLayout(SerialAlignment serialAlignment, int n) {
        return new FlowLayout(false, serialAlignment != null ? serialAlignment : SerialAlignment.JUSTIFY, n);
    }

    public static Layout createCardLayout(Widget widget) {
        assert (widget != null);
        return new CardLayout(widget);
    }

    public static Widget getActiveCard(Widget widget) {
        Layout layout = widget.getLayout();
        return layout instanceof CardLayout ? ((CardLayout)layout).getActiveChildWidget() : null;
    }

    public static void setActiveCard(Widget widget, Widget widget2) {
        Layout layout = widget.getLayout();
        if (layout instanceof CardLayout) {
            ((CardLayout)layout).setActiveChildWidget(widget2);
        }
    }

    @Deprecated
    public static Layout createFillLayout() {
        GeomUtil.LOG.warning("LayoutFactory.createFillLayout() method is deprecated. Use LayoutFactory.createOverlayLayout() method instead.");
        return LayoutFactory.createOverlayLayout();
    }

    public static Layout createOverlayLayout() {
        return LAYOUT_OVERLAY;
    }

    public static SceneLayout createDevolveWidgetLayout(Widget widget, Layout layout, boolean bl) {
        return new DevolveWidgetLayout(widget, layout, bl);
    }

    public static <N, E> SceneLayout createSceneGraphLayout(final GraphScene<N, E> graphScene, final GraphLayout<N, E> graphLayout) {
        assert (graphScene != null && graphLayout != null);
        return new SceneLayout(graphScene){

            @Override
            protected void performLayout() {
                graphLayout.layoutGraph(graphScene);
            }
        };
    }

    public static <N, E> SceneLayout createSceneGraphLayout(final GraphPinScene<N, E, ?> graphPinScene, final GraphLayout<N, E> graphLayout) {
        assert (graphPinScene != null && graphLayout != null);
        return new SceneLayout(graphPinScene){

            @Override
            protected void performLayout() {
                graphLayout.layoutGraph(graphPinScene);
            }
        };
    }

    public static enum ConnectionWidgetLayoutAlignment {
        NONE,
        CENTER,
        TOP_CENTER,
        BOTTOM_CENTER,
        CENTER_LEFT,
        CENTER_RIGHT,
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        CENTER_SOURCE,
        CENTER_TARGET,
        BOTTOM_SOURCE,
        BOTTOM_TARGET,
        TOP_SOURCE,
        TOP_TARGET;

    }

    public static enum SerialAlignment {
        LEFT_TOP,
        CENTER,
        RIGHT_BOTTOM,
        JUSTIFY;

    }
}

