/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.bindex.ant;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.osgi.impl.bundle.obr.resource.BundleInfo;
import org.osgi.impl.bundle.obr.resource.RepositoryImpl;
import org.osgi.impl.bundle.obr.resource.ResourceImpl;
import org.osgi.impl.bundle.obr.resource.Tag;

public class BindexTask
extends Task {
    File repositoryFile;
    String license;
    boolean quiet = false;
    String name = "Untitled";
    String urlTemplate = null;
    File rootFile = new File("").getAbsoluteFile();
    List filesets = new LinkedList();
    RepositoryImpl repository;
    String root;
    Set resources = new HashSet();

    public void setLicenseURL(String license) {
        this.license = license;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public void setRepositoryFile(File repositoryFile) {
        this.repositoryFile = repositoryFile;
    }

    public void setRoot(File rootFile) {
        this.rootFile = rootFile;
    }

    public void setUrlTemplate(String urlTemplate) {
        this.urlTemplate = urlTemplate;
    }

    public void addFileset(FileSet fs) {
        this.filesets.add(fs);
    }

    public void execute() throws BuildException {
        try {
            System.err.println("Bundle Indexer | v2.0");
            System.err.println("(c) 2005 OSGi, All Rights Reserved");
            try {
                this.root = this.rootFile.toURL().toString();
            }
            catch (Exception e) {
                throw new BuildException(e + " for rootFile");
            }
            try {
                this.repository = new RepositoryImpl(this.rootFile.toURL());
            }
            catch (Exception e) {
                throw new BuildException(e + " for repo");
            }
            Iterator it = this.filesets.iterator();
            while (it.hasNext()) {
                FileSet fs = (FileSet)it.next();
                DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
                File basedir = ds.getBasedir();
                String[] files = ds.getIncludedFiles();
                int i = 0;
                while (i < files.length) {
                    try {
                        this.recurse(this.resources, new File(basedir, files[i]));
                    }
                    catch (Exception e) {
                        throw new BuildException((Throwable)e);
                    }
                    ++i;
                }
            }
            ArrayList sorted = new ArrayList(this.resources);
            Collections.sort(sorted, new Comparator(){

                public int compare(Object r1, Object r2) {
                    String s1 = BindexTask.this.getName((ResourceImpl)r1);
                    String s2 = BindexTask.this.getName((ResourceImpl)r2);
                    return s1.compareTo(s2);
                }
            });
            Tag tag = this.doIndex(sorted);
            if (this.repositoryFile != null) {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                tag.print(0, pw);
                pw.close();
                byte[] buffer = out.toByteArray();
                String name = "repository.xml";
                FileOutputStream fout = new FileOutputStream(this.repositoryFile);
                if (this.repositoryFile.getAbsolutePath().endsWith(".zip")) {
                    ZipOutputStream zip = new ZipOutputStream(fout);
                    CRC32 checksum = new CRC32();
                    checksum.update(buffer);
                    ZipEntry ze = new ZipEntry(name);
                    ze.setSize(buffer.length);
                    ze.setCrc(checksum.getValue());
                    zip.putNextEntry(ze);
                    zip.write(buffer, 0, buffer.length);
                    zip.closeEntry();
                    zip.close();
                } else {
                    fout.write(buffer);
                }
                fout.close();
            }
            if (!this.quiet) {
                PrintWriter pw = new PrintWriter(new OutputStreamWriter(System.out));
                tag.print(0, pw);
                pw.close();
            }
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    String getName(ResourceImpl impl) {
        String s = impl.getSymbolicName();
        if (s != null) {
            return s;
        }
        return "no-symbolic-name";
    }

    void recurse(Set resources, File path) throws Exception {
        if (path.isDirectory()) {
            String[] list = path.list();
            int i = 0;
            while (i < list.length) {
                this.recurse(resources, new File(path, list[i]));
                ++i;
            }
        } else if (path.getName().endsWith(".jar")) {
            this.log("process " + path + " ...");
            BundleInfo info = new BundleInfo(this.repository, path);
            ResourceImpl resource = info.build();
            if (this.urlTemplate != null) {
                this.doTemplate(path, resource);
            } else {
                resource.setURL(path.toURL());
            }
            resources.add(resource);
        }
    }

    void doTemplate(File path, ResourceImpl resource) throws MalformedURLException {
        String dir = path.getParentFile().getAbsoluteFile().toURL().toString();
        if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if (dir.startsWith(this.root)) {
            dir = dir.substring(this.root.length());
        }
        String url = this.urlTemplate.replaceAll("%v", "" + resource.getVersion());
        url = url.replaceAll("%s", resource.getSymbolicName());
        url = url.replaceAll("%f", path.getName());
        url = url.replaceAll("%p", dir);
        resource.setURL(new URL(url));
    }

    Tag doIndex(Collection resources) throws IOException {
        Tag repository = new Tag("repository");
        repository.addAttribute("lastmodified", new Date());
        repository.addAttribute("name", this.name);
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            ResourceImpl resource = (ResourceImpl)i.next();
            repository.addContent(resource.toXML());
        }
        return repository;
    }

    void addToZip(ZipOutputStream zip, String name, InputStream actual) throws IOException {
        byte[] buffer = this.readAll(actual, 0);
        actual.close();
        CRC32 checksum = new CRC32();
        checksum.update(buffer);
        ZipEntry ze = new ZipEntry(name);
        ze.setSize(buffer.length);
        ze.setCrc(checksum.getValue());
        zip.putNextEntry(ze);
        zip.write(buffer, 0, buffer.length);
        zip.closeEntry();
    }

    byte[] readAll(InputStream in, int offset) throws IOException {
        byte[] temp = new byte[4096];
        int size = in.read(temp, 0, temp.length);
        if (size <= 0) {
            return new byte[offset];
        }
        byte[] result = this.readAll(in, offset + size);
        System.arraycopy(temp, 0, result, offset, size);
        return result;
    }
}

