﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#include <aws/bedrock-agent-runtime/model/RerankRequest.h>
#include <aws/core/utils/json/JsonSerializer.h>

#include <utility>

using namespace Aws::BedrockAgentRuntime::Model;
using namespace Aws::Utils::Json;
using namespace Aws::Utils;

Aws::String RerankRequest::SerializePayload() const {
  JsonValue payload;

  if (m_queriesHasBeenSet) {
    Aws::Utils::Array<JsonValue> queriesJsonList(m_queries.size());
    for (unsigned queriesIndex = 0; queriesIndex < queriesJsonList.GetLength(); ++queriesIndex) {
      queriesJsonList[queriesIndex].AsObject(m_queries[queriesIndex].Jsonize());
    }
    payload.WithArray("queries", std::move(queriesJsonList));
  }

  if (m_sourcesHasBeenSet) {
    Aws::Utils::Array<JsonValue> sourcesJsonList(m_sources.size());
    for (unsigned sourcesIndex = 0; sourcesIndex < sourcesJsonList.GetLength(); ++sourcesIndex) {
      sourcesJsonList[sourcesIndex].AsObject(m_sources[sourcesIndex].Jsonize());
    }
    payload.WithArray("sources", std::move(sourcesJsonList));
  }

  if (m_rerankingConfigurationHasBeenSet) {
    payload.WithObject("rerankingConfiguration", m_rerankingConfiguration.Jsonize());
  }

  if (m_nextTokenHasBeenSet) {
    payload.WithString("nextToken", m_nextToken);
  }

  return payload.View().WriteReadable();
}
