/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.declarativedsl.parsing;

import java.util.ArrayList;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.gradle.internal.declarativedsl.analysis.DeclarativeDslInterpretationExceptionKt;
import org.gradle.internal.declarativedsl.parsing.LightTreeUtilKt;
import org.gradle.internal.declarativedsl.parsing.ParsedLightTree;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.lang.LighterASTNode;
import org.jetbrains.kotlin.com.intellij.lang.ParserDefinition;
import org.jetbrains.kotlin.com.intellij.lang.PsiBuilder;
import org.jetbrains.kotlin.com.intellij.lang.impl.PsiBuilderFactoryImpl;
import org.jetbrains.kotlin.com.intellij.lexer.Lexer;
import org.jetbrains.kotlin.com.intellij.util.diff.FlyweightCapableTreeStructure;
import org.jetbrains.kotlin.lexer.KotlinLexer;
import org.jetbrains.kotlin.parsing.KotlinLightParser;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u001a\u0010\u0010\u000b\u001a\u00020\f2\b\b\u0001\u0010\r\u001a\u00020\u000e\u001a\u0006\u0010\u000f\u001a\u00020\u0010\u001a$\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\b\b\u0001\u0010\r\u001a\u00020\u000eH\u0002\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\"\u001b\u0010\u0006\u001a\u00020\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u0005\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0014"}, d2={"parserDefinition", "Lorg/jetbrains/kotlin/parsing/KotlinParserDefinition;", "getParserDefinition", "()Lorg/jetbrains/kotlin/parsing/KotlinParserDefinition;", "parserDefinition$delegate", "Lkotlin/Lazy;", "psiBuilderFactory", "Lorg/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl;", "getPsiBuilderFactory", "()Lorg/jetbrains/kotlin/com/intellij/lang/impl/PsiBuilderFactoryImpl;", "psiBuilderFactory$delegate", "parse", "Lorg/gradle/internal/declarativedsl/parsing/ParsedLightTree;", "code", "", "main", "", "wrapScriptIntoClassInitializerBlock", "Lkotlin/Triple;", "", "declarative-dsl-core"})
@SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\norg/gradle/internal/declarativedsl/parsing/ParserKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,99:1\n1869#2,2:100\n*S KotlinDebug\n*F\n+ 1 Parser.kt\norg/gradle/internal/declarativedsl/parsing/ParserKt\n*L\n60#1:100,2\n*E\n"})
public final class ParserKt {
    @NotNull
    private static final Lazy parserDefinition$delegate = LazyKt.lazy(ParserKt::parserDefinition_delegate$lambda$0);
    @NotNull
    private static final Lazy psiBuilderFactory$delegate = LazyKt.lazy(ParserKt::psiBuilderFactory_delegate$lambda$1);

    private static final KotlinParserDefinition getParserDefinition() {
        Lazy lazy = parserDefinition$delegate;
        return (KotlinParserDefinition)lazy.getValue();
    }

    private static final PsiBuilderFactoryImpl getPsiBuilderFactory() {
        Lazy lazy = psiBuilderFactory$delegate;
        return (PsiBuilderFactoryImpl)lazy.getValue();
    }

    @NotNull
    public static final ParsedLightTree parse(@Language(value="dcl") @NotNull String code) {
        Intrinsics.checkNotNullParameter((Object)code, (String)"code");
        Triple<String, Integer, Integer> triple = ParserKt.wrapScriptIntoClassInitializerBlock(code);
        String wrappedCode = (String)triple.component1();
        int codeOffset = ((Number)triple.component2()).intValue();
        int suffixLength = ((Number)triple.component3()).intValue();
        KotlinLexer lexer = new KotlinLexer();
        FlyweightCapableTreeStructure flyweightCapableTreeStructure = KotlinLightParser.parse((PsiBuilder)ParserKt.getPsiBuilderFactory().createBuilder((ParserDefinition)ParserKt.getParserDefinition(), (Lexer)lexer, (CharSequence)wrappedCode));
        Intrinsics.checkNotNullExpressionValue((Object)flyweightCapableTreeStructure, (String)"parse(...)");
        return new ParsedLightTree((FlyweightCapableTreeStructure<LighterASTNode>)flyweightCapableTreeStructure, wrappedCode, codeOffset, suffixLength);
    }

    public static final void main() {
        LightTreeUtilKt.print$default(ParserKt.parse("    #!/usr/bin/env kscript\na = 1").getLightTree(), null, null, 3, null);
    }

    private static final Triple<String, Integer, Integer> wrapScriptIntoClassInitializerBlock(@Language(value="dcl") String code) {
        List packageStatements = new ArrayList();
        List importStatements = new ArrayList();
        List codeStatements = new ArrayList();
        boolean isAfterImportLine = false;
        Iterable $this$forEach$iv = StringsKt.lines((CharSequence)code);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String line = (String)element$iv;
            boolean bl = false;
            if (StringsKt.startsWith$default((String)line, (String)"import", (boolean)false, (int)2, null)) {
                importStatements.add(line);
                isAfterImportLine = true;
                continue;
            }
            if (StringsKt.startsWith$default((String)line, (String)"package", (boolean)false, (int)2, null)) {
                packageStatements.add(line);
                isAfterImportLine = false;
                continue;
            }
            if (StringsKt.isBlank((CharSequence)line)) {
                if (isAfterImportLine) continue;
                codeStatements.add(line);
                continue;
            }
            codeStatements.add(line);
            isAfterImportLine = false;
        }
        if (packageStatements.size() > 2) {
            DeclarativeDslInterpretationExceptionKt.interpretationFailure("Multiple package statements in " + code);
            throw new KotlinNothingValueException();
        }
        String packageSection = CollectionsKt.joinToString$default((Iterable)packageStatements, (CharSequence)"", null, null, (int)0, null, ParserKt::wrapScriptIntoClassInitializerBlock$lambda$3, (int)30, null);
        String importSection = CollectionsKt.joinToString$default((Iterable)importStatements, (CharSequence)"", null, null, (int)0, null, ParserKt::wrapScriptIntoClassInitializerBlock$lambda$4, (int)30, null);
        String codeSection = CollectionsKt.joinToString$default((Iterable)codeStatements, (CharSequence)"", null, null, (int)0, null, ParserKt::wrapScriptIntoClassInitializerBlock$lambda$5, (int)30, null);
        String prefix = packageSection + importSection + "class Script {init {";
        String suffix = "}}";
        int codeOffset = prefix.length();
        return new Triple((Object)(prefix + codeSection + suffix), (Object)codeOffset, (Object)suffix.length());
    }

    public static /* synthetic */ void main(String[] args) {
        ParserKt.main();
    }

    private static final KotlinParserDefinition parserDefinition_delegate$lambda$0() {
        return new KotlinParserDefinition();
    }

    private static final PsiBuilderFactoryImpl psiBuilderFactory_delegate$lambda$1() {
        return new PsiBuilderFactoryImpl();
    }

    private static final String wrapScriptIntoClassInitializerBlock$addNewlineIfNotBlank(String it) {
        return !StringsKt.isBlank((CharSequence)it) ? it + '\n' : it;
    }

    private static final CharSequence wrapScriptIntoClassInitializerBlock$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ParserKt.wrapScriptIntoClassInitializerBlock$addNewlineIfNotBlank(it);
    }

    private static final CharSequence wrapScriptIntoClassInitializerBlock$lambda$4(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return ParserKt.wrapScriptIntoClassInitializerBlock$addNewlineIfNotBlank(it);
    }

    private static final CharSequence wrapScriptIntoClassInitializerBlock$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it + '\n';
    }
}

