# Generated by Django 3.2.16 on 2022-11-19 22:51

from django.db import migrations, models
from django.conf import settings
import logging

logger = logging.getLogger(__name__)


def migrate_notify_sla_from_settings_file(apps, schema_editor):

    if hasattr(settings, 'SLA_NOTIFY_ACTIVE'):
        system_settings_model = apps.get_model('dojo', 'System_Settings')
        logger.info('Migrating value from SLA_NOTIFY_ACTIVE into system settings model')
        try:
            system_setting = system_settings_model.objects.get()
            system_setting.enable_notify_sla_active = settings.SLA_NOTIFY_ACTIVE
            system_setting.save()
        except:
            # for a clean installation there is no system_settings record, so just ignore it
            pass

    if hasattr(settings, 'SLA_NOTIFY_ACTIVE_VERIFIED_ONLY'):
        system_settings_model = apps.get_model('dojo', 'System_Settings')
        logger.info('Migrating value from SLA_NOTIFY_ACTIVE_VERIFIED_ONLY into system settings model')
        try:
            system_setting = system_settings_model.objects.get()
            system_setting.enable_notify_sla_active_verified = settings.SLA_NOTIFY_ACTIVE_VERIFIED_ONLY
            system_setting.save()
        except:
            # for a clean installation there is no system_settings record, so just ignore it
            pass

    if hasattr(settings, 'SLA_NOTIFY_WITH_JIRA_ONLY'):
        system_settings_model = apps.get_model('dojo', 'System_Settings')
        logger.info('Migrating value from SLA_NOTIFY_WITH_JIRA_ONLY into system settings model')
        try:
            system_setting = system_settings_model.objects.get()
            system_setting.enable_notify_sla_jira_only = settings.SLA_NOTIFY_WITH_JIRA_ONLY
            system_setting.save()
        except:
            # for a clean installation there is no system_settings record, so just ignore it
            pass


class Migration(migrations.Migration):

    dependencies = [
        ('dojo', '0174_jira_project_default_assignee'),
    ]

    operations = [
        migrations.AddField(
            model_name='system_settings',
            name='enable_notify_sla_active',
            field=models.BooleanField(default=False, help_text="Enables Notify when time to remediate according to Finding SLA's is breached for active Findings.", verbose_name="Enable Notifiy SLA's Breach for active Findings"),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='enable_notify_sla_active_verified',
            field=models.BooleanField(default=False, help_text="Enables Notify when time to remediate according to Finding SLA's is breached for active, verified Findings.", verbose_name="Enable Notifiy SLA's Breach for active, verified Findings"),
        ),
        migrations.AddField(
            model_name='system_settings',
            name='enable_notify_sla_jira_only',
            field=models.BooleanField(default=False, help_text="Enables Notify when time to remediate according to Finding SLA's is breached for Findings that are linked to JIRA issues.", verbose_name="Enable Notifiy SLA's Breach for Findings linked to JIRA"),
        ),
        migrations.RunPython(migrate_notify_sla_from_settings_file),
    ]
