// model-body.mustache

// licenseInfo.mustache

/**
 * Libre Graph API
 * Libre Graph is a free API for cloud collaboration inspired by the MS Graph API.
 *
 * The version of the OpenAPI document: v1.0.4
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "OAIQuota.h"

#include <QDebug>
#include <QJsonArray>
#include <QJsonDocument>
#include <QObject>

#include "OAIHelpers.h"

namespace OpenAPI {

class OAIQuotaPrivate {
    friend class OAIQuota;

     qint64 deleted;
     bool deleted_isSet;
     bool deleted_isValid;

     qint64 remaining;
     bool remaining_isSet;
     bool remaining_isValid;

     QString state;
     bool state_isSet;
     bool state_isValid;

     qint64 total;
     bool total_isSet;
     bool total_isValid;

     qint64 used;
     bool used_isSet;
     bool used_isValid;
};

OAIQuota::OAIQuota()
    : d_ptr()
{
}

OAIQuota::OAIQuota(const OAIQuota& other)
    : d_ptr(other.d_ptr)
{
}

OAIQuota::OAIQuota(QString json)
    : d_ptr(nullptr)
{
    this->fromJson(json);
}

OAIQuota::~OAIQuota() = default;

void OAIQuota::initializeModel() {
    if (d_ptr == nullptr) {
        d_ptr.reset(new OAIQuotaPrivate{});

        Q_D(OAIQuota);


        d->deleted_isSet = false;
        d->deleted_isValid = false;

        d->remaining_isSet = false;
        d->remaining_isValid = false;

        d->state_isSet = false;
        d->state_isValid = false;

        d->total_isSet = false;
        d->total_isValid = false;

        d->used_isSet = false;
        d->used_isValid = false;
    }
}

void OAIQuota::fromJson(QString jsonString) {
    QByteArray array(jsonString.toUtf8());
    QJsonDocument doc = QJsonDocument::fromJson(array);
    QJsonObject jsonObject = doc.object();
    this->fromJsonObject(jsonObject);
}

void OAIQuota::fromJsonObject(QJsonObject json) {
    initializeModel();

    Q_D(OAIQuota);

    d->deleted_isValid = ::OpenAPI::fromJsonValue(d->deleted, json[QString("deleted")]);
    d->deleted_isSet = !json[QString("deleted")].isNull() && d->deleted_isValid;

    d->remaining_isValid = ::OpenAPI::fromJsonValue(d->remaining, json[QString("remaining")]);
    d->remaining_isSet = !json[QString("remaining")].isNull() && d->remaining_isValid;

    d->state_isValid = ::OpenAPI::fromJsonValue(d->state, json[QString("state")]);
    d->state_isSet = !json[QString("state")].isNull() && d->state_isValid;

    d->total_isValid = ::OpenAPI::fromJsonValue(d->total, json[QString("total")]);
    d->total_isSet = !json[QString("total")].isNull() && d->total_isValid;

    d->used_isValid = ::OpenAPI::fromJsonValue(d->used, json[QString("used")]);
    d->used_isSet = !json[QString("used")].isNull() && d->used_isValid;
}

QString OAIQuota::asJson() const {
    QJsonObject obj = this->asJsonObject();
    QJsonDocument doc(obj);
    QByteArray bytes = doc.toJson();
    return QString(bytes);
}

QJsonObject OAIQuota::asJsonObject() const {
    Q_D(const OAIQuota);
    if(!d){
        return {};
    }
    QJsonObject obj;
    if (d->deleted_isSet) {
        obj.insert(QString("deleted"), ::OpenAPI::toJsonValue(d->deleted));
    }
    if (d->remaining_isSet) {
        obj.insert(QString("remaining"), ::OpenAPI::toJsonValue(d->remaining));
    }
    if (d->state_isSet) {
        obj.insert(QString("state"), ::OpenAPI::toJsonValue(d->state));
    }
    if (d->total_isSet) {
        obj.insert(QString("total"), ::OpenAPI::toJsonValue(d->total));
    }
    if (d->used_isSet) {
        obj.insert(QString("used"), ::OpenAPI::toJsonValue(d->used));
    }
    return obj;
}

qint64 OAIQuota::getDeleted() const {
    Q_D(const OAIQuota);
    if(!d){
        return {};
    }
    return d->deleted;
}
void OAIQuota::setDeleted(const qint64 &deleted) {
    Q_D(OAIQuota);
    Q_ASSERT(d);

    d->deleted = deleted;
    d->deleted_isSet = true;
}

bool OAIQuota::is_deleted_Set() const{
    Q_D(const OAIQuota);
    if(!d){
        return false;
    }

    return d->deleted_isSet;
}

bool OAIQuota::is_deleted_Valid() const{
    Q_D(const OAIQuota);
    if(!d){
        return false;
    }
    return d->deleted_isValid;
}

qint64 OAIQuota::getRemaining() const {
    Q_D(const OAIQuota);
    if(!d){
        return {};
    }
    return d->remaining;
}
void OAIQuota::setRemaining(const qint64 &remaining) {
    Q_D(OAIQuota);
    Q_ASSERT(d);

    d->remaining = remaining;
    d->remaining_isSet = true;
}

bool OAIQuota::is_remaining_Set() const{
    Q_D(const OAIQuota);
    if(!d){
        return false;
    }

    return d->remaining_isSet;
}

bool OAIQuota::is_remaining_Valid() const{
    Q_D(const OAIQuota);
    if(!d){
        return false;
    }
    return d->remaining_isValid;
}

QString OAIQuota::getState() const {
    Q_D(const OAIQuota);
    if(!d){
        return {};
    }
    return d->state;
}
void OAIQuota::setState(const QString &state) {
    Q_D(OAIQuota);
    Q_ASSERT(d);

    d->state = state;
    d->state_isSet = true;
}

bool OAIQuota::is_state_Set() const{
    Q_D(const OAIQuota);
    if(!d){
        return false;
    }

    return d->state_isSet;
}

bool OAIQuota::is_state_Valid() const{
    Q_D(const OAIQuota);
    if(!d){
        return false;
    }
    return d->state_isValid;
}

qint64 OAIQuota::getTotal() const {
    Q_D(const OAIQuota);
    if(!d){
        return {};
    }
    return d->total;
}
void OAIQuota::setTotal(const qint64 &total) {
    Q_D(OAIQuota);
    Q_ASSERT(d);

    d->total = total;
    d->total_isSet = true;
}

bool OAIQuota::is_total_Set() const{
    Q_D(const OAIQuota);
    if(!d){
        return false;
    }

    return d->total_isSet;
}

bool OAIQuota::is_total_Valid() const{
    Q_D(const OAIQuota);
    if(!d){
        return false;
    }
    return d->total_isValid;
}

qint64 OAIQuota::getUsed() const {
    Q_D(const OAIQuota);
    if(!d){
        return {};
    }
    return d->used;
}
void OAIQuota::setUsed(const qint64 &used) {
    Q_D(OAIQuota);
    Q_ASSERT(d);

    d->used = used;
    d->used_isSet = true;
}

bool OAIQuota::is_used_Set() const{
    Q_D(const OAIQuota);
    if(!d){
        return false;
    }

    return d->used_isSet;
}

bool OAIQuota::is_used_Valid() const{
    Q_D(const OAIQuota);
    if(!d){
        return false;
    }
    return d->used_isValid;
}

bool OAIQuota::isSet() const {
    Q_D(const OAIQuota);
    if(!d){
        return false;
    }
    bool isObjectUpdated = false;
    do {
        if (d->deleted_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->remaining_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->state_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->total_isSet) {
            isObjectUpdated = true;
            break;
        }

        if (d->used_isSet) {
            isObjectUpdated = true;
            break;
        }
    } while (false);
    return isObjectUpdated;
}

bool OAIQuota::isValid() const {
    Q_D(const OAIQuota);
    if(!d){
        return false;
    }
    // only required properties are required for the object to be considered valid
    return true;
}

} // namespace OpenAPI
