module Msf
  class Exploit
    class Remote
      module HTTP
        module SitecoreXp
          include Msf::Exploit::Remote::HttpClient
          include Msf::Exploit::Remote::HTTP::Sitecore::Error

          def initialize(info = {})
            super
            register_options([OptString.new('IDENTITY_VHOST', [true, 'Hostname of Sitecore identity server']) ])
          end
          
          #
          # Identifies against identity server. The Sitecore XP uses separate vhost to authenticate and gain session cookies.
          #
          def login_identitysrv(username, password)
            res = send_request_cgi({
              'uri' => normalize_uri(target_uri.path, 'Account', 'Login'),
              'method' => 'GET',
              'vhost' => datastore['IDENTITY_VHOST'],
              'keep_cookies' => 'true'
            })

            raise UnexpectedReplySitecore unless res&.code == 200

            hidden_inputs = res.get_hidden_inputs

            verification_token = hidden_inputs.dig(0, '__RequestVerificationToken')

            res = send_request_cgi({
              'method' => 'POST',
              'uri' => normalize_uri(target_uri.path, 'Account', 'Login'),
              'vhost' => datastore['IDENTITY_VHOST'],
              'vars_post' => {
                'Username' => username,
                'Password' => password,
                '__RequestVerificationToken' => verification_token,
                'ReturnUrl' => '',
                'AccountPrefix' => 'sitecore\\',
                'button' => 'login',
                'RememberLogin' => 'false'
              },
              'keep_cookies' => true
            })

            res&.code == 302 && !res.get_cookies.blank?
          end

          def get_identity_cookies
            res = send_request_cgi({
              'method' => 'POST',
              'uri' => normalize_uri('identity', 'externallogin'),
              'vars_get' => {
                'authenticationType' => 'SitecoreIdentityServer',
                'ReturnUrl' => '',
                'sc_site' => 'admin'
              },
              'keep_cookies' => true
            })
            return false unless res&.code == 302

            location_target = res.headers.fetch('Location', nil)

            return false unless location_target

            location_target =~ %r{://([a-zA-Z0-9._]+)/}
            identity_vhost = Regexp.last_match(1)
            proto = datastore['ssl'] ? 'https' : 'http'
            identity_uri = location_target.sub("#{proto}://#{identity_vhost}", '')

            res = send_request_cgi!({
              'method' => 'GET',
              'uri' => identity_uri,
              'vhost' => identity_vhost,
              'keep_cookies' => true
            })

            return false unless res&.code == 200

            hidden_inputs = res.get_hidden_inputs

            res = send_request_cgi({
              'method' => 'POST',
              'uri' => normalize_uri('identity', 'signin'),
              'vars_post' => hidden_inputs[0],
              'keep_cookies' => true
            })
            return false unless res&.code == 302

            res = send_request_cgi({
              'method' => 'GET',
              'uri' => normalize_uri('identity', 'externallogincallback'),
              'vars_get' => {
                'ReturnUrl' => '',
                'sc_site' => 'admin',
                'authenticationSource' => 'Default'
              },
              'keep_cookies' => true
            })

            res&.code == 302 && res.headers.fetch('Location', nil)&.include?('sitecore/admin')
          end
        
          def get_version
            res = send_request_cgi({
              'uri' => normalize_uri('sitecore', 'shell', 'sitecore.version.xml'),
              'method' => 'GET'
            })
            return nil unless res&.code == 200 && res.body.include?('<version>')

            xml_document = res.get_xml_document

            major_version = xml_document.at('information//version//major').text
            minor_version = xml_document.at('information//version//minor').text
            build_version = xml_document.at('information//version//build').text

            return Rex::Version.new("#{major_version}.#{minor_version}.#{build_version}")
          end
        end
      end
    end
  end
end
