# pylint: disable=line-too-long,useless-suppression
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from azure.identity import DefaultAzureCredential

from azure.mgmt.containerservice import ContainerServiceClient

"""
# PREREQUISITES
    pip install azure-identity
    pip install azure-mgmt-containerservice
# USAGE
    python machine_create_update.py

    Before run the sample, please set the values of the client ID, tenant ID and client secret
    of the AAD application as environment variables: AZURE_CLIENT_ID, AZURE_TENANT_ID,
    AZURE_CLIENT_SECRET. For more info about how to get the value, please see:
    https://docs.microsoft.com/azure/active-directory/develop/howto-create-service-principal-portal
"""


def main():
    client = ContainerServiceClient(
        credential=DefaultAzureCredential(),
        subscription_id="00000000-0000-0000-0000-000000000000",
    )

    response = client.machines.begin_create_or_update(
        resource_group_name="rg1",
        resource_name="clustername1",
        agent_pool_name="agentpool1",
        machine_name="machine1",
        parameters={
            "properties": {
                "hardware": {"vmSize": "Standard_DS1_v2"},
                "kubernetes": {
                    "kubeletDiskType": "OS",
                    "maxPods": 110,
                    "nodeLabels": {"key1": "val1"},
                    "nodeTaints": ["Key1=Value1:NoSchedule"],
                    "orchestratorVersion": "1.30",
                },
                "mode": "User",
                "operatingSystem": {"enableFIPS": False, "osSKU": "Ubuntu", "osType": "Linux"},
                "priority": "Spot",
                "tags": {"name1": "val1"},
            },
            "zones": ["1"],
        },
    ).result()
    print(response)


# x-ms-original-file: specification/containerservice/resource-manager/Microsoft.ContainerService/aks/preview/2025-09-02-preview/examples/MachineCreate_Update.json
if __name__ == "__main__":
    main()
