/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.config;

import com.sun.appserv.management.DomainRoot;
import com.sun.appserv.management.base.Util;
import com.sun.appserv.management.client.ProxyFactory;
import java.io.File;
import java.lang.reflect.Constructor;
import javax.management.MBeanServer;
import javax.management.ObjectName;

public final class OfflineConfigIniter {
    private final MBeanServer mServer;
    private final File mDomainXML;
    private final ObjectName mLoader;
    private final DomainRoot mDomainRoot;
    private static final String LOADER_CLASSNAME = "com.sun.enterprise.management.offline.OfflineLoader";
    private final Class[] LOADER_CONSTRUCTOR_SIG = new Class[]{MBeanServer.class, File.class};
    public static final String NAME = "offline-mbean-loader";

    public OfflineConfigIniter(MBeanServer server, File domainXML) {
        this.mServer = server;
        this.mDomainXML = domainXML;
        this.mLoader = this.initLoader();
        this.mDomainRoot = ProxyFactory.getInstance(server).getDomainRoot();
    }

    public DomainRoot getDomainRoot() {
        return this.mDomainRoot;
    }

    private ObjectName initLoader() {
        ObjectName loaderObjectName = null;
        try {
            Class<?> loaderClass = Class.forName(LOADER_CLASSNAME);
            Constructor<?> constructor = loaderClass.getConstructor(this.LOADER_CONSTRUCTOR_SIG);
            Object loader = constructor.newInstance(this.mServer, this.mDomainXML);
            String domain = "amx-support";
            loaderObjectName = Util.newObjectName("amx-support", Util.makeNameProp(NAME));
            loaderObjectName = this.mServer.registerMBean(loader, loaderObjectName).getObjectName();
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new RuntimeException(t);
        }
        return loaderObjectName;
    }
}

